/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.adapters;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StringMTag
implements MTag {
    private static final boolean DEBUG = false;
    String name;
    StringMTag parent;
    Object clientData;
    HashMap<String, MTag.Attribute> mAttrList = new HashMap();
    ArrayList<MTag> mChildren = new ArrayList();

    @Override
    public String toString() {
        return "MTag (" + this.name + " )";
    }

    @Override
    public String getTagName() {
        return this.name;
    }

    @Override
    public void setClientData(String type, Object clientData) {
        this.clientData = clientData;
    }

    @Override
    public Object getClientData(String type) {
        return this.clientData;
    }

    @Override
    public ArrayList<MTag> getChildren() {
        return this.mChildren;
    }

    @Override
    public HashMap<String, MTag.Attribute> getAttrList() {
        return this.mAttrList;
    }

    public StringMTag[] getChildTags() {
        return this.mChildren.toArray(new StringMTag[0]);
    }

    @Override
    public MTag getParent() {
        return this.parent;
    }

    @Override
    public MTag[] getChildTags(String type) {
        ArrayList<MTag> filter2 = new ArrayList<MTag>();
        for (MTag child : this.mChildren) {
            if (!child.getTagName().equals(type)) continue;
            filter2.add(child);
        }
        return filter2.toArray(new MTag[0]);
    }

    @Override
    public MTag[] getChildTags(String attribute, String value2) {
        ArrayList<MTag> filter2 = new ArrayList<MTag>();
        for (MTag child : this.mChildren) {
            String childValue = child.getAttributeValue(attribute);
            if (childValue == null || !childValue.endsWith(value2)) continue;
            filter2.add(child);
        }
        return filter2.toArray(new MTag[0]);
    }

    @Override
    public MTag[] getChildTags(String type, String attribute, String value2) {
        ArrayList<MTag> filter2 = new ArrayList<MTag>();
        for (MTag child : this.mChildren) {
            String childValue;
            if (!child.getTagName().equals(type) || (childValue = child.getAttributeValue(attribute)) == null || !childValue.endsWith(value2)) continue;
            filter2.add(child);
        }
        return filter2.toArray(new MTag[0]);
    }

    @Override
    public MTag getChildTagWithTreeId(String type, String treeId) {
        for (MTag child : this.mChildren) {
            if (!treeId.equals(child.getTreeId())) continue;
            return child;
        }
        return null;
    }

    @Override
    public String getTreeId() {
        if (this.name.startsWith("Key")) {
            return this.getAttributeValue("framePosition") + "|" + this.name;
        }
        if (this.name.equals("Transition")) {
            return this.getAttributeValue("constraintSetStart") + "|" + this.getAttributeValue("constraintSetEnd");
        }
        return this.getAttributeValue("id");
    }

    @Override
    public String getAttributeValue(String attribute) {
        for (MTag.Attribute value2 : this.mAttrList.values()) {
            if (!value2.mAttribute.equals(attribute)) continue;
            return value2.mValue;
        }
        return null;
    }

    @Override
    public void print(String space) {
        System.out.println("\n" + space + "<" + this.name + ">");
        for (MTag.Attribute value2 : this.mAttrList.values()) {
            System.out.println(space + "   " + value2.mAttribute + "=\"" + value2.mValue + "\"");
        }
        for (MTag child : this.mChildren) {
            child.print(space + "   ");
        }
        System.out.println(space + "</" + this.name + ">");
    }

    @Override
    public String toXmlString() {
        return this.toFormalXmlString("");
    }

    @Override
    public String toFormalXmlString(String space) {
        String ret2 = "";
        if (space == null) {
            ret2 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
            space = "";
        }
        ret2 = ret2 + "\n" + space + "<" + this.name;
        MTag.Attribute[] attr = this.mAttrList.values().toArray(new MTag.Attribute[0]);
        Arrays.sort(attr, new Comparator<MTag.Attribute>(){

            @Override
            public int compare(MTag.Attribute o1, MTag.Attribute o2) {
                return o1.mAttribute.compareTo(o2.mAttribute);
            }
        });
        for (MTag.Attribute value2 : attr) {
            String nameSpace = value2.mNamespace;
            if (nameSpace.startsWith("http")) {
                if (nameSpace.endsWith("res-auto")) {
                    nameSpace = "motion";
                }
                if (nameSpace.endsWith("android")) {
                    nameSpace = "android";
                }
            }
            ret2 = ret2 + "\n" + space + "   " + nameSpace + ":" + value2.mAttribute + "=\"" + value2.mValue + "\"";
        }
        ret2 = this.mChildren.size() == 0 ? ret2 + " />\n" : ret2 + " >\n";
        for (MTag child : this.mChildren) {
            ret2 = ret2 + child.toFormalXmlString(space + "  ");
        }
        if (this.mChildren.size() > 0) {
            ret2 = ret2 + space + "</" + this.name + ">\n";
        }
        return ret2;
    }

    @Override
    public void printFormal(String space, PrintStream out) {
        if (space == null) {
            out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            space = "";
        }
        out.print("\n" + space + "<" + this.name);
        for (MTag.Attribute value2 : this.mAttrList.values()) {
            out.print("\n" + space + "   " + value2.mNamespace + ":" + value2.mAttribute + "=\"" + value2.mValue + "\"");
        }
        out.println(" >");
        for (MTag child : this.mChildren) {
            child.printFormal(space + "  ", out);
        }
        out.println(space + "</" + this.name + ">");
    }

    public static StringMTag parse(String str) {
        final HashSet props = new HashSet();
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(str.getBytes(Charset.forName("UTF-8")));
            SAXParserFactory factory2 = SAXParserFactory.newInstance();
            SAXParser saxParser = factory2.newSAXParser();
            saxParser.parse((InputStream)inputStream, new DefaultHandler(){
                StringMTag currentTag = null;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    StringMTag newTag = this.currentTag == null ? new RootTag(null) : new StringMTag();
                    newTag.parent = this.currentTag;
                    newTag.name = qName;
                    if (this.currentTag != null) {
                        this.currentTag.mChildren.add(newTag);
                    } else {
                        props.add(newTag);
                    }
                    this.currentTag = newTag;
                    for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                        String aName = attributes.getQName(i2);
                        MTag.Attribute attribute = new MTag.Attribute();
                        String[] sp = aName.split(":");
                        if (sp.length != 2) continue;
                        attribute.mAttribute = sp[1];
                        attribute.mNamespace = sp[0];
                        attribute.mValue = attributes.getValue(i2);
                        this.currentTag.mAttrList.put(aName, attribute);
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (this.currentTag != null) {
                        this.currentTag = this.currentTag.parent;
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (StringMTag)props.iterator().next();
    }

    @Override
    public MTag.TagWriter getChildTagWriter(String name) {
        return null;
    }

    @Override
    public MTag.TagWriter getTagWriter() {
        return null;
    }

    static class RootTag
    extends StringMTag {
        File mSourceFile;

        RootTag(File file2) {
            this.mSourceFile = file2;
        }
    }
}

