/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NlComponentTag
implements MTag {
    NlComponent mComponent;
    NlComponentTag mParent;
    private static final boolean DEBUG = false;

    public NlComponentTag(NlComponent component, NlComponentTag parent) {
        this.mComponent = component;
        this.mParent = parent;
    }

    public NlComponent getComponent() {
        return this.mComponent;
    }

    @Override
    public String getTagName() {
        return this.mComponent.getTagName();
    }

    @Override
    public MTag getParent() {
        return this.mParent;
    }

    @Override
    public void setClientData(String type, Object motionAttributes) {
        this.mComponent.putClientProperty(type, motionAttributes);
    }

    @Override
    public Object getClientData(String type) {
        return this.mComponent.getClientProperty(type);
    }

    @Override
    public ArrayList<MTag> getChildren() {
        ArrayList<MTag> ret2 = new ArrayList<MTag>();
        List<NlComponent> ch = this.mComponent.getChildren();
        for (NlComponent component : ch) {
            ret2.add(new NlComponentTag(component, this));
        }
        return ret2;
    }

    @Override
    public HashMap<String, MTag.Attribute> getAttrList() {
        HashMap<String, MTag.Attribute> ret2 = new HashMap<String, MTag.Attribute>();
        List<AttributeSnapshot> att = this.mComponent.getAttributes();
        for (AttributeSnapshot attribute : att) {
            MTag.Attribute a = new MTag.Attribute();
            a.mAttribute = attribute.name;
            a.mNamespace = attribute.namespace;
            a.mValue = attribute.value;
            ret2.put(a.mAttribute, a);
        }
        return ret2;
    }

    @Override
    public MTag[] getChildTags() {
        return this.getChildren().toArray(new MTag[0]);
    }

    @Override
    public MTag[] getChildTags(String type) {
        ArrayList<MTag> ret2 = new ArrayList<MTag>();
        for (MTag child : this.getChildren()) {
            if (!child.getTagName().equals(type)) continue;
            ret2.add(child);
        }
        return ret2.toArray(new MTag[0]);
    }

    @Override
    public MTag[] getChildTags(String attribute, String value2) {
        ArrayList<MTag> ret2 = new ArrayList<MTag>();
        for (MTag child : this.getChildren()) {
            if (!value2.equals(child.getAttributeValue(attribute))) continue;
            ret2.add(child);
        }
        return ret2.toArray(new MTag[0]);
    }

    @Override
    public MTag[] getChildTags(String type, String attribute, String value2) {
        ArrayList<MTag> ret2 = new ArrayList<MTag>();
        for (MTag child : this.getChildren()) {
            if (!child.getTagName().equals(type) || !value2.equals(child.getAttributeValue(attribute))) continue;
            ret2.add(child);
        }
        return ret2.toArray(new MTag[0]);
    }

    @Override
    public MTag getChildTagWithTreeId(String type, String treeId) {
        for (MTag child : this.getChildren()) {
            if (!child.getTreeId().equals(treeId)) continue;
            return child;
        }
        return null;
    }

    @Override
    public String getTreeId() {
        return this.mComponent.getId();
    }

    @Override
    public String getAttributeValue(String attribute) {
        for (AttributeSnapshot componentAttribute : this.mComponent.getAttributes()) {
            if (!componentAttribute.name.equals(attribute)) continue;
            return componentAttribute.value;
        }
        return null;
    }

    @Override
    public void print(String space) {
        System.out.println("\n" + space + "<" + this.getTagName() + ">");
        for (AttributeSnapshot value2 : this.mComponent.getAttributes()) {
            System.out.println(space + "   " + value2.name + "=\"" + value2.value + "\"");
        }
        for (MTag child : this.getChildTags()) {
            child.print(space + "   ");
        }
        System.out.println(space + "</" + this.getTagName() + ">");
    }

    @Override
    public String toXmlString() {
        return this.toFormalXmlString("");
    }

    @Override
    public String toFormalXmlString(String space) {
        String ret2 = "";
        if (space == null) {
            ret2 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
            space = "";
        }
        ret2 = ret2 + "\n" + space + "<" + this.getTagName();
        for (AttributeSnapshot value2 : this.mComponent.getAttributes()) {
            ret2 = ret2 + "\n" + space + "   " + value2.namespace + ":" + value2.name + "=\"" + value2.value + "\"";
        }
        ret2 = ret2 + " >\n";
        for (MTag child : this.getChildTags()) {
            ret2 = ret2 + child.toFormalXmlString(space + "  ");
        }
        ret2 = ret2 + space + "</" + this.getTagName() + ">\n";
        return ret2;
    }

    @Override
    public void printFormal(String space, PrintStream out) {
        if (space == null) {
            out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            space = "";
        }
        out.print("\n" + space + "<" + this.getTagName());
        for (AttributeSnapshot value2 : this.mComponent.getAttributes()) {
            out.print("\n" + space + "   " + value2.namespace + ":" + value2.name + "=\"" + value2.value + "\"");
        }
        out.println(" >");
        for (MTag child : this.getChildTags()) {
            child.printFormal(space + "  ", out);
        }
        out.println(space + "</" + this.getTagName() + ">");
    }

    @Override
    public MTag.TagWriter getChildTagWriter(String name) {
        return null;
    }

    @Override
    public MTag.TagWriter getTagWriter() {
        return null;
    }
}

