/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.targets;

import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawGuidelineCycle;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.GuidelineTarget;
import java.awt.Cursor;
import java.util.List;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class GuidelineCycleTarget
extends GuidelineTarget {
    public GuidelineCycleTarget(boolean isHorizontal) {
        super(isHorizontal);
    }

    @Override
    public boolean canChangeSelection() {
        return false;
    }

    @Override
    public int getPreferenceLevel() {
        return 40;
    }

    @Override
    public Cursor getMouseCursor(@JdkConstants.InputEventMask int modifiersEx) {
        return Cursor.getPredefinedCursor(12);
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        int size = 16;
        if (this.myIsHorizontal) {
            this.myLeft = l - size;
            this.myTop = (float)t - (float)size / 2.0f;
            this.myRight = l;
            this.myBottom = (float)t + (float)size / 2.0f;
        } else {
            this.myLeft = (float)l - (float)size / 2.0f;
            this.myTop = t - size;
            this.myRight = (float)l + (float)size / 2.0f;
            this.myBottom = t;
        }
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneTransform) {
        int mode = ConstraintComponentUtilities.getGuidelineMode(this.myComponent);
        DrawGuidelineCycle.add(list, sceneTransform, this.myIsHorizontal, this.myLeft, this.myTop, this.myRight, this.myBottom, mode, this.myComponent.isSelected());
    }

    @Override
    public void mouseDown(int x, int y) {
        super.mouseDown(x, y);
        this.myComponent.setSelected(true);
    }

    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> closestTargets) {
        super.mouseRelease(x, y, closestTargets);
        if (Math.abs(x - this.myFirstMouseX) > 1 || Math.abs(y - this.myFirstMouseY) > 1) {
            return;
        }
        NlComponent component = this.myComponent.getAuthoritativeNlComponent();
        AttributesTransaction attributes = component.startAttributeTransaction();
        String begin = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin");
        String end = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end");
        String percent = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent");
        SceneComponent parent = this.myComponent.getParent();
        assert (parent != null);
        int value2 = this.myComponent.getDrawY() - parent.getDrawY();
        int dimension2 = parent.getDrawHeight();
        if (!this.myIsHorizontal) {
            value2 = this.myComponent.getDrawX() - parent.getDrawX();
            dimension2 = parent.getDrawWidth();
        }
        if (begin != null) {
            GuidelineCycleTarget.setEnd(attributes, dimension2 - value2);
        } else if (end != null) {
            GuidelineCycleTarget.setPercent(attributes, (float)value2 / (float)dimension2);
        } else if (percent != null) {
            GuidelineCycleTarget.setBegin(attributes, value2);
        }
        attributes.apply();
        NlWriteCommandActionUtil.run(component, "Cycle Guideline", attributes::commit);
    }

    @Override
    protected void updateAttributes(@NotNull NlAttributesHolder attributes, int x, int y) {
        String begin = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin");
        String end = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end");
        String percent = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent");
        SceneComponent parent = this.myComponent.getParent();
        assert (parent != null);
        int value2 = y - parent.getDrawY();
        float dimension2 = parent.getDrawHeight();
        if (!this.myIsHorizontal) {
            value2 = x - parent.getDrawX();
            dimension2 = parent.getDrawWidth();
        }
        if (begin != null) {
            String position = String.format("%ddp", value2);
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", position);
        } else if (end != null) {
            String position = String.format("%ddp", (int)dimension2 - value2);
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end", position);
        } else if (percent != null) {
            String percentStringValue;
            float percentValue = (float)value2 / dimension2;
            if (percentValue > 1.0f) {
                percentValue = 1.0f;
            }
            if (percentValue < 0.0f) {
                percentValue = 0.0f;
            }
            if ((percentStringValue = String.valueOf(percentValue = (float)Math.round(percentValue * 100.0f) / 100.0f)).equalsIgnoreCase("NaN")) {
                percentStringValue = "0.5";
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent", percentStringValue);
        }
        ConstraintComponentUtilities.cleanup(attributes, this.myComponent.getNlComponent());
    }

    private static void setBegin(AttributesTransaction transaction, int value2) {
        String position = String.format("%ddp", value2);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", position);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end", null);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent", null);
    }

    private static void setEnd(AttributesTransaction transaction, int value2) {
        String position = String.format("%ddp", value2);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", null);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end", position);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent", null);
    }

    private static void setPercent(AttributesTransaction transaction, float value2) {
        String position = String.valueOf(value2);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", null);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end", null);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent", position);
    }

    @Override
    public String getToolTipText() {
        return "Cycle Guideline";
    }
}

