/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawCommand;
import com.android.tools.idea.common.scene.draw.FancyStroke;
import com.android.tools.idea.uibuilder.handlers.constraint.SecondarySelector;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnectionUtils;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;

public class DrawConnection
implements DrawCommand {
    public static final int TYPE_NORMAL = 1;
    public static final int TYPE_SPRING = 2;
    public static final int TYPE_CHAIN = 3;
    public static final int TYPE_CENTER = 4;
    public static final int TYPE_BASELINE = 5;
    public static final int TYPE_CENTER_WIDGET = 6;
    public static final int TYPE_ADJACENT = 7;
    private static final long MILISECONDS = 1000000L;
    public static final int MODE_COMPUTED = 7;
    public static final int MODE_SUBDUED = 1;
    public static final int MODE_NORMAL = 0;
    public static final int MODE_WILL_HOVER = 3;
    public static final int MODE_VIEW_SELECTED = 2;
    public static final int MODE_CONSTRAINT_SELECTED = 5;
    public static final int MODE_DELETING = 6;
    public static final int HOVER_FLAG = 256;
    public static final int HOVER_MASK = -257;
    public static final int TOTAL_MODES = 3;
    private static int[] ourModeLookup = null;
    public static final int DIR_LEFT = 0;
    public static final int DIR_RIGHT = 1;
    public static final int DIR_TOP = 2;
    public static final int DIR_BOTTOM = 3;
    private static final int OVER_HANG = 20;
    private static final long TRANSITION_TIME = 1000000000L;
    static GeneralPath ourPath = new GeneralPath();
    static final int[] dirDeltaX = new int[]{-1, 1, 0, 0};
    static final int[] dirDeltaY = new int[]{0, 0, -1, 1};
    static final int[] ourOppositeDirection = new int[]{1, 0, 3, 2};
    public static final int GAP = JBUI.scale((int)10);
    int myConnectionType;
    SecondarySelector mySecondarySelector;
    Rectangle mySource = new Rectangle();
    int mySourceDirection;
    Rectangle myDest = new Rectangle();
    int myDestDirection;
    public static final int DEST_NORMAL = 0;
    public static final int DEST_PARENT = 1;
    public static final int DEST_GUIDELINE = 2;
    int myDestType;
    boolean myShift;
    int myMargin;
    int myMarginDistance;
    boolean myIsMarginReference;
    float myBias;
    int myModeFrom;
    int myModeTo;
    long myStateChangeTime;
    static Stroke myBackgroundStroke = new BasicStroke(JBUI.scale((int)8));
    static Stroke myDashStroke = new BasicStroke(1.0f, 0, 1, 10.0f, new float[]{JBUI.scale((int)4), JBUI.scale((int)6)}, 0.0f);
    static Stroke mySpringStroke = new BasicStroke(1.0f, 0, 1, 10.0f, new float[]{JBUI.scale((int)4), JBUI.scale((int)4)}, 0.0f);
    static Stroke myChainStroke1 = new FancyStroke(FancyStroke.Type.HALF_CHAIN1, JBUI.scale((float)2.5f), JBUI.scale((int)9), 1.0f);
    static Stroke myChainStroke2 = new FancyStroke(FancyStroke.Type.HALF_CHAIN2, JBUI.scale((float)2.5f), JBUI.scale((int)9), 1.0f);
    static Stroke myNormalStroke = new BasicStroke(JBUI.scale((int)1));
    static Stroke myHoverStroke = new BasicStroke(JBUI.scale((int)12), 0, 1);
    static Stroke myThickDashStroke = new BasicStroke(2.0f, 0, 1, 10.0f, new float[]{JBUI.scale((int)4), JBUI.scale((int)6)}, 0.0f);
    static Stroke myThickSpringStroke = new BasicStroke(2.0f, 0, 1, 10.0f, new float[]{JBUI.scale((int)4), JBUI.scale((int)4)}, 0.0f);
    static Stroke myThickChainStroke1 = new FancyStroke(FancyStroke.Type.HALF_CHAIN1, JBUI.scale((float)2.5f), JBUI.scale((int)9), 2.0f);
    static Stroke myThickChainStroke2 = new FancyStroke(FancyStroke.Type.HALF_CHAIN2, JBUI.scale((float)2.5f), JBUI.scale((int)9), 2.0f);
    static Stroke myThickNormalStroke = new BasicStroke(JBUI.scale((int)2));

    @Override
    public int getLevel() {
        switch (this.myModeTo) {
            case 6: {
                return 70;
            }
            case 2: {
                return 40;
            }
            case 3: {
                return 60;
            }
        }
        return 10;
    }

    @Override
    public String serialize() {
        return "DrawConnection," + this.myConnectionType + "," + DrawConnection.rectToString(this.mySource) + "," + this.mySourceDirection + "," + DrawConnection.rectToString(this.myDest) + "," + this.myDestDirection + "," + this.myDestType + "," + this.myShift + "," + this.myMargin + "," + this.myMarginDistance + "," + this.myIsMarginReference + "," + this.myBias + "," + this.myModeFrom + "," + this.myModeTo + "," + 0;
    }

    private static String rectToString(Rectangle r) {
        return r.x + "x" + r.y + "x" + r.width + "x" + r.height;
    }

    private static Rectangle stringToRect(String s) {
        String[] sp = s.split("x");
        int c = 0;
        Rectangle r = new Rectangle();
        r.x = Integer.parseInt(sp[c++]);
        r.y = Integer.parseInt(sp[c++]);
        r.width = Integer.parseInt(sp[c++]);
        r.height = Integer.parseInt(sp[c++]);
        return r;
    }

    public DrawConnection(String s) {
        String[] sp = s.split(",");
        int c = 0;
        this.myConnectionType = Integer.parseInt(sp[c++]);
        this.mySource = DrawConnection.stringToRect(sp[c++]);
        this.mySourceDirection = Integer.parseInt(sp[c++]);
        this.myDest = DrawConnection.stringToRect(sp[c++]);
        this.myDestDirection = Integer.parseInt(sp[c++]);
        this.myDestType = Integer.parseInt(sp[c++]);
        this.myShift = Boolean.parseBoolean(sp[c++]);
        this.myMargin = Integer.parseInt(sp[c++]);
        this.myMarginDistance = Integer.parseInt(sp[c++]);
        this.myIsMarginReference = Boolean.parseBoolean(sp[c++]);
        this.myBias = Float.parseFloat(sp[c++]);
        this.myModeFrom = Integer.parseInt(sp[c++]);
        this.myModeTo = Integer.parseInt(sp[c++]);
        this.myStateChangeTime = Long.parseLong(sp[c++]);
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet color = sceneContext.getColorSet();
        ScenePicker picker = sceneContext.getScenePicker();
        SecondarySelector secondarySelector = this.mySecondarySelector;
        g.setColor(color.getConstraints());
        boolean animate = DrawConnection.draw(g, color, picker, secondarySelector, this.myConnectionType, this.mySource, this.mySourceDirection, this.myDest, this.myDestDirection, this.myDestType, this.myMargin, this.myMarginDistance, this.myIsMarginReference, this.myModeFrom, this.myModeTo, this.myStateChangeTime);
        if (animate) {
            sceneContext.repaint();
        }
    }

    public DrawConnection(SecondarySelector selector, int connectionType, Rectangle source, int sourceDirection, Rectangle dest, int destDirection, int destType, boolean shift, int margin, int marginDistance, boolean isMarginReference, Float bias, int modeFrom, int modeTo, long nanoTime) {
        this.config(selector, connectionType, source, sourceDirection, dest, destDirection, destType, shift, margin, marginDistance, isMarginReference, bias, modeFrom, modeTo, nanoTime);
    }

    public static void buildDisplayList(DisplayList list, SecondarySelector selector, int connectionType, Rectangle source, int sourceDirection, Rectangle dest, int destDirection, int destType, boolean shift, int margin, int marginDistance, boolean isMarginReference, Float bias, int modeFrom, int modeTo, long nanoTime) {
        list.add(new DrawConnection(selector, connectionType, source, sourceDirection, dest, destDirection, destType, shift, margin, marginDistance, isMarginReference, bias, modeFrom, modeTo, nanoTime));
    }

    public void config(SecondarySelector selector, int connectionType, Rectangle source, int sourceDirection, Rectangle dest, int destDirection, int destType, boolean shift, int margin, int marginDistance, boolean isMarginReference, Float bias, int modeFrom, int modeTo, long stateChangeTime) {
        this.mySecondarySelector = selector;
        this.mySource.setBounds(source);
        this.myDest.setBounds(dest);
        this.myConnectionType = connectionType;
        this.mySource.setBounds(source);
        this.mySourceDirection = sourceDirection;
        this.myDest.setBounds(dest);
        this.myDestDirection = destDirection;
        this.myDestType = destType;
        this.myShift = shift;
        this.myMargin = margin;
        this.myMarginDistance = marginDistance;
        this.myIsMarginReference = isMarginReference;
        this.myBias = bias.floatValue();
        this.myModeFrom = modeFrom;
        this.myModeTo = modeTo;
        this.myStateChangeTime = stateChangeTime;
    }

    public static Color modeGetConstraintsColor(int mode, ColorSet color) {
        switch (mode &= 0xFFFFFEFF) {
            case 0: {
                return color.getConstraints();
            }
            case 2: {
                return color.getSelectedConstraints();
            }
            case 7: {
                return color.getCreatedConstraints();
            }
            case 6: {
                return color.getAnchorDisconnectionCircle();
            }
            case 1: {
                return color.getSubduedConstraints();
            }
            case 5: {
                return color.getSelectedConstraints();
            }
            case 3: {
                return color.getLassoSelectionFill();
            }
        }
        return color.getConstraints();
    }

    static Stroke getStroke(StrokeType strokeType, boolean flip_chain, int mode) {
        boolean thick = mode == 6 || mode == 5 || mode == 7;
        switch (strokeType) {
            case CHAIN: {
                if (thick) {
                    return flip_chain ? myThickChainStroke1 : myThickChainStroke2;
                }
                return flip_chain ? myChainStroke1 : myChainStroke2;
            }
            case SPRING: {
                return thick ? myThickSpringStroke : mySpringStroke;
            }
            case DASH: {
                return thick ? myThickDashStroke : myDashStroke;
            }
            case NORMAL: {
                return thick ? myThickNormalStroke : myNormalStroke;
            }
        }
        return thick ? myThickNormalStroke : myNormalStroke;
    }

    public static Color modeGetMarginColor(int mode, ColorSet color) {
        switch (mode) {
            case 0: {
                return color.getMargins();
            }
            case 2: {
                return color.getConstraints();
            }
            case 7: {
                return color.getHighlightedConstraints();
            }
            case 1: {
                return color.getSubduedConstraints();
            }
        }
        return color.getMargins();
    }

    static Color interpolate(Color fromColor, Color toColor, float percent) {
        int col1 = fromColor.getRGB();
        int col2 = toColor.getRGB();
        int c1 = (int)((float)(col1 >> 0 & 0xFF) * (1.0f - percent) + (float)(col2 >> 0 & 0xFF) * percent);
        int c2 = (int)((float)(col1 >> 8 & 0xFF) * (1.0f - percent) + (float)(col2 >> 8 & 0xFF) * percent);
        int c3 = (int)((float)(col1 >> 16 & 0xFF) * (1.0f - percent) + (float)(col2 >> 16 & 0xFF) * percent);
        return new Color(c3, c2, c1);
    }

    public static boolean draw(Graphics2D g, ColorSet color, ScenePicker picker, SecondarySelector secondarySelector, int connectionType, Rectangle source, int sourceDirection, Rectangle dest, int destDirection, int myDestType, int margin, int marginDistance, boolean isMarginReference, int modeFrom, int modeTo, long stateChange) {
        Object originalClip = null;
        boolean animate = false;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color constraintColor = DrawConnection.modeGetConstraintsColor(modeTo, color);
        Color marginColor = DrawConnection.modeGetMarginColor(modeTo, color);
        long timeSince = System.nanoTime() - stateChange;
        boolean hover = (0x100 & modeTo) > 0 || modeTo == 5;
        modeTo &= 0xFFFFFEFF;
        if (timeSince < 1000000000L) {
            float t = (float)((double)timeSince / 1.0E9);
            Color fromColor = DrawConnection.modeGetConstraintsColor(modeFrom, color);
            Color toColor = DrawConnection.modeGetConstraintsColor(modeTo, color);
            constraintColor = DrawConnection.interpolate(fromColor, toColor, t);
            animate = true;
        }
        if (connectionType == 5) {
            Color hoverColor = DrawConnection.modeGetConstraintsColor(3, color);
            DrawConnection.drawBaseLine(g, source, dest, constraintColor, hoverColor, picker, secondarySelector, hover);
            return animate;
        }
        int startx = DrawConnection.getConnectionX(sourceDirection, source);
        int starty = DrawConnection.getConnectionY(sourceDirection, source);
        int endx = DrawConnection.getConnectionX(destDirection, dest);
        int endy = DrawConnection.getConnectionY(destDirection, dest);
        int dx = DrawConnection.getDestinationDX(destDirection);
        int dy = DrawConnection.getDestinationDY(destDirection);
        int manhattanDistance = Math.abs(startx - endx) + Math.abs(starty - endy);
        int scale_source = Math.min(90, manhattanDistance);
        int scale_dest = myDestType == 1 ? -scale_source : scale_source;
        boolean flip_arrow = false;
        if (myDestType != 0) {
            switch (destDirection) {
                case 2: 
                case 3: {
                    endx = startx;
                    break;
                }
                case 0: 
                case 1: {
                    endy = starty;
                }
            }
        } else if (sourceDirection == destDirection) {
            switch (destDirection) {
                case 3: {
                    if (endy - 1 <= starty) break;
                    scale_dest *= -1;
                    dy *= -1;
                    flip_arrow = true;
                    break;
                }
                case 2: {
                    if (endy >= starty) break;
                    scale_dest *= -1;
                    dy *= -1;
                    flip_arrow = true;
                    break;
                }
                case 0: {
                    if (endx >= startx) break;
                    scale_dest *= -1;
                    dx *= -1;
                    flip_arrow = true;
                    break;
                }
                case 1: {
                    if (endx - 1 <= startx) break;
                    scale_dest *= -1;
                    dx *= -1;
                    flip_arrow = true;
                }
            }
        }
        int[] xPoints = new int[3];
        int[] yPoints = new int[3];
        int dir = myDestType == 1 ^ flip_arrow ? ourOppositeDirection[destDirection] : destDirection;
        ourPath.reset();
        ourPath.moveTo(startx, starty);
        if (manhattanDistance == 0) {
            g.setColor(constraintColor);
            DrawConnectionUtils.getArrow(dir, endx, endy, xPoints, yPoints);
            g.fillPolygon(xPoints, yPoints, 3);
            g.draw(ourPath);
            ourPath.reset();
            ourPath.moveTo(startx, starty);
        }
        Stroke defaultStroke = g.getStroke();
        g.setStroke(DrawConnection.getStroke(StrokeType.NORMAL, false, modeTo));
        switch (connectionType) {
            case 3: {
                boolean flip_chain;
                boolean bl = flip_chain = endx + endy > startx + starty;
                if (flip_chain) {
                    float y4;
                    float x4;
                    float y3;
                    float x3;
                    float y2;
                    float x2;
                    float y1;
                    float x1;
                    if (hover) {
                        GeneralPath hoverPath = new GeneralPath(ourPath);
                        g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                        Stroke tmpStroke = g.getStroke();
                        g.setStroke(myHoverStroke);
                        x1 = startx;
                        y1 = starty;
                        hoverPath.moveTo(x1, y1);
                        x2 = startx + scale_source * dirDeltaX[sourceDirection];
                        y2 = starty + scale_source * dirDeltaY[sourceDirection];
                        x3 = endx + scale_dest * dirDeltaX[destDirection];
                        y3 = endy + scale_dest * dirDeltaY[destDirection];
                        x4 = endx;
                        y4 = endy;
                        hoverPath.curveTo(x2, y2, x3, y3, x4, y4);
                        g.draw(hoverPath);
                        hoverPath.reset();
                        g.setStroke(tmpStroke);
                    }
                    x1 = startx;
                    y1 = starty;
                    ourPath.moveTo(x1, y1);
                    x2 = startx + scale_source * dirDeltaX[sourceDirection];
                    y2 = starty + scale_source * dirDeltaY[sourceDirection];
                    x3 = endx + scale_dest * dirDeltaX[destDirection];
                    y3 = endy + scale_dest * dirDeltaY[destDirection];
                    x4 = endx;
                    y4 = endy;
                    ourPath.curveTo(x2, y2, x3, y3, x4, y4);
                    if (picker != null && secondarySelector != null) {
                        picker.addCurveTo(secondarySelector, 4, (int)x1, (int)y1, (int)x2, (int)y2, (int)x3, (int)y3, (int)x4, (int)y4, 4);
                    }
                } else {
                    float y4;
                    float x4;
                    float y3;
                    float x3;
                    float y2;
                    float x2;
                    float y1;
                    float x1;
                    if (hover) {
                        GeneralPath hoverPath = new GeneralPath(ourPath);
                        g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                        Stroke tmpStroke = g.getStroke();
                        g.setStroke(myHoverStroke);
                        x1 = endx;
                        y1 = endy;
                        hoverPath.moveTo(x1, y1);
                        x2 = endx + scale_source * dirDeltaX[destDirection];
                        y2 = endy + scale_source * dirDeltaY[destDirection];
                        x3 = startx + scale_dest * dirDeltaX[sourceDirection];
                        y3 = starty + scale_dest * dirDeltaY[sourceDirection];
                        x4 = startx;
                        y4 = starty;
                        hoverPath.curveTo(x2, y2, x3, y3, x4, y4);
                        g.draw(hoverPath);
                        hoverPath.reset();
                        g.setStroke(tmpStroke);
                    }
                    x1 = endx;
                    y1 = endy;
                    ourPath.moveTo(x1, y1);
                    x2 = endx + scale_source * dirDeltaX[destDirection];
                    y2 = endy + scale_source * dirDeltaY[destDirection];
                    x3 = startx + scale_dest * dirDeltaX[sourceDirection];
                    y3 = starty + scale_dest * dirDeltaY[sourceDirection];
                    x4 = startx;
                    y4 = starty;
                    ourPath.curveTo(x2, y2, x3, y3, x4, y4);
                    if (picker != null && secondarySelector != null) {
                        picker.addCurveTo(secondarySelector, 4, (int)x1, (int)y1, (int)x2, (int)y2, (int)x3, (int)y3, (int)x4, (int)y4, 4);
                    }
                }
                g.setColor(constraintColor);
                g.setStroke(DrawConnection.getStroke(StrokeType.CHAIN, flip_chain, modeTo));
                g.draw(ourPath);
                if (modeTo != 6) break;
                DrawConnectionUtils.getArrow(dir, endx, endy, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                break;
            }
            case 7: {
                g.setColor(constraintColor);
                DrawConnectionUtils.getSmallArrow(dir, startx - dx / 2, starty - dy / 2, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                if (destDirection == 0 || destDirection == 1) {
                    endx = startx = (startx + endx) / 2;
                } else {
                    endy = starty = (starty + endy) / 2;
                }
                g.drawLine(startx, starty, endx, endy);
                if (picker == null || secondarySelector == null) break;
                picker.addLine(secondarySelector, 4, startx, starty, endx, endy, 4);
                break;
            }
            case 2: {
                boolean drawArrow = true;
                int springEndX = endx;
                int springEndY = endy;
                if (myDestType != 0) {
                    Stroke tmpStroke;
                    int rectGap = JBUI.scale((int)4);
                    int rectDim = JBUI.scale((int)9);
                    if (margin != 0) {
                        String marginString = Integer.toString(margin);
                        if (destDirection == 0 || destDirection == 1) {
                            int gap = Math.max(marginDistance, DrawConnectionUtils.getHorizontalMarginGap(g, marginString));
                            if (Math.abs(startx - endx) < gap) {
                                marginString = null;
                            }
                            int marginX = endx - (endx > startx ? gap : -gap);
                            int arrow = (endx > startx ? 1 : -1) * DrawConnectionUtils.ARROW_SIDE;
                            if (hover) {
                                g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                                Stroke tmpStroke2 = g.getStroke();
                                g.setStroke(myHoverStroke);
                                g.drawLine(marginX, endy, endx - arrow, endy);
                                g.setStroke(tmpStroke2);
                            }
                            if (picker != null && secondarySelector != null) {
                                picker.addLine(secondarySelector, 8, marginX, endy, endx - arrow, endy, 4);
                            }
                            g.setColor(constraintColor);
                            g.drawLine(marginX, endy, endx - arrow, endy);
                            DrawConnectionUtils.drawHorizontalMarginString(g, marginColor, marginString, isMarginReference, marginX, endx - arrow, endy);
                            springEndX = marginX;
                        } else {
                            int gap = Math.max(marginDistance, DrawConnectionUtils.getVerticalMarginGap(g));
                            if (Math.abs(starty - endy) < gap) {
                                marginString = null;
                            }
                            int marginY = endy - (endy > starty ? gap : -gap);
                            int arrow = (endy > starty ? 1 : -1) * DrawConnectionUtils.ARROW_SIDE;
                            if (hover) {
                                g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                                Stroke tmpStroke3 = g.getStroke();
                                g.setStroke(myHoverStroke);
                                g.drawLine(endx, marginY, endx, endy - arrow);
                                g.setStroke(tmpStroke3);
                            }
                            if (picker != null && secondarySelector != null) {
                                picker.addLine(secondarySelector, 8, endx, marginY, endx, endy - arrow, 4);
                            }
                            g.setColor(constraintColor);
                            g.drawLine(endx, marginY, endx, endy - arrow);
                            DrawConnectionUtils.drawVerticalMarginString(g, marginColor, marginString, isMarginReference, endx, marginY, endy - arrow);
                            springEndY = marginY;
                        }
                    }
                    if (endx == startx) {
                        if (hover) {
                            g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                            tmpStroke = g.getStroke();
                            g.setStroke(myHoverStroke);
                            g.drawLine(startx, starty, startx, springEndY);
                            g.setStroke(tmpStroke);
                        }
                        g.setColor(constraintColor);
                        DrawConnectionUtils.drawVerticalZigZagLine(ourPath, startx, starty, springEndY);
                        if (picker != null && secondarySelector != null) {
                            picker.addLine(secondarySelector, 8, startx, starty, startx, springEndY, 4);
                        }
                        g.fillRect(startx - rectGap, springEndY, rectDim, 1);
                    } else {
                        if (hover) {
                            g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                            tmpStroke = g.getStroke();
                            g.setStroke(myHoverStroke);
                            g.drawLine(startx, endy, springEndX, endy);
                            g.setStroke(tmpStroke);
                        }
                        g.setColor(constraintColor);
                        DrawConnectionUtils.drawHorizontalZigZagLine(ourPath, startx, springEndX, endy);
                        if (picker != null && secondarySelector != null) {
                            picker.addLine(secondarySelector, 8, startx, endy, springEndX, endy, 4);
                        }
                        g.fillRect(springEndX, endy - rectGap, 1, rectDim);
                    }
                } else {
                    g.setColor(constraintColor);
                    int rectGap = JBUI.scale((int)2);
                    int rectDim = JBUI.scale((int)5);
                    if (destDirection == 0 || destDirection == 1) {
                        if (hover) {
                            g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                            Stroke tmpStroke = g.getStroke();
                            g.setStroke(myHoverStroke);
                            GeneralPath hoverPath = new GeneralPath(ourPath);
                            hoverPath.moveTo(startx, starty);
                            hoverPath.lineTo(endx, starty);
                            hoverPath.lineTo(endx, endy);
                            g.draw(hoverPath);
                            g.setStroke(tmpStroke);
                        }
                        g.setColor(constraintColor);
                        DrawConnectionUtils.drawHorizontalZigZagLine(ourPath, startx, endx, starty);
                        if (picker != null && secondarySelector != null) {
                            picker.addLine(secondarySelector, 8, startx, starty, endx, starty, 4);
                            picker.addLine(secondarySelector, 8, endx, starty, endx, endy, 4);
                        }
                        g.setStroke(DrawConnection.getStroke(StrokeType.SPRING, false, modeTo));
                        drawArrow = false;
                        g.drawLine(endx, starty, endx, endy);
                        g.fillRoundRect(endx - rectGap, endy - rectGap, rectDim, rectDim, rectGap, rectGap);
                    } else {
                        if (hover) {
                            g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                            Stroke tmpStroke = g.getStroke();
                            g.setStroke(myHoverStroke);
                            GeneralPath hoverPath = new GeneralPath(ourPath);
                            hoverPath.moveTo(startx, starty);
                            hoverPath.lineTo(startx, endy);
                            hoverPath.lineTo(endx, endy);
                            g.draw(hoverPath);
                            g.setStroke(tmpStroke);
                        }
                        g.setColor(constraintColor);
                        DrawConnectionUtils.drawVerticalZigZagLine(ourPath, startx, starty, endy);
                        if (picker != null && secondarySelector != null) {
                            picker.addLine(secondarySelector, 8, startx, starty, startx, endy, 4);
                            picker.addLine(secondarySelector, 8, startx, endy, endx, endy, 4);
                        }
                        g.setStroke(DrawConnection.getStroke(StrokeType.SPRING, false, modeTo));
                        drawArrow = false;
                        g.drawLine(startx, endy, endx, endy);
                        g.fillRoundRect(endx - rectGap, endy - rectGap, rectDim, rectDim, rectGap, rectGap);
                    }
                }
                g.setStroke(DrawConnection.getStroke(StrokeType.NORMAL, false, modeTo));
                g.setColor(constraintColor);
                g.draw(ourPath);
                if (!drawArrow) break;
                g.setColor(constraintColor);
                DrawConnectionUtils.getArrow(dir, endx, endy, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                break;
            }
            case 4: 
            case 6: {
                int p6y;
                int p6x;
                int dir0_x = 0;
                int dir0_y = 0;
                int dir1_x = 0;
                int dir1_y = 0;
                int dir2_x = 0;
                int dir2_y = 0;
                if (destDirection == 0 || destDirection == 1) {
                    dir0_x = sourceDirection == 0 ? -1 : 1;
                    dir1_y = endy > starty ? 1 : -1;
                    dir2_x = destDirection == 0 ? -1 : 1;
                    p6x = destDirection == 0 ? endx - GAP * 2 : endx + GAP * 2;
                    p6y = starty + dir0_y * GAP + (source.height / 2 + GAP) * dir1_y;
                    int vline_y1 = -1;
                    int vline_y2 = -1;
                    if (source.y > dest.y + dest.height) {
                        vline_y1 = dest.y + dest.height;
                        vline_y2 = source.y;
                    }
                    if (source.y + source.height < dest.y) {
                        vline_y1 = source.y + source.height;
                        vline_y2 = dest.y;
                    }
                    if (vline_y1 != -1) {
                        if (hover) {
                            g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                            Stroke tmpStroke = g.getStroke();
                            g.setStroke(myHoverStroke);
                            int xpos = source.x + source.width / 2;
                            g.drawLine(xpos, vline_y1, xpos, vline_y2);
                            g.setStroke(tmpStroke);
                        }
                        g.setStroke(DrawConnection.getStroke(StrokeType.DASH, false, modeTo));
                        int xpos = source.x + source.width / 2;
                        g.setColor(constraintColor);
                        g.drawLine(xpos, vline_y1, xpos, vline_y2);
                    }
                } else {
                    dir1_x = endx > startx ? 1 : -1;
                    dir0_y = sourceDirection == 2 ? -1 : 1;
                    dir2_y = destDirection == 2 ? -1 : 1;
                    p6y = destDirection == 2 ? endy - GAP * 2 : endy + GAP * 2;
                    p6x = startx + dir0_x * GAP + (source.width / 2 + GAP) * dir1_x;
                    int vline_x1 = -1;
                    int vline_x2 = -1;
                    if (source.x > dest.x + dest.width) {
                        vline_x1 = dest.x + dest.width;
                        vline_x2 = source.x;
                    }
                    if (source.x + source.width < dest.x) {
                        vline_x1 = source.x + source.width;
                        vline_x2 = dest.x;
                    }
                    if (vline_x1 != -1) {
                        if (hover) {
                            g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                            Stroke tmpStroke = g.getStroke();
                            g.setStroke(myHoverStroke);
                            int ypos = source.y + source.height / 2;
                            g.drawLine(vline_x1, ypos, vline_x2, ypos);
                            g.setStroke(tmpStroke);
                        }
                        g.setStroke(DrawConnection.getStroke(StrokeType.DASH, false, modeTo));
                        int ypos = source.y + source.height / 2;
                        g.setColor(constraintColor);
                        g.drawLine(vline_x1, ypos, vline_x2, ypos);
                    }
                }
                int len = 6;
                int[] px = new int[len];
                int[] py = new int[len];
                px[0] = startx;
                py[0] = starty;
                px[1] = startx + dir0_x * GAP;
                py[1] = starty + dir0_y * GAP;
                px[2] = px[1] + (source.width / 2 + GAP) * dir1_x;
                py[2] = py[1] + (source.height / 2 + GAP) * dir1_y;
                px[3] = p6x;
                py[3] = p6y;
                px[4] = endx + 2 * dir2_x * GAP;
                py[4] = endy + 2 * dir2_y * GAP;
                px[5] = endx;
                py[5] = endy;
                if (6 == connectionType) {
                    len = DrawConnectionUtils.removeZigZag(px, py, len, 50);
                }
                DrawConnectionUtils.drawRound((Path2D.Float)ourPath, px, py, len, GAP);
                if (hover) {
                    g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                    Stroke tmpStroke = g.getStroke();
                    g.setStroke(myHoverStroke);
                    g.draw(ourPath);
                    g.setStroke(tmpStroke);
                }
                if (picker != null && secondarySelector != null) {
                    DrawConnectionUtils.drawPick(picker, secondarySelector, px, py, len, GAP);
                }
                g.setStroke(DrawConnection.getStroke(StrokeType.NORMAL, false, modeTo));
                g.setColor(constraintColor);
                DrawConnectionUtils.getArrow(destDirection, endx, endy, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                g.draw(ourPath);
                break;
            }
            case 1: {
                if (margin > 0) {
                    Stroke tmpStroke;
                    int overlap;
                    if (sourceDirection == 1 || sourceDirection == 0) {
                        boolean above = starty < endy;
                        int line_y = starty + (above ? -1 : 1) * source.height / 4;
                        g.setColor(marginColor);
                        DrawConnectionUtils.drawHorizontalMarginIndicator(g, String.valueOf(margin), isMarginReference, startx, endx, line_y);
                        if (myDestType != 1 || line_y < dest.y || line_y > dest.y + dest.height) {
                            int constraintX = destDirection == 0 ? dest.x : dest.x + dest.width;
                            g.setStroke(DrawConnection.getStroke(StrokeType.DASH, false, modeTo));
                            int n = overlap = above ? -20 : 20;
                            if (hover) {
                                g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                                tmpStroke = g.getStroke();
                                g.setStroke(myHoverStroke);
                                g.drawLine(constraintX, line_y + overlap, constraintX, above ? dest.y : dest.y + dest.height);
                                g.setStroke(tmpStroke);
                            }
                            g.setColor(constraintColor);
                            g.drawLine(constraintX, line_y + overlap, constraintX, above ? dest.y : dest.y + dest.height);
                        }
                    } else {
                        boolean left2 = startx < endx;
                        int line_x = startx + (left2 ? -1 : 1) * source.width / 4;
                        g.setColor(marginColor);
                        DrawConnectionUtils.drawVerticalMarginIndicator(g, String.valueOf(margin), isMarginReference, line_x, starty, endy);
                        if (myDestType != 1 || line_x < dest.x || line_x > dest.x + dest.width) {
                            int constraint_y = destDirection == 2 ? dest.y : dest.y + dest.height;
                            g.setStroke(DrawConnection.getStroke(StrokeType.DASH, false, modeTo));
                            int n = overlap = left2 ? -20 : 20;
                            if (hover) {
                                g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                                tmpStroke = g.getStroke();
                                g.setStroke(myHoverStroke);
                                g.drawLine(line_x + overlap, constraint_y, left2 ? dest.x : dest.x + dest.width, constraint_y);
                                g.setStroke(tmpStroke);
                            }
                            g.setColor(constraintColor);
                            g.drawLine(line_x + overlap, constraint_y, left2 ? dest.x : dest.x + dest.width, constraint_y);
                        }
                    }
                }
                if ((startx - endx == 0 || starty - endy == 0) && sourceDirection != destDirection) {
                    scale_source = 0;
                    scale_dest = 0;
                }
                g.setStroke(DrawConnection.getStroke(StrokeType.NORMAL, false, modeTo));
                if (sourceDirection == destDirection && margin == 0) {
                    float y4;
                    float x4;
                    float y3;
                    scale_source /= 3;
                    scale_dest /= 2;
                    float x1 = startx;
                    float y1 = starty;
                    if (hover) {
                        g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                        Stroke tmpStroke = g.getStroke();
                        g.setStroke(myHoverStroke);
                        GeneralPath hoverPath = new GeneralPath(ourPath);
                        float x2 = startx + scale_source * dirDeltaX[sourceDirection];
                        float y2 = starty + scale_source * dirDeltaY[sourceDirection];
                        float x3 = endx + dx + scale_dest * dirDeltaX[destDirection];
                        y3 = endy + dy + scale_dest * dirDeltaY[destDirection];
                        x4 = endx + dx;
                        y4 = endy + dy;
                        hoverPath.curveTo(x2, y2, x3, y3, x4, y4);
                        g.draw(hoverPath);
                        g.setStroke(tmpStroke);
                    }
                    g.setColor(constraintColor);
                    float x2 = startx + scale_source * dirDeltaX[sourceDirection];
                    float y2 = starty + scale_source * dirDeltaY[sourceDirection];
                    float x3 = endx + dx + scale_dest * dirDeltaX[destDirection];
                    y3 = endy + dy + scale_dest * dirDeltaY[destDirection];
                    x4 = endx + dx;
                    y4 = endy + dy;
                    ourPath.curveTo(x2, y2, x3, y3, x4, y4);
                    if (picker != null && secondarySelector != null) {
                        picker.addCurveTo(secondarySelector, 4, (int)x1, (int)y1, (int)x2, (int)y2, (int)x3, (int)y3, (int)x4, (int)y4, 4);
                    }
                } else {
                    float y4;
                    float x4;
                    float y3;
                    float x3;
                    float y2;
                    int xgap = startx - endx;
                    int ygap = starty - endy;
                    if (startx - endx == 0 && dirDeltaX[sourceDirection] == 0) {
                        scale_source = 0;
                        scale_dest = 0;
                    } else if (starty - endy == 0 && dirDeltaY[sourceDirection] == 0) {
                        scale_dest = 0;
                        scale_source = 0;
                    }
                    float x1 = startx;
                    float y1 = starty;
                    if (hover) {
                        g.setColor(DrawConnection.modeGetConstraintsColor(3, color));
                        Stroke tmpStroke = g.getStroke();
                        g.setStroke(myHoverStroke);
                        GeneralPath tmpPath = new GeneralPath(ourPath);
                        float x2 = startx + scale_source * dirDeltaX[sourceDirection];
                        y2 = starty + scale_source * dirDeltaY[sourceDirection];
                        x3 = endx + dx + scale_dest * dirDeltaX[destDirection];
                        y3 = endy + dy + scale_dest * dirDeltaY[destDirection];
                        x4 = endx + dx;
                        y4 = endy + dy;
                        tmpPath.curveTo(x2, y2, x3, y3, x4, y4);
                        g.draw(tmpPath);
                        g.setStroke(tmpStroke);
                    }
                    g.setColor(constraintColor);
                    float x2 = startx + scale_source * dirDeltaX[sourceDirection];
                    y2 = starty + scale_source * dirDeltaY[sourceDirection];
                    x3 = endx + dx + scale_dest * dirDeltaX[destDirection];
                    y3 = endy + dy + scale_dest * dirDeltaY[destDirection];
                    x4 = endx + dx;
                    y4 = endy + dy;
                    ourPath.curveTo(x2, y2, x3, y3, x4, y4);
                    if (picker != null && secondarySelector != null) {
                        picker.addCurveTo(secondarySelector, 4, (int)x1, (int)y1, (int)x2, (int)y2, (int)x3, (int)y3, (int)x4, (int)y4, 4);
                    }
                }
                g.setStroke(DrawConnection.getStroke(StrokeType.BACKGROUND, false, modeTo));
                g.setColor(color.getBackground());
                DrawConnectionUtils.getArrow(dir, endx, endy, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                g.draw(ourPath);
                g.setColor(constraintColor);
                DrawConnectionUtils.getArrow(dir, endx, endy, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                g.draw(ourPath);
            }
        }
        g.setStroke(defaultStroke);
        return animate;
    }

    private static void drawBaseLine(Graphics2D g, Rectangle source, Rectangle dest, Color color, Color hoverColor, ScenePicker picker, SecondarySelector secondarySelector, boolean hover) {
        if (hover) {
            GeneralPath hoverPath = new GeneralPath();
            g.setColor(hoverColor);
            Stroke tmpStroke = g.getStroke();
            g.setStroke(myHoverStroke);
            hoverPath.moveTo((double)source.x + (double)source.width / 2.0, (double)source.y);
            hoverPath.curveTo((double)source.x + (double)source.width / 2.0, (double)(source.y - 40), (double)dest.x + (double)dest.width / 2.0, (double)(dest.y + 40), (double)dest.x + (double)dest.width / 2.0, (double)dest.y);
            g.draw(hoverPath);
            g.setStroke(tmpStroke);
        }
        g.setColor(color);
        ourPath.reset();
        ourPath.moveTo((double)source.x + (double)source.width / 2.0, (double)source.y);
        ourPath.curveTo((double)source.x + (double)source.width / 2.0, (double)(source.y - 40), (double)dest.x + (double)dest.width / 2.0, (double)(dest.y + 40), (double)dest.x + (double)dest.width / 2.0, (double)dest.y);
        if (picker != null && secondarySelector != null) {
            picker.addCurveTo(secondarySelector, 4, (int)((double)source.x + (double)source.width / 2.0), source.y, (int)((double)source.x + (double)source.width / 2.0), source.y - 40, (int)((double)dest.x + (double)dest.width / 2.0), dest.y + 40, (int)((double)dest.x + (double)dest.width / 2.0), dest.y, 4);
        }
        int[] xPoints = new int[3];
        int[] yPoints = new int[3];
        DrawConnectionUtils.getArrow(3, dest.x + dest.width / 2, dest.y, xPoints, yPoints);
        int inset = source.width / 5;
        g.fillRect(source.x + inset, source.y, source.width - inset * 2, 1);
        inset = dest.width / 5;
        g.fillRect(dest.x + inset, dest.y, dest.width - inset * 2, 1);
        g.fillPolygon(xPoints, yPoints, 3);
        g.draw(ourPath);
    }

    private static int getConnectionX(int side, Rectangle rect) {
        switch (side) {
            case 0: {
                return rect.x;
            }
            case 1: {
                return rect.x + rect.width;
            }
            case 2: 
            case 3: {
                return rect.x + rect.width / 2;
            }
        }
        return 0;
    }

    private static int getConnectionY(int side, Rectangle rect) {
        switch (side) {
            case 0: 
            case 1: {
                return rect.y + rect.height / 2;
            }
            case 2: {
                return rect.y;
            }
            case 3: {
                return rect.y + rect.height;
            }
        }
        return 0;
    }

    private static int getDestinationDX(int side) {
        switch (side) {
            case 0: {
                return -DrawConnectionUtils.ARROW_SIDE;
            }
            case 1: {
                return DrawConnectionUtils.ARROW_SIDE;
            }
        }
        return 0;
    }

    private static int getDestinationDY(int side) {
        switch (side) {
            case 2: {
                return -DrawConnectionUtils.ARROW_SIDE;
            }
            case 3: {
                return DrawConnectionUtils.ARROW_SIDE;
            }
        }
        return 0;
    }

    static enum StrokeType {
        DASH,
        CHAIN,
        SPRING,
        NORMAL,
        BACKGROUND;

    }
}

