/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.draw;

import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.scene.target.Notch;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ConstraintLayoutNotchProvider
implements Notch.Provider {
    protected static final ArrayList<String> ourLeftAttributes = new ArrayList();
    protected static final ArrayList<String> ourTopAttributes;
    protected static final ArrayList<String> ourRightAttributes;
    protected static final ArrayList<String> ourBottomAttributes;

    private static boolean hasAttributes(@NotNull NlAttributesHolder transaction, String uri, ArrayList<String> attributes) {
        int count = attributes.size();
        for (int i2 = 0; i2 < count; ++i2) {
            String attribute = attributes.get(i2);
            if (transaction.getAttribute(uri, attribute) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean hasLeft(@NotNull NlAttributesHolder transaction) {
        return ConstraintLayoutNotchProvider.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourLeftAttributes);
    }

    private static boolean hasTop(@NotNull NlAttributesHolder transaction) {
        return ConstraintLayoutNotchProvider.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourTopAttributes);
    }

    private static boolean hasRight(@NotNull NlAttributesHolder transaction) {
        return ConstraintLayoutNotchProvider.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourRightAttributes);
    }

    private static boolean hasBottom(@NotNull NlAttributesHolder transaction) {
        return ConstraintLayoutNotchProvider.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourBottomAttributes);
    }

    private static boolean hasBaseline(@NotNull NlAttributesHolder transaction) {
        return transaction.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf") != null;
    }

    @Override
    public void fill(@NotNull SceneComponent owner, @NotNull SceneComponent snappableComponent, @NotNull ImmutableList.Builder<Notch> notchesBuilder) {
        int x1 = owner.getDrawX();
        int x2 = x1 + owner.getDrawWidth();
        int midX = x1 + (x2 - x1) / 2 - snappableComponent.getDrawWidth() / 2;
        notchesBuilder.add((Object)new Notch.Horizontal(owner, midX, x1 + (x2 - x1) / 2, attributes -> {
            if (ConstraintLayoutNotchProvider.hasLeft(attributes) || ConstraintLayoutNotchProvider.hasRight(attributes)) {
                return;
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintStart_toStartOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintEnd_toEndOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", null);
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", null);
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart", null);
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd", null);
        }));
        notchesBuilder.add((Object)new Notch.Horizontal(owner, x1 + 16, x1 + 16, attributes -> {
            if (ConstraintLayoutNotchProvider.hasLeft(attributes) || ConstraintLayoutNotchProvider.hasRight(attributes)) {
                return;
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintStart_toStartOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", String.format("%ddp", 16));
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart", String.format("%ddp", 16));
        }));
        notchesBuilder.add((Object)new Notch.Horizontal(owner, x2 - snappableComponent.getDrawWidth() - 16, x2 - 16, attributes -> {
            if (ConstraintLayoutNotchProvider.hasLeft(attributes) || ConstraintLayoutNotchProvider.hasRight(attributes)) {
                return;
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintEnd_toEndOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", String.format("%ddp", 16));
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd", String.format("%ddp", 16));
        }));
        int y1 = owner.getDrawY();
        int y2 = y1 + owner.getDrawHeight();
        int midY = y1 + (y2 - y1) / 2 - snappableComponent.getDrawHeight() / 2;
        notchesBuilder.add((Object)new Notch.Vertical(owner, midY, y1 + (y2 - y1) / 2, attributes -> {
            if (ConstraintLayoutNotchProvider.hasTop(attributes) || ConstraintLayoutNotchProvider.hasBottom(attributes) || ConstraintLayoutNotchProvider.hasBaseline(attributes)) {
                return;
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toTopOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toBottomOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", null);
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", null);
        }));
        notchesBuilder.add((Object)new Notch.Vertical(owner, y1 + 16, y1 + 16, attributes -> {
            if (ConstraintLayoutNotchProvider.hasTop(attributes) || ConstraintLayoutNotchProvider.hasBottom(attributes) || ConstraintLayoutNotchProvider.hasBaseline(attributes)) {
                return;
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toTopOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", String.format("%ddp", 16));
        }));
        notchesBuilder.add((Object)new Notch.Vertical(owner, y2 - snappableComponent.getDrawHeight() - 16, y2 - 16, attributes -> {
            if (ConstraintLayoutNotchProvider.hasTop(attributes) || ConstraintLayoutNotchProvider.hasBottom(attributes) || ConstraintLayoutNotchProvider.hasBaseline(attributes)) {
                return;
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toBottomOf", "parent");
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", String.format("%ddp", 16));
        }));
    }

    static {
        ourLeftAttributes.add("layout_constraintStart_toStartOf");
        ourLeftAttributes.add("layout_constraintStart_toEndOf");
        ourTopAttributes = new ArrayList();
        ourTopAttributes.add("layout_constraintTop_toTopOf");
        ourTopAttributes.add("layout_constraintTop_toBottomOf");
        ourRightAttributes = new ArrayList();
        ourRightAttributes.add("layout_constraintEnd_toStartOf");
        ourRightAttributes.add("layout_constraintEnd_toEndOf");
        ourBottomAttributes = new ArrayList();
        ourBottomAttributes.add("layout_constraintBottom_toTopOf");
        ourBottomAttributes.add("layout_constraintBottom_toBottomOf");
    }
}

