/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.resources.LayoutDirection;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstraintUtilities {
    private static HashMap<String, Integer> alignmentMap_ltr = new HashMap();
    private static HashMap<String, Integer> alignmentMap_rtl = new HashMap();
    static String[] mode = new String[]{"0", "1", "2", "3", "center", "START", "END"};
    private static final String[][] CHARS_MAP = new String[][]{{"&quot;", "\""}, {"&apos;", "'"}, {"&lt;", "<"}, {"&gt;", ">"}, {"&amp;", "&"}};

    public static int getAlignment(String s, boolean rtl) {
        HashMap<String, Integer> alignmentMap;
        HashMap<String, Integer> hashMap = alignmentMap = rtl ? alignmentMap_rtl : alignmentMap_ltr;
        if (alignmentMap.containsKey(s)) {
            return alignmentMap.get(s);
        }
        return 5;
    }

    static int getMargin(@NotNull NlComponent component, @NotNull String attr) {
        String margin = component.getLiveAttribute("http://schemas.android.com/apk/res/android", attr);
        if (margin == null) {
            if (attr == "layout_marginStart") {
                margin = component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft");
            } else if (attr == "layout_marginEnd") {
                margin = component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight");
            }
        }
        if (margin != null) {
            return ConstraintUtilities.getDpValue(component, margin);
        }
        return 0;
    }

    public static boolean isInRTL(@NotNull NlComponent component) {
        Configuration configuration = component.getModel().getConfiguration();
        if (configuration == null) {
            return false;
        }
        LayoutDirectionQualifier qualifier = configuration.getFullConfig().getLayoutDirectionQualifier();
        if (qualifier == null) {
            return false;
        }
        return qualifier.getValue() == LayoutDirection.RTL;
    }

    public static int getDpValue(@NotNull NlComponent component, String value2) {
        Configuration configuration;
        ResourceResolver resourceResolver2;
        if (value2 != null && (resourceResolver2 = (configuration = component.getModel().getConfiguration()).getResourceResolver()) != null) {
            Integer px = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver2, value2, configuration);
            return px == null ? 0 : Coordinates.pxToDp(component.getModel(), (int)px);
        }
        return 0;
    }

    @NotNull
    static String resolveStringResource(@NotNull NlComponent component, @NotNull String text2) {
        Configuration configuration = component.getModel().getConfiguration();
        ResourceResolver resourceResolver2 = configuration.getResourceResolver();
        if (resourceResolver2 != null) {
            return IdeResourcesUtil.resolveStringValue((RenderResources)resourceResolver2, text2);
        }
        return "";
    }

    @NotNull
    public static String getResolvedText(@NotNull NlComponent component) {
        String text2 = ConstraintUtilities.getResolvedAttribute(component, "text");
        if (text2 == null) {
            return "";
        }
        return text2;
    }

    @NotNull
    public static String getResolvedToggleText(@NotNull NlComponent component) {
        String checkedText = ConstraintUtilities.getResolvedAttribute(component, "checked");
        String toggleTextAttr = checkedText != null && checkedText.equals("true") ? "textOn" : "textOff";
        String text2 = ConstraintUtilities.getResolvedAttribute(component, toggleTextAttr);
        if (text2 == null) {
            return "";
        }
        return text2;
    }

    @Nullable
    private static String getResolvedAttribute(@NotNull NlComponent component, @NotNull String attribute) {
        String resolvedAttribute = component.getAttribute("http://schemas.android.com/tools", attribute);
        if (resolvedAttribute == null) {
            resolvedAttribute = component.getAttribute("http://schemas.android.com/apk/res/android", attribute);
        }
        if (resolvedAttribute != null && resolvedAttribute.startsWith("@")) {
            resolvedAttribute = ConstraintUtilities.resolveStringResource(component, resolvedAttribute);
        }
        return ConstraintUtilities.replaceSpecialChars(resolvedAttribute);
    }

    @VisibleForTesting
    @Nullable
    static String replaceSpecialChars(@Nullable String text2) {
        if (text2 == null || text2.isEmpty()) {
            return text2;
        }
        int offset2 = 0;
        int pos = 0;
        if (text2.indexOf("&") >= 0) {
            boolean notDone = true;
            while (notDone) {
                char part;
                int end;
                int begin;
                notDone = false;
                for (int i2 = 0; i2 < CHARS_MAP.length; ++i2) {
                    pos = text2.indexOf(CHARS_MAP[i2][0], offset2);
                    if (pos < 0) continue;
                    notDone = true;
                    text2 = text2.replace(CHARS_MAP[i2][0], CHARS_MAP[i2][1]);
                    offset2 = pos + CHARS_MAP[i2][0].length();
                }
                if (offset2 < text2.length() && text2.substring(offset2).matches(".*&#[0-9]+;.*")) {
                    begin = text2.indexOf("&#");
                    end = text2.indexOf(";", begin);
                    part = (char)Integer.parseInt(text2.substring(begin + 2, end));
                    text2 = text2.replace(text2.substring(begin, end + 1), "" + part);
                    notDone = true;
                    offset2 = end;
                }
                if (offset2 >= text2.length() || !text2.substring(offset2).matches(".*&#x[a-fA-F0-9]+;.*")) continue;
                begin = text2.indexOf("&#x");
                end = text2.indexOf(";", begin);
                part = (char)Integer.parseInt(text2.substring(begin + 3, end), 16);
                text2 = text2.replace(text2.substring(begin, end + 1), "" + part);
                notDone = true;
                offset2 = end;
            }
        }
        return text2;
    }

    static {
        alignmentMap_rtl.put("center", 4);
        alignmentMap_rtl.put("textStart", 2);
        alignmentMap_rtl.put("textEnd", 3);
        alignmentMap_rtl.put("viewStart", 6);
        alignmentMap_rtl.put("viewEnd", 5);
        alignmentMap_ltr.put("center", 4);
        alignmentMap_ltr.put("textStart", 2);
        alignmentMap_ltr.put("textEnd", 3);
        alignmentMap_ltr.put("viewStart", 5);
        alignmentMap_ltr.put("viewEnd", 6);
    }
}

