/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.SdkConstants;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintHelperHandler;
import com.google.common.collect.ImmutableList;
import icons.StudioIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ConstraintLayoutBarrierHandler
extends ConstraintHelperHandler {
    @Override
    @NotNull
    public String getTitle(@NotNull NlComponent component) {
        String barrierDirection = component.resolveAttribute("http://schemas.android.com/apk/res-auto", "barrierDirection");
        if (barrierDirection == null) {
            return "Barrier";
        }
        return ConstraintLayoutBarrierHandler.isVertical(component) ? "Vertical Barrier" : "Horizontal Barrier";
    }

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"barrierDirection");
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull NlComponent component) {
        if (!SdkConstants.CONSTRAINT_LAYOUT_BARRIER.isEquals(component.getTagName())) {
            return super.getIcon(component);
        }
        if (ConstraintLayoutBarrierHandler.isVertical(component)) {
            return StudioIcons.LayoutEditor.Palette.BARRIER_VERTICAL;
        }
        return StudioIcons.LayoutEditor.Palette.BARRIER_HORIZONTAL;
    }

    private static boolean isVertical(@NotNull NlComponent component) {
        String barrierDirection = component.resolveAttribute("http://schemas.android.com/apk/res-auto", "barrierDirection");
        if (barrierDirection == null) {
            return false;
        }
        switch (barrierDirection) {
            case "start": 
            case "end": 
            case "left": 
            case "right": {
                return true;
            }
        }
        return false;
    }
}

