/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.handlers.BuiltinViewHandlerProvider;
import com.android.tools.idea.uibuilder.handlers.MergeDelegateHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerProvider;
import com.android.tools.idea.uibuilder.menu.MenuViewHandlerManager;
import com.android.tools.idea.uibuilder.model.ClassResolutionUtilsKt;
import com.android.tools.idea.uibuilder.model.NlComponentHelper;
import com.android.tools.idea.uibuilder.statelist.ItemHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewHandlerManager
implements Disposable {
    @VisibleForTesting
    static final ExtensionPointName<ViewHandlerProvider> EP_NAME = ExtensionPointName.create((String)"com.android.tools.idea.uibuilder.handlers.viewHandlerProvider");
    private static final String HANDLER_CLASS_SUFFIX = "Handler";
    private final Project myProject;
    private final Map<String, ViewHandler> myHandlers = Maps.newHashMap();
    public static final ViewHandler NONE = new ViewHandler();
    private final Map<ViewHandler, List<ViewAction>> myToolbarActions = Maps.newHashMap();
    private final Map<ViewHandler, List<ViewAction>> myMenuActions = Maps.newHashMap();

    @NotNull
    public static ViewHandlerManager get(@NotNull Project project) {
        ViewHandlerManager manager = (ViewHandlerManager)project.getService(ViewHandlerManager.class);
        assert (manager != null);
        return manager;
    }

    @NotNull
    public static ViewHandlerManager get(@NotNull AndroidFacet facet2) {
        return ViewHandlerManager.get(facet2.getModule().getProject());
    }

    public ViewHandlerManager(@NotNull Project project) {
        this.myProject = project;
    }

    @Nullable
    public ViewHandler getHandler(@NotNull NlComponent component) {
        String tag;
        switch (tag = component.getTagName()) {
            case "item": {
                ViewHandler handler2 = MenuViewHandlerManager.getHandler(component);
                if (handler2 != null) {
                    return handler2;
                }
                return new ItemHandler();
            }
            case "merge": {
                ViewHandler groupHandler;
                String parentTag = component.getAttribute("http://schemas.android.com/tools", "parentTag");
                if (parentTag != null && (groupHandler = this.getHandler(parentTag)) instanceof ViewGroupHandler) {
                    return new MergeDelegateHandler((ViewGroupHandler)groupHandler);
                }
                return this.getHandler("merge");
            }
        }
        return this.getHandler(tag);
    }

    @NotNull
    public ViewHandler getHandlerOrDefault(@NotNull NlComponent component) {
        ViewHandler handler2 = this.getHandler(component);
        return handler2 != null ? handler2 : NONE;
    }

    @NotNull
    public ViewHandler getHandlerOrDefault(@NotNull String viewTag) {
        ViewHandler handler2 = this.getHandler(viewTag);
        return handler2 != null ? handler2 : NONE;
    }

    @Nullable
    public ViewHandler getHandler(@NotNull String viewTag) {
        ViewHandler handler2 = this.myHandlers.get(viewTag);
        if (handler2 == null) {
            String tag;
            if (viewTag.indexOf(46) != -1 && !(tag = NlComponentHelper.INSTANCE.viewClassToTag(viewTag)).equals(viewTag) && (handler2 = this.getHandler(tag)) != null) {
                this.myHandlers.put(viewTag, handler2);
                return handler2;
            }
            handler2 = this.createHandler(viewTag);
            this.myHandlers.put(viewTag, handler2);
        }
        return handler2 != NONE ? handler2 : null;
    }

    public void registerHandler(@NotNull String viewTag, @NotNull ViewHandler handler2) {
        this.myHandlers.put(viewTag, handler2);
    }

    @Nullable
    public ViewGroupHandler findLayoutHandler(@NotNull NlComponent component, boolean strict) {
        NlComponent curr = component;
        if (strict) {
            curr = curr.getParent();
        }
        while (curr != null) {
            ViewHandler handler2 = this.getHandler(curr);
            if (handler2 instanceof ViewGroupHandler) {
                return (ViewGroupHandler)handler2;
            }
            curr = curr.getParent();
        }
        return null;
    }

    private ViewHandler createHandler(@NotNull String viewTag) {
        ViewHandler builtInHandler = BuiltinViewHandlerProvider.INSTANCE.findHandler(viewTag);
        if (builtInHandler != null) {
            return builtInHandler;
        }
        ViewHandler extensionHandler = EP_NAME.extensions((AreaInstance)this.myProject).map(extension -> extension.findHandler(viewTag)).filter(Objects::nonNull).limit(2L).reduce(null, (a, b) -> {
            if (a != null && b != null) {
                Logger.getInstance(ViewHandler.class).warn("Multiple ViewHandlers returned by extensions for tag " + viewTag);
                return a;
            }
            return a != null ? a : b;
        });
        if (extensionHandler != null) {
            return extensionHandler;
        }
        Logger.getInstance(ViewHandler.class).debug("No built-in or extension defined ViewHandlers found for " + viewTag);
        try {
            String defaultHandlerPkgPrefix = "com.android.tools.idea.uibuilder.handlers.";
            String handlerClass = defaultHandlerPkgPrefix + viewTag + HANDLER_CLASS_SUFFIX;
            Class<?> cls = Class.forName(handlerClass);
            return (ViewHandler)cls.newInstance();
        }
        catch (Exception exception) {
            Logger.getInstance(ViewHandler.class).debug("Looking for user code defined handlers for " + viewTag);
            return (ViewHandler)ApplicationManager.getApplication().runReadAction(() -> {
                if (this.myProject.isDisposed()) {
                    return NONE;
                }
                try {
                    PsiClass[] viewClasses = ClassResolutionUtilsKt.findClassesForViewTag(this.myProject, viewTag);
                    if (viewClasses.length > 0) {
                        String handlerName = viewTag + HANDLER_CLASS_SUFFIX;
                        PsiClass[] handlerClasses = JavaPsiFacade.getInstance((Project)this.myProject).findClasses(handlerName, GlobalSearchScope.allScope((Project)this.myProject));
                        if (handlerClasses.length == 0) {
                            for (PsiClass cls : viewClasses) {
                                String fqn;
                                PsiClass superClass = cls.getSuperClass();
                                if (superClass == null || (fqn = superClass.getQualifiedName()) == null) continue;
                                return this.getHandler(NlComponentHelper.INSTANCE.viewClassToTag(fqn));
                            }
                        } else {
                            for (PsiClass cls : handlerClasses) {
                                Logger.getInstance(ViewHandler.class).debug(String.format("Found view handler %s  of type %s", cls.getQualifiedName(), cls.getClass().getName()));
                            }
                        }
                    }
                }
                catch (IndexNotReadyException ignore) {
                    return NONE;
                }
                return NONE;
            });
        }
    }

    public List<ViewAction> getToolbarActions(@NotNull ViewHandler handler2) {
        ArrayList actions2 = this.myToolbarActions.get(handler2);
        if (actions2 == null) {
            actions2 = Lists.newArrayList();
            handler2.addToolbarActions(actions2);
            this.myToolbarActions.put(handler2, actions2);
        }
        return actions2;
    }

    @NotNull
    public List<ViewAction> getPopupMenuActions(@NotNull SceneComponent component, @NotNull ViewHandler handler2) {
        ArrayList actions2 = this.myMenuActions.get(handler2);
        if (actions2 == null && handler2.addPopupMenuActions(component, actions2 = Lists.newArrayList())) {
            this.myMenuActions.put(handler2, actions2);
        }
        return actions2;
    }

    public void dispose() {
        this.myHandlers.clear();
    }

    void clearCache() {
        this.myHandlers.clear();
    }
}

