/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.ui.resourcechooser.util.ResourceChooserHelperKt;
import com.android.tools.idea.ui.resourcemanager.ResourcePickerDialog;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.editor.LayoutNavigationManager;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.lint.checks.AnnotationDetector;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.jetbrains.android.uipreview.ChooseClassDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ViewEditorImpl
extends ViewEditor {
    private final Configuration myConfiguration;
    private final NlModel myModel;
    private final SceneManager mySceneManager;
    private final Scene myScene;
    @VisibleForTesting
    private Collection<ViewInfo> myRootViews;

    public ViewEditorImpl(@NotNull SceneView sceneView) {
        this(sceneView.getModel(), sceneView.getScene());
    }

    public ViewEditorImpl(@NotNull NlModel model2) {
        this(model2, null);
    }

    public ViewEditorImpl(@NotNull NlModel model2, @Nullable Scene scene) {
        this.myConfiguration = model2.getConfiguration();
        this.myModel = model2;
        this.myScene = scene;
        this.mySceneManager = scene != null ? scene.getSceneManager() : null;
    }

    @Override
    @Nullable
    public AndroidVersion getCompileSdkVersion() {
        return AndroidModuleInfo.getInstance(this.myModel.getFacet()).getBuildSdkVersion();
    }

    @Override
    @NotNull
    public AndroidVersion getMinSdkVersion() {
        return AndroidModuleInfo.getInstance(this.myModel.getFacet()).getMinSdkVersion();
    }

    @Override
    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        return AndroidModuleInfo.getInstance(this.myModel.getFacet()).getTargetSdkVersion();
    }

    @Override
    @NotNull
    public Configuration getConfiguration() {
        return this.myConfiguration;
    }

    @Override
    @NotNull
    public NlModel getModel() {
        return this.myModel;
    }

    @Override
    @NotNull
    public LayoutlibSceneManager getSceneBuilder() {
        assert (this.mySceneManager != null) : "ViewEditorImpl incorrectly configured";
        return (LayoutlibSceneManager)this.mySceneManager;
    }

    @Override
    @NotNull
    public Collection<ViewInfo> getRootViews() {
        if (this.myRootViews != null) {
            return this.myRootViews;
        }
        RenderResult result2 = this.getSceneBuilder().getRenderResult();
        if (result2 == null) {
            return Collections.emptyList();
        }
        return result2.getRootViews();
    }

    @VisibleForTesting
    public void setRootViews(@NotNull Collection<ViewInfo> rootViews) {
        this.myRootViews = rootViews;
    }

    @Override
    @NotNull
    public CompletableFuture<Map<NlComponent, Dimension>> measureChildren(@NotNull NlComponent parent, @Nullable RenderTask.AttributeFilter filter2) {
        if (!parent.getBackend().isValid()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        if (parent.getChildCount() == 0) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        HashMap tagToComponent = Maps.newHashMapWithExpectedSize((int)parent.getChildCount());
        for (NlComponent child : parent.getChildren()) {
            tagToComponent.put(child.getTagDeprecated(), child);
        }
        NlModel model2 = this.myModel;
        XmlFile xmlFile = model2.getFile();
        Module module2 = model2.getModule();
        RenderService renderService = RenderService.getInstance(module2.getProject());
        RenderTask task2 = renderService.taskBuilder(model2.getFacet(), this.getConfiguration()).withPsiFile((PsiFile)xmlFile).buildSynchronously();
        if (task2 == null) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        XmlTag parentTag = parent.getTagDeprecated();
        return ((CompletableFuture)task2.measureChildren(parentTag, filter2).whenCompleteAsync((map2, ex) -> task2.dispose(), (Executor)PooledThreadExecutor.INSTANCE)).thenApply(map2 -> {
            if (map2 == null) {
                return Collections.emptyMap();
            }
            HashMap unweightedSizes = Maps.newHashMap();
            for (Map.Entry entry : map2.entrySet()) {
                ViewInfo viewInfo = (ViewInfo)entry.getValue();
                viewInfo = RenderService.getSafeBounds(viewInfo);
                Dimension size = new Dimension(viewInfo.getRight() - viewInfo.getLeft(), viewInfo.getBottom() - viewInfo.getTop());
                NlComponent child = (NlComponent)tagToComponent.get(entry.getKey());
                if (child == null) continue;
                unweightedSizes.put(child, size);
            }
            return unweightedSizes;
        });
    }

    @Override
    @Nullable
    public String displayResourceInput(@NotNull String title, @NotNull EnumSet<ResourceType> types2, boolean includeSampleData) {
        String resource;
        NlModel model2 = this.myModel;
        ResourcePickerDialog dialog2 = ResourceChooserHelperKt.createResourcePickerDialog(title.isEmpty() ? "Pick a Resource" : title, null, model2.getFacet(), types2, null, false, includeSampleData, true, model2.getVirtualFile());
        dialog2.show();
        if (dialog2.isOK() && (resource = dialog2.getResourceName()) != null && !resource.isEmpty()) {
            return resource;
        }
        return null;
    }

    @Override
    @Nullable
    public String displayClassInput(@NotNull String title, @NotNull Set<String> superTypes, @Nullable Predicate<String> filter2, @Nullable String currentValue) {
        Module module2 = this.myModel.getModule();
        String[] superTypesArray = ArrayUtil.toStringArray(superTypes);
        Predicate<PsiClass> psiFilter = ChooseClassDialog.getIsPublicAndUnrestrictedFilter();
        if (filter2 == null) {
            filter2 = ChooseClassDialog.getIsUserDefinedFilter();
        }
        psiFilter = psiFilter.and(ChooseClassDialog.qualifiedNameFilter(filter2));
        return ChooseClassDialog.openDialog(module2, title, currentValue, psiFilter, superTypesArray);
    }

    @VisibleForTesting
    static boolean isPublicAndUnRestricted(@NotNull PsiClass psiClass) {
        PsiModifierList modifiers = psiClass.getModifierList();
        if (modifiers == null) {
            return false;
        }
        if (!modifiers.hasModifierProperty("public")) {
            return false;
        }
        for (PsiAnnotation annotation : modifiers.getAnnotations()) {
            if (!AnnotationDetector.RESTRICT_TO_ANNOTATION.isEquals(annotation.getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Scene getScene() {
        assert (this.myScene != null) : "ViewEditorImpl incorrectly configured";
        return this.myScene;
    }

    @Override
    public boolean canInsertChildren(@NotNull NlComponent parent, @NotNull List<NlComponent> children, int index2) {
        return this.getModel().canAddComponents(children, parent, ViewEditorImpl.getChild(parent, index2));
    }

    @Override
    public void insertChildren(@NotNull NlComponent parent, @NotNull List<NlComponent> children, int index2, @NotNull InsertType insertType) {
        this.getModel().addComponents(children, parent, ViewEditorImpl.getChild(parent, index2), insertType, this.myScene.getDesignSurface());
    }

    @Nullable
    private static NlComponent getChild(@NotNull NlComponent parent, int index2) {
        return 0 <= index2 && index2 < parent.getChildCount() ? parent.getChild(index2) : null;
    }

    @Override
    public void openResourceFile(@NotNull String resourceId) {
        ResourceValue resValue;
        ResourceResolver resourceResolver2 = this.myConfiguration.getResourceResolver();
        VirtualFile file2 = IdeResourcesUtil.resolveLayout((RenderResources)resourceResolver2, resValue = resourceResolver2.findResValue(resourceId, false));
        if (file2 == null) {
            return;
        }
        LayoutNavigationManager.getInstance(this.myConfiguration.getModule().getProject()).pushFile(this.myModel.getVirtualFile(), file2);
    }

    @NotNull
    public static ViewEditor getOrCreate(@NotNull Scene scene) {
        return ((LayoutlibSceneManager)scene.getSceneManager()).getViewEditor();
    }

    @Override
    public boolean moduleDependsOnAppCompat() {
        return NlModelHelperKt.moduleDependsOnAppCompat(this.myModel);
    }
}

