/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import icons.StudioIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeekBarHandler
extends ViewHandler {
    private static final String DOT_SEEK_BAR_DOT = ".SeekBar.";
    private static final String SEEK_BAR_STYLE = "seekBarStyle";
    private static final String DISCRETE = "Discrete";

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"style", (Object)"thumb", (Object)"max", (Object)"progress");
    }

    @Override
    @NotNull
    public String getTitleAttributes(@NotNull NlComponent component) {
        String style = SeekBarHandler.getStyle(component);
        return StringUtil.isEmpty((String)style) ? "" : "(" + style + ")";
    }

    @Nullable
    private static String getStyle(@NotNull NlComponent component) {
        String style = component.getAttribute(null, "style");
        if (style == null) {
            return null;
        }
        if (style.startsWith("@android:style/")) {
            int index2 = style.indexOf(DOT_SEEK_BAR_DOT);
            return SeekBarHandler.findSeekBarType(style.substring(index2 + DOT_SEEK_BAR_DOT.length()));
        }
        if (style.startsWith("?android:")) {
            int index3 = style.indexOf(SEEK_BAR_STYLE);
            return SeekBarHandler.findSeekBarType(style.substring(index3 + SEEK_BAR_STYLE.length()));
        }
        if (style.startsWith("@style/")) {
            int index4 = style.indexOf(DOT_SEEK_BAR_DOT);
            return SeekBarHandler.findSeekBarType(style.substring(index4 + DOT_SEEK_BAR_DOT.length()));
        }
        return null;
    }

    @Nullable
    private static String findSeekBarType(@NotNull String style) {
        if (style.startsWith(DISCRETE)) {
            return DISCRETE;
        }
        return null;
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull NlComponent component) {
        if (!component.getTagName().equals("SeekBar")) {
            return super.getIcon(component);
        }
        return DISCRETE.equals(SeekBarHandler.getStyle(component)) ? StudioIcons.LayoutEditor.Palette.SEEK_BAR_DISCRETE : StudioIcons.LayoutEditor.Palette.SEEK_BAR;
    }
}

