/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import icons.StudioIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressBarHandler
extends ViewHandler {
    private static final String DOT_PROGRESS_BAR_DOT = ".ProgressBar.";
    private static final String PROGRESS_BAR_STYLE = "progressBarStyle";
    private static final String LARGE = "Large";
    private static final String SMALL = "Small";
    private static final String HORIZONTAL = "Horizontal";

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"contentDescription", (Object)"style", (Object)"max", (Object)"progress", (Object)"indeterminate");
    }

    @Override
    @NotNull
    public String getTitleAttributes(@NotNull NlComponent component) {
        String style = ProgressBarHandler.getStyle(component);
        return StringUtil.isEmpty((String)style) ? "" : "(" + style + ")";
    }

    @Nullable
    private static String getStyle(@NotNull NlComponent component) {
        String style = component.getAttribute(null, "style");
        if (style == null) {
            return null;
        }
        if (style.startsWith("@android:style/")) {
            return ProgressBarHandler.findProgressBarType(style, DOT_PROGRESS_BAR_DOT);
        }
        if (style.startsWith("?android:")) {
            return ProgressBarHandler.findProgressBarType(style, PROGRESS_BAR_STYLE);
        }
        if (style.startsWith("@style/")) {
            return ProgressBarHandler.findProgressBarType(style, DOT_PROGRESS_BAR_DOT);
        }
        return null;
    }

    @Nullable
    private static String findProgressBarType(@NotNull String style, @NotNull String prefix) {
        int index2 = style.indexOf(prefix);
        return index2 >= 0 ? ProgressBarHandler.findProgressBarType(style.substring(index2 + prefix.length())) : null;
    }

    @Nullable
    private static String findProgressBarType(@NotNull String style) {
        if (style.startsWith(LARGE)) {
            return LARGE;
        }
        if (style.startsWith(SMALL)) {
            return SMALL;
        }
        if (style.startsWith(HORIZONTAL)) {
            return HORIZONTAL;
        }
        return null;
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull NlComponent component) {
        if (!component.getTagName().equals("ProgressBar")) {
            return super.getIcon(component);
        }
        return HORIZONTAL.equals(ProgressBarHandler.getStyle(component)) ? StudioIcons.LayoutEditor.Palette.PROGRESS_BAR_HORIZONTAL : StudioIcons.LayoutEditor.Palette.PROGRESS_BAR;
    }
}

