/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api;

import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.ToggleViewAction;
import com.android.tools.idea.uibuilder.api.actions.ViewActionPresentation;
import java.util.List;
import javax.swing.Icon;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class ToggleSizeViewAction
extends ToggleViewAction {
    private final String myAttribute;

    public ToggleSizeViewAction(@NotNull String label, @NotNull String attribute, @NotNull Icon fillIcon, @NotNull Icon wrapIcon) {
        super(fillIcon, wrapIcon, "", null);
        this.myAttribute = attribute;
    }

    @Override
    public boolean isSelected(@NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren) {
        return this.isFill(selectedChildren);
    }

    @Override
    public void setSelected(@NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent parent, @NotNull List<NlComponent> selectedChildren, boolean selected) {
        String writeCommandLabel = "Set " + (selected ? "wrap_content" : "match_parent");
        NlWriteCommandActionUtil.run(selectedChildren, writeCommandLabel, () -> {
            for (NlComponent component : selectedChildren) {
                component.setAttribute("http://schemas.android.com/apk/res/android", this.myAttribute, selected ? "match_parent" : "wrap_content");
            }
        });
    }

    private boolean isFill(@NotNull List<NlComponent> selectedChildren) {
        if (!selectedChildren.isEmpty()) {
            String value2 = selectedChildren.get(0).getAttribute("http://schemas.android.com/apk/res/android", this.myAttribute);
            return "match_parent".equals(value2) || "fill_parent".equals(value2);
        }
        return false;
    }

    @Override
    public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor2, @NotNull ViewHandler handler2, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers, boolean selected) {
        super.updatePresentation(presentation, editor2, handler2, component, selectedChildren, modifiers, selected);
        presentation.setEnabled(!selectedChildren.isEmpty());
        String text2 = String.format("Set %1$s to %2$s", this.myAttribute, selected ? "wrap_content" : "match_parent");
        presentation.setLabel(text2);
    }
}

