/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api;

import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DragHandler {
    @NotNull
    protected final ViewEditor editor;
    @NotNull
    protected final ViewGroupHandler handler;
    @NotNull
    protected final List<NlComponent> components;
    @NotNull
    protected SceneComponent layout;
    @NotNull
    protected DragType type = DragType.COPY;
    protected int startX;
    protected int startY;
    protected int lastX;
    protected int lastY;

    protected DragHandler(@NotNull ViewEditor editor2, @NotNull ViewGroupHandler handler2, @NotNull SceneComponent layout2, @NotNull List<NlComponent> components, @NotNull DragType type) {
        this.editor = editor2;
        this.handler = handler2;
        this.layout = layout2;
        this.components = components;
        this.type = type;
    }

    public void setDragType(@NotNull DragType type) {
        this.type = type;
    }

    public void cancel() {
    }

    public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
        this.editor.insertChildren(this.layout.getNlComponent(), this.components, -1, insertType);
    }

    public void start(int x, int y, int modifiers) {
        this.startX = x;
        this.startY = y;
    }

    @Nullable
    public String update(int x, int y, int modifiers, SceneContext sceneContext) {
        this.lastX = x;
        this.lastY = y;
        return null;
    }

    public void paint(@NotNull NlGraphics graphics) {
    }
}

