/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SelectParentAction
extends AnAction {
    private final NlDesignSurface mySurface;

    public SelectParentAction(@NotNull NlDesignSurface surface2) {
        super("Select Parent", "Select Parent", null);
        this.mySurface = surface2;
    }

    public void update(@NotNull AnActionEvent e) {
        List<NlComponent> selection;
        SceneView screenView;
        boolean enabled = this.mySurface.getInteractionManager().isInteractionInProgress() ? false : ((screenView = this.mySurface.getFocusedSceneView()) != null ? (selection = screenView.getSelectionModel().getSelection()).size() == 1 && !selection.get(0).isRoot() : false);
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        SceneView screenView = this.mySurface.getFocusedSceneView();
        if (screenView != null) {
            NlComponent first;
            NlComponent parent;
            SelectionModel selectionModel = screenView.getSelectionModel();
            List<NlComponent> selection = selectionModel.getSelection();
            if (selection.size() == 1 && (parent = (first = selection.get(0)).getParent()) != null) {
                selectionModel.setSelection(Collections.singletonList(parent));
            }
            this.mySurface.repaint();
        }
    }
}

