/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.validation.validators;

import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.ui.validation.validators.PathValidatorKt;
import com.android.tools.idea.ui.validation.validators.Rule;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.jcip.annotations.Immutable;
import org.jetbrains.annotations.NotNull;

@Immutable
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0014\u0015B3\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/ui/validation/validators/PathValidator;", "Lcom/android/tools/adtui/validation/Validator;", "Ljava/io/File;", "pathName", "", "errors", "", "Lcom/android/tools/idea/ui/validation/validators/Rule;", "warnings", "fileOp", "Lcom/android/repository/io/FileOp;", "(Ljava/lang/String;Ljava/lang/Iterable;Ljava/lang/Iterable;Lcom/android/repository/io/FileOp;)V", "getErrors", "()Ljava/lang/Iterable;", "validate", "Lcom/android/tools/adtui/validation/Validator$Result;", "file", "projectFile", "severity", "Lcom/android/tools/adtui/validation/Validator$Severity;", "Builder", "Companion", "intellij.android.core"})
public final class PathValidator
implements Validator<File> {
    private final String pathName;
    @NotNull
    private final Iterable<Rule> errors;
    private final Iterable<Rule> warnings;
    private final FileOp fileOp;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Validator.Result validate(@NotNull File file2) {
        Validator.Result result2;
        try {
            Validator.Result result3;
            result2 = this.validate(file2, Validator.Severity.ERROR);
            boolean bl = false;
            boolean bl2 = false;
            Validator.Result it = result2;
            boolean bl3 = false;
            Object object = Intrinsics.areEqual((Object)it, (Object)Validator.Result.OK) ^ true ? result2 : null;
            if (object == null) {
                result2 = this.validate(file2, Validator.Severity.WARNING);
                bl = false;
                bl2 = false;
                it = result2;
                boolean bl4 = false;
                object = result3 = Intrinsics.areEqual((Object)it, (Object)Validator.Result.OK) ^ true ? result2 : null;
            }
            if (object == null) {
                result3 = Validator.Result.OK;
            }
            result2 = result3;
        }
        catch (Exception ex) {
            PathValidatorKt.access$getLogger$p().warn((Throwable)ex);
            result2 = new Validator.Result(Validator.Severity.ERROR, "Invalid file, see Help -> Show Log for more details: " + file2, null, 4, null);
        }
        return result2;
    }

    private final Validator.Result validate(File projectFile, Validator.Severity severity) {
        boolean bl = severity != Validator.Severity.OK;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Iterable<Rule> rules = severity == Validator.Severity.ERROR ? this.errors : this.warnings;
        for (Rule rule : rules) {
            File matchingFile = rule.getMatchingFile(this.fileOp, projectFile);
            if (matchingFile == null) continue;
            return new Validator.Result(severity, rule.getMessage(matchingFile, this.pathName), null, 4, null);
        }
        return Validator.Result.OK;
    }

    @NotNull
    public final Iterable<Rule> getErrors() {
        return this.errors;
    }

    private PathValidator(String pathName, Iterable<? extends Rule> errors2, Iterable<? extends Rule> warnings, FileOp fileOp) {
        this.pathName = pathName;
        this.errors = errors2;
        this.warnings = warnings;
        this.fileOp = fileOp;
    }

    public /* synthetic */ PathValidator(String pathName, Iterable errors2, Iterable warnings, FileOp fileOp, DefaultConstructorMarker $constructor_marker) {
        this(pathName, errors2, warnings, fileOp);
    }

    @JvmStatic
    @NotNull
    public static final PathValidator createDefault(@NotNull String pathName) {
        return Companion.createDefault(pathName);
    }

    @JvmStatic
    @NotNull
    public static final PathValidator forAndroidSdkLocation() {
        return Companion.forAndroidSdkLocation();
    }

    @JvmStatic
    @NotNull
    public static final PathValidator forAndroidNdkLocation() {
        return Companion.forAndroidNdkLocation();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0007J\u0006\u0010\r\u001a\u00020\u0000J\u0006\u0010\u000e\u001a\u00020\u0000J\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/ui/validation/validators/PathValidator$Builder;", "", "()V", "errors", "", "Lcom/android/tools/idea/ui/validation/validators/Rule;", "warnings", "build", "Lcom/android/tools/idea/ui/validation/validators/PathValidator;", "pathName", "", "fileOp", "Lcom/android/repository/io/FileOp;", "withAllRules", "withCommonRules", "withCommonTestRules", "withError", "rule", "withWarning", "intellij.android.core"})
    public static final class Builder {
        private final List<Rule> errors;
        private final List<Rule> warnings;

        @NotNull
        public final Builder withAllRules() {
            this.withCommonRules();
            this.withError(PathValidatorKt.getIS_EMPTY());
            this.withError(PathValidatorKt.getPATH_NOT_WRITABLE());
            this.withWarning(PathValidatorKt.getNON_EMPTY_DIRECTORY());
            return this;
        }

        @NotNull
        public final Builder withCommonRules() {
            this.withCommonTestRules();
            if (SystemInfo.isWindows) {
                this.withError(PathValidatorKt.getWINDOWS_PATH_TOO_LONG());
            }
            return this;
        }

        @NotNull
        public final Builder withCommonTestRules() {
            this.withError(PathValidatorKt.getINVALID_SLASHES());
            this.withError(PathValidatorKt.getILLEGAL_CHARACTER());
            this.withWarning(PathValidatorKt.getWHITESPACE());
            if (SystemInfo.isWindows) {
                this.withError(PathValidatorKt.getILLEGAL_WINDOWS_FILENAME());
                this.withError(PathValidatorKt.getNON_ASCII_CHARS());
            } else {
                this.withWarning(PathValidatorKt.getILLEGAL_WINDOWS_FILENAME());
                this.withWarning(PathValidatorKt.getNON_ASCII_CHARS());
            }
            this.withError(PathValidatorKt.getPARENT_DIRECTORY_NOT_WRITABLE());
            this.withError(PathValidatorKt.getLOCATION_IS_A_FILE());
            this.withError(PathValidatorKt.getLOCATION_IS_ROOT());
            this.withError(PathValidatorKt.getPARENT_IS_NOT_A_DIRECTORY());
            this.withError(PathValidatorKt.getPATH_INSIDE_ANDROID_STUDIO());
            return this;
        }

        @NotNull
        public final Builder withError(@NotNull Rule rule) {
            Builder builder2 = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder2;
            boolean bl3 = false;
            $this$apply.errors.add(rule);
            return builder2;
        }

        @NotNull
        public final Builder withWarning(@NotNull Rule rule) {
            Builder builder2 = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder2;
            boolean bl3 = false;
            $this$apply.warnings.add(rule);
            return builder2;
        }

        @JvmOverloads
        @NotNull
        public final PathValidator build(@NotNull String pathName, @NotNull FileOp fileOp) {
            return new PathValidator(pathName, this.errors, this.warnings, fileOp, null);
        }

        public static /* synthetic */ PathValidator build$default(Builder builder2, String string, FileOp fileOp, int n, Object object) {
            if ((n & 2) != 0) {
                fileOp = FileOpUtils.create();
            }
            return builder2.build(string, fileOp);
        }

        @JvmOverloads
        @NotNull
        public final PathValidator build(@NotNull String pathName) {
            return Builder.build$default(this, pathName, null, 2, null);
        }

        public Builder() {
            boolean bl = false;
            this.errors = new ArrayList();
            bl = false;
            this.warnings = new ArrayList();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/ui/validation/validators/PathValidator$Companion;", "", "()V", "createDefault", "Lcom/android/tools/idea/ui/validation/validators/PathValidator;", "pathName", "", "forAndroidNdkLocation", "forAndroidSdkLocation", "intellij.android.core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final PathValidator createDefault(@NotNull String pathName) {
            return Builder.build$default(new Builder().withAllRules(), pathName, null, 2, null);
        }

        @JvmStatic
        @NotNull
        public final PathValidator forAndroidSdkLocation() {
            return Builder.build$default(new Builder().withCommonRules(), "Android SDK location", null, 2, null);
        }

        @JvmStatic
        @NotNull
        public final PathValidator forAndroidNdkLocation() {
            return Builder.build$default(new Builder().withCommonRules(), "Android NDK location", null, 2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

