/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.GradientStopModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchGradient;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchPoint2D;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradientModel {
    public static final Logger LOG = Logger.getInstance(SketchGradient.class);
    public static final String GRADIENT_LINEAR = "linear";
    public static final String GRADIENT_RADIAL = "radial";
    public static final String GRADIENT_SWEEP = "sweep";
    private static final String[] TYPES = new String[]{"linear", "radial", "sweep"};
    private int myGradientType;
    @NotNull
    private SketchPoint2D myFrom;
    @NotNull
    private SketchPoint2D myTo;
    @NotNull
    private GradientStopModel[] myGradientStopModels;

    public GradientModel(int gradientType, @NotNull SketchPoint2D from, @NotNull SketchPoint2D to, @NotNull GradientStopModel[] gradientStopModels) {
        this.myGradientType = gradientType;
        this.myFrom = from;
        this.myTo = to;
        this.myGradientStopModels = gradientStopModels;
    }

    public int getGradientType() {
        return this.myGradientType;
    }

    @NotNull
    public SketchPoint2D getFrom() {
        return this.myFrom;
    }

    @NotNull
    public SketchPoint2D getTo() {
        return this.myTo;
    }

    @NotNull
    public GradientStopModel[] getGradientStopModels() {
        return this.myGradientStopModels;
    }

    @Nullable
    public String getDrawableGradientType() {
        if (this.myGradientType >= 0 && this.myGradientType < TYPES.length) {
            return TYPES[this.getGradientType()];
        }
        LOG.error("Unknown gradient type. Array index is " + this.myGradientType);
        return null;
    }

    @NotNull
    public String getGradientEndX() {
        return Double.toString(this.myTo.getX());
    }

    @NotNull
    public String getGradientEndY() {
        return Double.toString(this.myTo.getY());
    }

    @NotNull
    public String getGradientStartX() {
        return Double.toString(this.myFrom.getX());
    }

    @NotNull
    public String getGradientStartY() {
        return Double.toString(this.myFrom.getY());
    }

    @NotNull
    public String getGradientRadius() {
        double radiusX = Math.pow(this.myTo.x - this.myFrom.x, 2.0);
        double radiusY = Math.pow(this.myTo.y - this.myFrom.y, 2.0);
        return Double.toString(Math.sqrt(radiusX + radiusY));
    }

    @NotNull
    public String getSweepCenterY() {
        return String.valueOf((this.myTo.y + this.myFrom.y) / 2.0);
    }

    public void toRelativeGradient(@NotNull Rectangle2D ownFrame) {
        this.myFrom = this.myFrom.makeAbsolutePosition(ownFrame);
        this.myTo = this.myTo.makeAbsolutePosition(ownFrame);
    }

    public void applyTransformation(@NotNull AffineTransform transformation) {
        Point2D[] origin = new Point2D[]{this.myFrom, this.myTo};
        Point2D[] newPoints = new Point2D[2];
        transformation.transform(origin, 0, newPoints, 0, 2);
        this.myFrom.setLocation(newPoints[0]);
        this.myTo.setLocation(newPoints[1]);
    }
}

