/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.plugin;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.rendering.DrawableRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.DrawableAssetRendererKt;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.text.ParseException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000e0\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J6\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000e0\u00072\u0006\u0010\u0012\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\fH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/plugin/DrawableAssetRenderer;", "Lcom/android/tools/idea/ui/resourcemanager/plugin/DesignAssetRenderer;", "()V", "documentBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "kotlin.jvm.PlatformType", "createRenderer", "Ljava/util/concurrent/CompletableFuture;", "Lcom/android/tools/idea/rendering/DrawableRenderer;", "module", "Lcom/intellij/openapi/module/Module;", "contextFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "failedFuture", "Ljava/awt/image/BufferedImage;", "exception", "", "getImage", "file", "dimension", "Ljava/awt/Dimension;", "context", "", "isFileSupported", "", "intellij.android.core"})
public final class DrawableAssetRenderer
implements DesignAssetRenderer {
    private final DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();

    private final CompletableFuture<DrawableRenderer> createRenderer(Module module2, VirtualFile contextFile) {
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
        if (androidFacet == null) {
            throw (Throwable)new NullPointerException("Facet couldn't be found for use in DrawableRenderer.");
        }
        AndroidFacet facet2 = androidFacet;
        return CompletableFuture.supplyAsync((Supplier)new Supplier<DrawableRenderer>(contextFile, facet2){
            final /* synthetic */ VirtualFile $contextFile;
            final /* synthetic */ AndroidFacet $facet;

            public final DrawableRenderer get() {
                DrawableRenderer drawableRenderer;
                if (this.$contextFile == null) {
                    drawableRenderer = new DrawableRenderer(this.$facet);
                } else {
                    Configuration configuration = ConfigurationManager.getOrCreateInstance(this.$facet).getConfiguration(this.$contextFile);
                    drawableRenderer = new DrawableRenderer(this.$facet, configuration);
                }
                return drawableRenderer;
            }
            {
                this.$contextFile = virtualFile;
                this.$facet = androidFacet;
            }
        }, AppExecutorUtil.getAppExecutorService());
    }

    @Override
    public boolean isFileSupported(@NotNull VirtualFile file2) {
        boolean bl;
        if (Intrinsics.areEqual((Object)file2.getFileType(), (Object)XmlFileType.INSTANCE) ^ true || file2.getLength() == 0L) {
            return false;
        }
        try {
            Document document = this.documentBuilder.parse(file2.getInputStream());
            bl = ArraysKt.contains((Object[])DrawableAssetRendererKt.access$getSUPPORTED_DRAWABLE_TAG$p(), (Object)document.getDocumentElement().getNodeName());
        }
        catch (SAXParseException ex) {
            DrawableAssetRendererKt.access$getLOG$p().debug(Reflection.getOrCreateKotlinClass(ex.getClass()).getSimpleName() + " in " + file2.getPath(), (Throwable)ex);
            return false;
        }
        catch (Exception ex) {
            DrawableAssetRendererKt.access$getLOG$p().warn(Reflection.getOrCreateKotlinClass(ex.getClass()).getSimpleName() + " in " + file2.getPath(), (Throwable)ex);
            return false;
        }
        return bl;
    }

    @Override
    @NotNull
    public CompletableFuture<? extends BufferedImage> getImage(@NotNull VirtualFile file2, @Nullable Module module2, @NotNull Dimension dimension2, @Nullable Object context) {
        try {
            if (module2 == null) {
                throw (Throwable)new NullPointerException("Module cannot be null to render a Drawable.");
            }
            if (!this.isFileSupported(file2)) {
                throw (Throwable)new ParseException(file2.getPath() + " couldn't be parsed as a drawable.", 0);
            }
            Object object = context;
            if (!(object instanceof VirtualFile)) {
                object = null;
            }
            CompletableFuture<DrawableRenderer> renderer2 = this.createRenderer(module2, (VirtualFile)object);
            byte[] byArray = file2.contentsToByteArray();
            boolean bl = false;
            String xmlContent = new String(byArray, Charsets.UTF_8);
            return ((CompletableFuture)renderer2.thenCompose(new Function<DrawableRenderer, CompletionStage<BufferedImage>>(xmlContent, dimension2){
                final /* synthetic */ String $xmlContent;
                final /* synthetic */ Dimension $dimension;

                public final CompletionStage<BufferedImage> apply(DrawableRenderer drawableRenderer) {
                    return drawableRenderer.renderDrawable(this.$xmlContent, this.$dimension);
                }
                {
                    this.$xmlContent = string;
                    this.$dimension = dimension2;
                }
            })).whenComplete(new BiConsumer<BufferedImage, Throwable>(renderer2){
                final /* synthetic */ CompletableFuture $renderer;

                public final void accept(BufferedImage $noName_0, Throwable $noName_1) {
                    Disposer.dispose((Disposable)((Disposable)this.$renderer.get()));
                }
                {
                    this.$renderer = completableFuture;
                }
            });
        }
        catch (Exception ex) {
            return this.failedFuture(ex);
        }
    }

    private final CompletableFuture<? extends BufferedImage> failedFuture(Throwable exception) {
        DrawableAssetRendererKt.access$getLOG$p().warn(exception);
        CompletableFuture failedFuture = new CompletableFuture();
        failedFuture.completeExceptionally(exception);
        return failedFuture;
    }
}

