/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.importer;

import com.android.tools.idea.ui.resourcemanager.ResourceManagerTracking;
import com.android.tools.idea.ui.resourcemanager.explorer.ImportResourceDelegate;
import com.android.tools.idea.ui.resourcemanager.importer.ImportersProvider;
import com.android.tools.idea.ui.resourcemanager.importer.ResourceImportDialog;
import com.android.tools.idea.ui.resourcemanager.importer.ResourceImportDragTargetKt;
import com.android.tools.idea.ui.resourcemanager.importer.ResourceImportManagerKt;
import com.android.tools.idea.ui.resourcemanager.model.DesignAsset;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.util.SystemInfo;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.sequences.Sequence;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/importer/ResourceImportDragTarget;", "Lcom/intellij/ide/dnd/DnDNativeTarget;", "Lcom/android/tools/idea/ui/resourcemanager/explorer/ImportResourceDelegate;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "importersProvider", "Lcom/android/tools/idea/ui/resourcemanager/importer/ImportersProvider;", "(Lorg/jetbrains/android/facet/AndroidFacet;Lcom/android/tools/idea/ui/resourcemanager/importer/ImportersProvider;)V", "getFacet", "()Lorg/jetbrains/android/facet/AndroidFacet;", "setFacet", "(Lorg/jetbrains/android/facet/AndroidFacet;)V", "anyFileCanBeImported", "", "files", "Lkotlin/sequences/Sequence;", "Ljava/io/File;", "canImport", "fileListFlavorAvailable", "filesToImport", "doImport", "transferable", "Ljava/awt/datatransfer/Transferable;", "drop", "", "event", "Lcom/intellij/ide/dnd/DnDEvent;", "hasImporterForFile", "file", "update", "intellij.android.core"})
public final class ResourceImportDragTarget
implements DnDNativeTarget,
ImportResourceDelegate {
    @NotNull
    private AndroidFacet facet;
    private final ImportersProvider importersProvider;

    public boolean update(@NotNull DnDEvent event) {
        if (this.canImport(FileCopyPasteUtil.isFileListFlavorAvailable((DnDEvent)event), (Sequence<? extends File>)ResourceImportDragTargetKt.access$getFilesFromEvent(event))) {
            event.setDropPossible(true, "Import Files in project resources");
            return false;
        }
        return true;
    }

    public void drop(@NotNull DnDEvent event) {
        this.drop((Sequence<? extends File>)ResourceImportDragTargetKt.access$getFilesFromEvent(event));
    }

    @Override
    public boolean doImport(@NotNull Transferable transferable) {
        Sequence files2 = ResourceImportDragTargetKt.access$getFilesFromTransferable(transferable);
        boolean bl = this.canImport(FileCopyPasteUtil.isFileListFlavorAvailable((DataFlavor[])transferable.getTransferDataFlavors()), (Sequence<? extends File>)files2);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean canBeImported = bl;
        boolean bl4 = false;
        if (canBeImported) {
            this.drop((Sequence<? extends File>)files2);
        }
        return bl;
    }

    private final boolean canImport(boolean fileListFlavorAvailable, Sequence<? extends File> filesToImport) {
        return fileListFlavorAvailable && (SystemInfo.isMac || this.anyFileCanBeImported(filesToImport));
    }

    private final boolean anyFileCanBeImported(Sequence<? extends File> files2) {
        boolean bl;
        block1: {
            Sequence<? extends File> $this$any$iv = files2;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                File file2 = (File)element$iv;
                boolean bl2 = false;
                if (!this.hasImporterForFile(file2)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean hasImporterForFile(File file2) {
        Collection collection2 = this.importersProvider.getImportersForExtension(FilesKt.getExtension((File)file2));
        boolean bl = false;
        return !collection2.isEmpty();
    }

    private final void drop(Sequence<? extends File> files2) {
        Sequence<DesignAsset> assetSets = ResourceImportManagerKt.findAllDesignAssets(files2, this.importersProvider);
        ResourceManagerTracking.INSTANCE.logAssetAddedViaDnd(this.facet);
        new ResourceImportDialog(this.facet, assetSets).show();
    }

    @NotNull
    public final AndroidFacet getFacet() {
        return this.facet;
    }

    public final void setFacet(@NotNull AndroidFacet androidFacet) {
        this.facet = androidFacet;
    }

    public ResourceImportDragTarget(@NotNull AndroidFacet facet2, @NotNull ImportersProvider importersProvider) {
        this.facet = facet2;
        this.importersProvider = importersProvider;
    }
}

