/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser.colorpicker2;

import com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorPickerListener;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorPickerModelKt;
import java.awt.Color;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\"J\u000e\u0010*\u001a\u00020(2\u0006\u0010)\u001a\u00020\"J\u001a\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00032\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\u0001J\u001a\u0010/\u001a\u00020,2\u0006\u00100\u001a\u00020\u00032\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\nR\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0010R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\nR\u0011\u0010%\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0010\u00a8\u00061"}, d2={"Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPickerModel;", "", "originalColor", "Ljava/awt/Color;", "(Ljava/awt/Color;)V", "_hsb", "", "alpha", "", "getAlpha", "()I", "blue", "getBlue", "brightness", "", "getBrightness", "()F", "<set-?>", "color", "getColor", "()Ljava/awt/Color;", "green", "getGreen", "hex", "", "getHex", "()Ljava/lang/String;", "hsb", "getHsb", "()[F", "hue", "getHue", "listeners", "", "Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPickerListener;", "red", "getRed", "saturation", "getSaturation", "addListener", "", "listener", "removeListener", "setColor", "", "newColor", "source", "setPickingColor", "newPickingColor", "intellij.android.core"})
public final class ColorPickerModel {
    private final Set<ColorPickerListener> listeners;
    @NotNull
    private Color color;
    private final float[] _hsb;

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    public final void setColor(@NotNull Color newColor, @Nullable Object source) {
        this.color = newColor;
        Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), this._hsb);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColorPickerListener it = (ColorPickerListener)element$iv;
            boolean bl = false;
            it.colorChanged(this.color, source);
        }
    }

    public static /* synthetic */ void setColor$default(ColorPickerModel colorPickerModel, Color color, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        colorPickerModel.setColor(color, object);
    }

    public final void setPickingColor(@NotNull Color newPickingColor, @Nullable Object source) {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ColorPickerListener it = (ColorPickerListener)element$iv;
            boolean bl = false;
            it.pickingColorChanged(newPickingColor, source);
        }
    }

    public static /* synthetic */ void setPickingColor$default(ColorPickerModel colorPickerModel, Color color, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        colorPickerModel.setPickingColor(color, object);
    }

    public final int getRed() {
        return this.color.getRed();
    }

    public final int getGreen() {
        return this.color.getGreen();
    }

    public final int getBlue() {
        return this.color.getBlue();
    }

    public final int getAlpha() {
        return this.color.getAlpha();
    }

    @NotNull
    public final String getHex() {
        return Integer.toHexString(this.color.getRGB());
    }

    @NotNull
    public final float[] getHsb() {
        float[] fArray = this._hsb;
        boolean bl = false;
        float[] fArray2 = Arrays.copyOf(fArray, fArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray2, (String)"java.util.Arrays.copyOf(this, size)");
        return fArray2;
    }

    public final float getHue() {
        return this._hsb[0];
    }

    public final float getSaturation() {
        return this._hsb[1];
    }

    public final float getBrightness() {
        return this._hsb[2];
    }

    public final boolean addListener(@NotNull ColorPickerListener listener2) {
        return this.listeners.add(listener2);
    }

    public final boolean removeListener(@NotNull ColorPickerListener listener2) {
        return this.listeners.remove(listener2);
    }

    public ColorPickerModel(@NotNull Color originalColor) {
        boolean bl = false;
        this.listeners = new LinkedHashSet();
        this.color = originalColor;
        this._hsb = Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), null);
    }

    public /* synthetic */ ColorPickerModel(Color color, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            color = ColorPickerModelKt.getDEFAULT_PICKER_COLOR();
        }
        this(color);
    }

    public ColorPickerModel() {
        this(null, 1, null);
    }
}

