/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport.demo;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.stdui.CommonAction;
import com.android.tools.adtui.stdui.menu.CommonDropDownButton;
import com.android.tools.idea.transport.TransportClient;
import com.android.tools.idea.transport.TransportFileManager;
import com.android.tools.idea.transport.TransportService;
import com.android.tools.idea.transport.poller.TransportEventListener;
import com.android.tools.idea.transport.poller.TransportEventPoller;
import com.android.tools.pipeline.example.proto.Echo;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.google.common.collect.ImmutableMap;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextArea;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransportPipelineDialog
extends DialogWrapper {
    static final String TITLE = "Transport Pipeline";
    private static final String NO_DEVICES_DETECTED = "No devices detected";
    private static final String NO_DEBUGGABLE_PROCESSES = "No debuggable processes detected";
    private JPanel myRootPanel;
    private static final Map<Commands.Command.CommandType, Commands.Command.Builder> SUPPORTED_COMMANDS = ImmutableMap.of((Object)Commands.Command.CommandType.ECHO, (Object)Commands.Command.newBuilder().setType(Commands.Command.CommandType.ECHO).setEchoData(Echo.EchoData.newBuilder().setData("Hello World")));
    @NotNull
    private final CommonAction myProcessSelectionAction;
    @NotNull
    private final CommonDropDownButton myProcessSelectionDropDown;
    @NotNull
    private final JLabel myProcessAgentStatus;
    @NotNull
    private final ComboBox<Commands.Command.CommandType> myCommandComboBox;
    @NotNull
    private final JButton mySendCommandButton;
    @NotNull
    private final ComboBox<Common.Event.Kind> myEventFilter;
    @NotNull
    private final JBTextArea myEventLog;
    @Nullable
    private final TransportClient myClient;
    @Nullable
    private Common.Stream mySelectedStream;
    @Nullable
    private Common.Process mySelectedProcess;
    @NotNull
    private final Map<Long, List<Common.Process>> myProcessesMap;
    @NotNull
    private final Map<Long, Common.Stream> myStreamIdMap;
    @NotNull
    private final Map<Long, Common.Process> myProcessIdMap;
    @NotNull
    private final TransportEventPoller myTransportEventPoller;
    private TransportEventListener mySelectedEventListener;
    private TransportEventListener myAgentStatusListener;

    private long getSelectedStreamId() {
        return this.mySelectedStream.getStreamId();
    }

    private int getSelectedProcessId() {
        return this.mySelectedProcess.getPid();
    }

    public TransportPipelineDialog(@Nullable Project project) {
        super(project);
        this.$$$setupUI$$$();
        this.mySelectedStream = Common.Stream.getDefaultInstance();
        this.mySelectedProcess = Common.Process.getDefaultInstance();
        this.setTitle(TITLE);
        this.setModal(false);
        TransportService.getInstance();
        this.myClient = new TransportClient("DataStoreService");
        this.myProcessSelectionAction = new CommonAction("Select Process", AllIcons.General.Add);
        this.myProcessSelectionDropDown = new CommonDropDownButton(this.myProcessSelectionAction);
        this.myProcessSelectionDropDown.setToolTipText("Select a process to connect to.");
        this.myProcessAgentStatus = new JLabel("");
        this.myCommandComboBox = new ComboBox();
        for (Commands.Command.CommandType type : SUPPORTED_COMMANDS.keySet()) {
            this.myCommandComboBox.addItem((Object)type);
        }
        this.mySendCommandButton = new JButton("Send Command");
        this.mySendCommandButton.addActionListener(e -> {
            Commands.Command.CommandType selectedCommand = (Commands.Command.CommandType)this.myCommandComboBox.getSelectedItem();
            if (SUPPORTED_COMMANDS.containsKey(selectedCommand)) {
                Commands.Command command = SUPPORTED_COMMANDS.get(selectedCommand).setStreamId(this.mySelectedStream.getStreamId()).setPid(this.mySelectedProcess.getPid()).build();
                Transport.ExecuteResponse executeResponse = this.myClient.getTransportStub().execute(Transport.ExecuteRequest.newBuilder().setCommand(command).build());
            }
        });
        this.myProcessesMap = new HashMap<Long, List<Common.Process>>();
        this.myStreamIdMap = new HashMap<Long, Common.Stream>();
        this.myProcessIdMap = new HashMap<Long, Common.Process>();
        this.myTransportEventPoller = TransportEventPoller.createPoller(this.myClient.getTransportStub(), TimeUnit.MILLISECONDS.toNanos(250L));
        this.initializeEventListeners();
        this.myEventFilter = new ComboBox();
        for (Common.Event.Kind kind : Common.Event.Kind.values()) {
            if (kind == Common.Event.Kind.UNRECOGNIZED) continue;
            this.myEventFilter.addItem((Object)kind);
        }
        this.myEventLog = new JBTextArea();
        this.myEventFilter.addActionListener(e -> {
            this.myEventLog.setText("");
            if (this.mySelectedEventListener != null) {
                this.myTransportEventPoller.unregisterListener(this.mySelectedEventListener);
            }
            Common.Event.Kind currentEventKind = (Common.Event.Kind)this.myEventFilter.getSelectedItem();
            this.mySelectedEventListener = new TransportEventListener(currentEventKind, arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0), (Function1<? super Common.Event, Boolean>)((Function1)event -> {
                this.myEventLog.append(event.toString());
                return false;
            }));
            this.myTransportEventPoller.registerListener(this.mySelectedEventListener);
        });
        this.init();
        this.toggleControls(false);
        this.rebuildDevicesDropdown();
    }

    protected void dispose() {
        super.dispose();
        TransportEventPoller.stopPoller(this.myTransportEventPoller);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel((LayoutManager)new TabularLayout("Fit,Fit,*"));
        panel2.add((Component)this.myProcessSelectionDropDown, new TabularLayout.Constraint(0, 0));
        panel2.add((Component)this.myProcessAgentStatus, new TabularLayout.Constraint(1, 0, 3));
        panel2.add((Component)new JLabel("Commands"), new TabularLayout.Constraint(2, 0));
        panel2.add((Component)this.myCommandComboBox, new TabularLayout.Constraint(2, 1));
        panel2.add((Component)this.mySendCommandButton, new TabularLayout.Constraint(2, 2));
        panel2.add((Component)new JLabel("Events"), new TabularLayout.Constraint(3, 0));
        panel2.add((Component)this.myEventFilter, new TabularLayout.Constraint(3, 1));
        JBScrollPane logScrollPane = new JBScrollPane((Component)this.myEventLog);
        logScrollPane.setMinimumSize(new Dimension(JBUI.scale((int)300), JBUI.scale((int)600)));
        panel2.add((Component)logScrollPane, new TabularLayout.Constraint(4, 1, 2));
        this.myRootPanel.add((Component)panel2, "Center");
        return this.myRootPanel;
    }

    private void initializeEventListeners() {
        TransportEventListener streamConnectedListener = new TransportEventListener(Common.Event.Kind.STREAM, arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0), (Function1<? super Common.Event, Boolean>)((Function1)event -> event.getStream().hasStreamConnected()), (Function1<? super Common.Event, Boolean>)((Function1)event -> {
            Common.Stream stream = event.getStream().getStreamConnected().getStream();
            this.myStreamIdMap.put(stream.getStreamId(), stream);
            this.myProcessesMap.put(stream.getStreamId(), new ArrayList());
            this.rebuildDevicesDropdown();
            return false;
        }));
        this.myTransportEventPoller.registerListener(streamConnectedListener);
        TransportEventListener streamDisconnectedListener = new TransportEventListener(Common.Event.Kind.STREAM, arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0), (Function1<? super Common.Event, Boolean>)((Function1)event -> !event.getStream().hasStreamConnected()), (Function1<? super Common.Event, Boolean>)((Function1)event -> {
            this.myStreamIdMap.remove(event.getGroupId());
            this.myProcessesMap.remove(event.getGroupId());
            this.rebuildDevicesDropdown();
            return false;
        }));
        this.myTransportEventPoller.registerListener(streamDisconnectedListener);
        TransportEventListener processStartedListener = new TransportEventListener(Common.Event.Kind.PROCESS, arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0), (Function1<? super Common.Event, Boolean>)((Function1)event -> event.getProcess().hasProcessStarted()), (Function1<? super Common.Event, Boolean>)((Function1)event -> {
            Common.Process process = event.getProcess().getProcessStarted().getProcess();
            this.myProcessesMap.get(process.getDeviceId()).add(process);
            this.myProcessIdMap.put(event.getGroupId(), process);
            this.rebuildDevicesDropdown();
            return false;
        }));
        this.myTransportEventPoller.registerListener(processStartedListener);
        TransportEventListener processEndedListener = new TransportEventListener(Common.Event.Kind.PROCESS, arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0), (Function1<? super Common.Event, Boolean>)((Function1)event -> !event.getProcess().hasProcessStarted()), (Function1<? super Common.Event, Boolean>)((Function1)event -> {
            Common.Process process = this.myProcessIdMap.remove(event.getGroupId());
            if (this.myProcessesMap.get(process.getDeviceId()) != null) {
                this.myProcessesMap.get(process.getDeviceId()).remove(process);
            }
            this.rebuildDevicesDropdown();
            return false;
        }));
        this.myTransportEventPoller.registerListener(processEndedListener);
    }

    private void toggleControls(boolean enabled) {
        this.myCommandComboBox.setEnabled(enabled);
        this.mySendCommandButton.setEnabled(enabled);
        this.myEventFilter.setEnabled(enabled);
        this.myEventLog.setEnabled(enabled);
        this.myEventLog.setText("");
        this.myProcessAgentStatus.setVisible(!this.mySelectedProcess.equals((Object)Common.Process.getDefaultInstance()));
        if (this.myProcessAgentStatus.isVisible()) {
            this.myProcessAgentStatus.setText(String.format(enabled ? "Agent connected to %s" : "Awaiting agent for %s", this.mySelectedProcess.getName()));
        }
    }

    private void rebuildDevicesDropdown() {
        this.myProcessSelectionAction.clear();
        Map<Long, List<Common.Process>> processesMap = this.myProcessesMap;
        if (processesMap.isEmpty()) {
            CommonAction noDeviceAction2 = new CommonAction(NO_DEVICES_DETECTED, null);
            noDeviceAction2.setEnabled(false);
            this.myProcessSelectionAction.addChildrenActions(new CommonAction[]{noDeviceAction2});
        } else {
            for (long streamId : processesMap.keySet()) {
                Common.Stream stream = this.myStreamIdMap.get(streamId);
                CommonAction deviceAction = new CommonAction(TransportPipelineDialog.buildDeviceName(stream.getDevice()), null);
                List<Common.Process> processes2 = processesMap.get(streamId);
                this.rebuildProcessesDropdown(deviceAction, stream, processes2);
                this.myProcessSelectionAction.addChildrenActions(new CommonAction[]{deviceAction});
            }
        }
    }

    private void rebuildProcessesDropdown(CommonAction deviceAction, Common.Stream stream, List<Common.Process> processes2) {
        deviceAction.clear();
        if (processes2.isEmpty()) {
            CommonAction noProcessAction = new CommonAction(NO_DEBUGGABLE_PROCESSES, null);
            noProcessAction.setEnabled(false);
            deviceAction.addChildrenActions(new CommonAction[]{noProcessAction});
        } else {
            ArrayList<CommonAction> processActions = new ArrayList<CommonAction>();
            for (Common.Process process : processes2) {
                CommonAction processAction = new CommonAction(String.format(Locale.US, "%s (%d)", process.getName(), process.getPid()), null);
                processAction.setAction(() -> {
                    this.mySelectedStream = stream;
                    this.mySelectedProcess = process;
                    this.registerAgentListener();
                    Commands.Command attachCommand = Commands.Command.newBuilder().setStreamId(this.mySelectedStream.getStreamId()).setPid(this.mySelectedProcess.getPid()).setType(Commands.Command.CommandType.ATTACH_AGENT).setAttachAgent(Commands.AttachAgent.newBuilder().setAgentLibFileName(String.format("libjvmtiagent_%s.so", process.getAbiCpuArch())).setAgentConfigPath(TransportFileManager.getAgentConfigFile())).build();
                    Transport.ExecuteResponse response = this.myClient.getTransportStub().execute(Transport.ExecuteRequest.newBuilder().setCommand(attachCommand).build());
                    this.toggleControls(false);
                });
                processActions.add(processAction);
            }
            deviceAction.addChildrenActions(processActions);
        }
    }

    private void registerAgentListener() {
        if (this.myAgentStatusListener != null) {
            this.myTransportEventPoller.unregisterListener(this.myAgentStatusListener);
        }
        this.myAgentStatusListener = new TransportEventListener(Common.Event.Kind.AGENT, arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0), (Function1<? super Common.Event, Boolean>)((Function1)event -> event.getAgentData().getStatus().equals((Object)Common.AgentData.Status.ATTACHED)), (Function0<Long>)((Function0)this::getSelectedStreamId), (Function0<Integer>)((Function0)this::getSelectedProcessId), (Function1<? super Common.Event, Boolean>)((Function1)event -> {
            this.toggleControls(true);
            return false;
        }));
        this.myTransportEventPoller.registerListener(this.myAgentStatusListener);
    }

    @NotNull
    private static String buildDeviceName(@NotNull Common.Device device) {
        StringBuilder deviceNameBuilder = new StringBuilder();
        String manufacturer = device.getManufacturer();
        String model2 = device.getModel();
        String serial = device.getSerial();
        String suffix = String.format("-%s", serial);
        if (model2.endsWith(suffix)) {
            model2 = model2.substring(0, model2.length() - suffix.length());
        }
        if (!StringUtil.isEmpty((String)manufacturer)) {
            deviceNameBuilder.append(manufacturer);
            deviceNameBuilder.append(" ");
        }
        deviceNameBuilder.append(model2);
        return deviceNameBuilder.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

