/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.android.tools.idea.projectsystem.TestArtifactSearchScopes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ScopeOptimizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestArtifactUseScopeOptimizer
implements ScopeOptimizer {
    @Nullable
    public GlobalSearchScope getScopeToExclude(@NotNull PsiElement element2) {
        VirtualFile file2 = TestArtifactUseScopeOptimizer.findVirtualFile(element2);
        if (file2 == null) {
            return null;
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element2);
        if (module2 == null) {
            return null;
        }
        TestArtifactSearchScopes testScopes = TestArtifactSearchScopes.getInstance(module2);
        if (testScopes == null) {
            return null;
        }
        boolean inAndroidTest = testScopes.isAndroidTestSource(file2);
        boolean inUnitTest = testScopes.isUnitTestSource(file2);
        if (inAndroidTest && inUnitTest) {
            return null;
        }
        if (inAndroidTest) {
            return testScopes.getUnitTestSourceScope();
        }
        if (inUnitTest) {
            return testScopes.getAndroidTestSourceScope();
        }
        return null;
    }

    @Nullable
    private static VirtualFile findVirtualFile(@NotNull PsiElement element2) {
        PsiFile psiFile2 = element2.getContainingFile();
        return psiFile2 != null ? psiFile2.getVirtualFile() : null;
    }
}

