/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeDependencies;
import com.android.ide.common.gradle.model.IdeJavaArtifact;
import com.android.ide.common.gradle.model.IdeSourceProvider;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.Dependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.testartifacts.scopes.ExcludedModules;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExcludedRoots {
    @NotNull
    private final ExcludedModules myExcludedModules;
    private final boolean myAndroidTest;
    @NotNull
    private final Set<File> myExcludedRoots = new HashSet<File>();
    @NotNull
    private final Set<String> myIncludedRootNames = new HashSet<String>();

    ExcludedRoots(@NotNull ExcludedModules excludedModules, @NotNull DependencySet dependenciesToExclude, @NotNull DependencySet dependenciesToInclude, boolean isAndroidTest) {
        this.myExcludedModules = excludedModules;
        this.myAndroidTest = isAndroidTest;
        this.addFolderPathsFromExcludedModules();
        this.addRemainingModelsIfNecessary();
        for (LibraryDependency libraryDependency : dependenciesToInclude.onLibraries()) {
            File[] binaryPaths;
            for (File binaryPath : binaryPaths = libraryDependency.getBinaryPaths()) {
                this.myIncludedRootNames.add(binaryPath.getName());
            }
        }
        this.addLibraryPaths(dependenciesToExclude);
        this.removeLibraryPaths(dependenciesToInclude);
    }

    private void addFolderPathsFromExcludedModules() {
        for (Module module2 : this.myExcludedModules) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module2);
            for (ContentEntry entry : rootManager.getContentEntries()) {
                for (SourceFolder sourceFolder : entry.getSourceFolders()) {
                    this.myExcludedRoots.add(ExcludedRoots.urlToFilePath(sourceFolder.getUrl()));
                }
                CompilerModuleExtension compiler = (CompilerModuleExtension)rootManager.getModuleExtension(CompilerModuleExtension.class);
                String url = compiler.getCompilerOutputUrl();
                if (!StringUtil.isNotEmpty((String)url)) continue;
                this.myExcludedRoots.add(ExcludedRoots.urlToFilePath(url));
            }
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get(module2);
            if (androidModuleModel == null) continue;
            IdeAndroidArtifact artifact = androidModuleModel.getMainArtifact();
            this.myExcludedRoots.addAll(ExcludedRoots.getAdditionalClasspathFolders((IdeBaseArtifact)artifact));
        }
    }

    @Nullable
    private static File urlToFilePath(@NotNull String url) {
        if (url.startsWith("jar://")) {
            return FilePaths.getJarFromJarUrl((String)url);
        }
        String path2 = VfsUtilCore.urlToPath((String)url);
        return new File(FileUtils.toSystemDependentPath((String)path2));
    }

    private void addRemainingModelsIfNecessary() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myExcludedModules.getProject());
        for (Module module2 : moduleManager.getModules()) {
            if (this.myExcludedModules.contains(module2)) continue;
            this.addModuleIfNecessary(module2);
        }
    }

    private void addModuleIfNecessary(@NotNull Module module2) {
        AndroidModuleModel androidModel = AndroidModuleModel.get(module2);
        if (androidModel != null) {
            IdeAndroidArtifact includeArtifact;
            IdeVariant variant2 = androidModel.getSelectedVariant();
            IdeJavaArtifact unitTestArtifact = variant2.getUnitTestArtifact();
            IdeAndroidArtifact androidTestArtifact = variant2.getAndroidTestArtifact();
            IdeJavaArtifact excludeArtifact = this.myAndroidTest ? unitTestArtifact : androidTestArtifact;
            Object object = includeArtifact = this.myAndroidTest ? androidTestArtifact : unitTestArtifact;
            if (excludeArtifact != null) {
                ExcludedRoots.processFolders((IdeBaseArtifact)excludeArtifact, androidModel, this.myExcludedRoots::add);
            }
            if (includeArtifact != null) {
                ExcludedRoots.processFolders((IdeBaseArtifact)includeArtifact, androidModel, this.myExcludedRoots::remove);
            }
        }
    }

    private static void processFolders(@NotNull IdeBaseArtifact artifact, @NotNull AndroidModuleModel androidModel, @NotNull Consumer<File> action2) {
        action2.accept(artifact.getClassesFolder());
        for (File file2 : artifact.getGeneratedSourceFolders()) {
            action2.accept(file2);
        }
        String artifactName = artifact.getName();
        List<IdeSourceProvider> testSourceProviders = androidModel.getTestSourceProviders(artifactName);
        for (IdeSourceProvider sourceProvider : testSourceProviders) {
            for (File file3 : ExcludedRoots.getAllSourceFolders(sourceProvider)) {
                action2.accept(file3);
            }
        }
    }

    public static List<File> getAdditionalClasspathFolders(@NotNull IdeBaseArtifact artifact) {
        return ImmutableList.builder().add((Object)artifact.getJavaResourcesFolder()).addAll((Iterable)artifact.getAdditionalClassesFolders()).build();
    }

    private void addLibraryPaths(@NotNull DependencySet dependencies2) {
        for (LibraryDependency dependency : dependencies2.onLibraries()) {
            Collections.addAll(this.myExcludedRoots, dependency.getBinaryPaths());
        }
    }

    void removeLibraryPaths(@NotNull DependencySet dependencies2) {
        for (Dependency dependency : dependencies2.onModules()) {
            Module module2 = ((ModuleDependency)dependency).getModule();
            if (module2 == null) continue;
            this.addLibraryPaths(module2);
        }
        for (Dependency dependency : dependencies2.onLibraries()) {
            for (File path2 : ((LibraryDependency)dependency).getBinaryPaths()) {
                this.myExcludedRoots.remove(path2);
            }
        }
    }

    private void addLibraryPaths(@NotNull Module module2) {
        AndroidModuleModel model2 = AndroidModuleModel.get(module2);
        if (model2 != null) {
            IdeAndroidArtifact include;
            IdeVariant variant2 = model2.getSelectedVariant();
            IdeJavaArtifact exclude = this.myAndroidTest ? variant2.getUnitTestArtifact() : variant2.getAndroidTestArtifact();
            Object object = include = this.myAndroidTest ? variant2.getAndroidTestArtifact() : variant2.getUnitTestArtifact();
            if (exclude != null) {
                this.addLibraryPaths((IdeBaseArtifact)exclude);
            }
            if (include != null) {
                this.removeLibraryPaths((IdeBaseArtifact)include);
            }
        }
    }

    private void addLibraryPaths(@NotNull IdeBaseArtifact artifact) {
        IdeDependencies dependencies2 = artifact.getLevel2Dependencies();
        dependencies2.getAndroidLibraries().forEach(library -> {
            for (String path2 : library.getLocalJars()) {
                File file2 = new File(path2);
                if (this.isAlreadyIncluded(file2)) continue;
                this.myExcludedRoots.add(file2);
            }
        });
        dependencies2.getJavaLibraries().forEach(library -> {
            File jarFile = library.getArtifact();
            if (!this.isAlreadyIncluded(jarFile)) {
                this.myExcludedRoots.add(jarFile);
            }
        });
    }

    private boolean isAlreadyIncluded(@NotNull File file2) {
        return this.myIncludedRootNames.contains(file2.getName());
    }

    private void removeLibraryPaths(@NotNull IdeBaseArtifact artifact) {
        IdeDependencies dependencies2 = artifact.getLevel2Dependencies();
        dependencies2.getAndroidLibraries().forEach(library -> {
            for (String path2 : library.getLocalJars()) {
                this.myExcludedRoots.remove(new File(path2));
            }
        });
        dependencies2.getJavaLibraries().forEach(library -> this.myExcludedRoots.remove(library.getArtifact()));
    }

    @NotNull
    public Set<File> get() {
        return this.myExcludedRoots;
    }

    public static Collection<File> getAllSourceFolders(IdeSourceProvider provider2) {
        return Stream.of(provider2.getJavaDirectories(), provider2.getResDirectories(), provider2.getAidlDirectories(), provider2.getRenderscriptDirectories(), provider2.getAssetsDirectories(), provider2.getCDirectories(), provider2.getCppDirectories(), provider2.getJniLibsDirectories()).flatMap(it -> it.stream()).collect(Collectors.toList());
    }
}

