/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.junit;

import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfigurable;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConsoleProperties;
import com.android.tools.idea.testartifacts.junit.AndroidTestObject;
import com.android.tools.idea.testartifacts.junit.AndroidTestPackage;
import com.android.tools.idea.testartifacts.junit.AndroidTestsPattern;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class AndroidJUnitConfiguration
extends JUnitConfiguration {
    public AndroidJUnitConfiguration(@NotNull Project project, @NotNull ConfigurationFactory configurationFactory) {
        super(project, new JUnitConfiguration.Data(){

            public TestObject getTestObject(@NotNull JUnitConfiguration configuration) {
                AndroidTestObject testObject = AndroidJUnitConfiguration.fromString(this.TEST_OBJECT, configuration, ExecutionEnvironmentBuilder.create((Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunConfiguration)configuration).build());
                return testObject != null ? testObject : super.getTestObject(configuration);
            }
        }, configurationFactory);
    }

    public TestObject getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        AndroidTestObject testObject = AndroidJUnitConfiguration.fromString(this.getPersistentData().TEST_OBJECT, this, env);
        return testObject != null ? testObject : super.getState(executor, env);
    }

    @NotNull
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor) {
        return new AndroidJUnitConsoleProperties(this, executor);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group2 = new SettingsEditorGroup();
        group2.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new AndroidJUnitConfigurable(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group2);
        group2.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        return group2;
    }

    @NotNull
    public Module[] getModulesToCompile() {
        if ("package".equals(this.getPersistentData().TEST_OBJECT)) {
            Module classpathModule;
            TestSearchScope scope2 = this.getPersistentData().getScope();
            if (scope2 == TestSearchScope.WHOLE_PROJECT) {
                return this.getAllModules().toArray(Module.EMPTY_ARRAY);
            }
            if (scope2 == TestSearchScope.MODULE_WITH_DEPENDENCIES && (classpathModule = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule()) != null) {
                HashSet modules = new HashSet();
                ModuleUtilCore.getDependencies((Module)classpathModule, modules);
                return modules.toArray(Module.EMPTY_ARRAY);
            }
        }
        return this.getModules();
    }

    private static AndroidTestObject fromString(String id, @NotNull JUnitConfiguration configuration, @NotNull ExecutionEnvironment environment) {
        if ("package".equals(id)) {
            return new AndroidTestObject((TestObject)new AndroidTestPackage(configuration, environment));
        }
        if ("pattern".equals(id)) {
            return new AndroidTestObject((TestObject)new AndroidTestsPattern(configuration, environment));
        }
        return null;
    }
}

