/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.view;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.projectsystem.TestArtifactSearchScopes;
import com.android.tools.idea.testartifacts.instrumented.testsuite.actions.ExportAndroidTestResultsAction;
import com.android.tools.idea.testartifacts.instrumented.testsuite.actions.ImportTestGroup;
import com.android.tools.idea.testartifacts.instrumented.testsuite.actions.ImportTestsFromFileAction;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultListener;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultStats;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResults;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultsKt;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestSuiteConstantsKt;
import com.android.tools.idea.testartifacts.instrumented.testsuite.export.AndroidTestResultsXmlFormatter;
import com.android.tools.idea.testartifacts.instrumented.testsuite.logging.AndroidTestSuiteLogger;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDevice;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCase;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCaseResult;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestSuite;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.AndroidTestResultsTableListener;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.AndroidTestResultsTableView;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.AndroidTestResultsTableViewKt;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.AndroidTestSuiteDetailsView;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.AndroidTestSuiteView;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.AndroidTestSuiteView$WhenMappings;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.AndroidTestSuiteViewController;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.DeviceAndApiLevelFilterComboBoxAction;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.DeviceAndApiLevelFilterComboBoxActionListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.wireless.android.sdk.stats.ParallelAndroidTestReportUiEvent;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testframework.sm.SmRunnerBundle;
import com.intellij.execution.testframework.sm.TestHistoryConfiguration;
import com.intellij.execution.testframework.sm.runner.history.actions.AbstractImportTestsAction;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.largeFilesEditor.GuiUtils;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ColorProgressBar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.time.Clock;
import java.time.Duration;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0004\u00a2\u0001\u00a3\u0001BC\b\u0007\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020hH\u0016J\b\u0010i\u001a\u00020fH\u0016J\u0010\u0010j\u001a\u00020f2\u0006\u0010k\u001a\u00020lH\u0016J\b\u0010m\u001a\u00020&H\u0016J\b\u0010n\u001a\u00020fH\u0016J\b\u0010o\u001a\u00020fH\u0003J\u0013\u0010p\u001a\b\u0012\u0004\u0012\u00020r0qH\u0016\u00a2\u0006\u0002\u0010sJ\b\u0010t\u001a\u00020fH\u0016J\b\u0010u\u001a\u00020vH\u0016J\b\u0010w\u001a\u00020\u0014H\u0016J\b\u0010x\u001a\u00020vH\u0016J\b\u0010y\u001a\u00020&H\u0016J\b\u0010z\u001a\u00020&H\u0016J\u001a\u0010{\u001a\u00020f2\u0006\u0010|\u001a\u00020}2\b\u0010~\u001a\u0004\u0018\u00010=H\u0017J\b\u0010\u007f\u001a\u00020fH\u0017J&\u0010\u0080\u0001\u001a\u00020f2\u0007\u0010\u0081\u0001\u001a\u00020=2\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0017J&\u0010\u0086\u0001\u001a\u00020f2\u0007\u0010\u0081\u0001\u001a\u00020=2\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0017J\u001c\u0010\u0087\u0001\u001a\u00020f2\u0007\u0010\u0081\u0001\u001a\u00020=2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0017J\u0012\u0010\u0088\u0001\u001a\u00020f2\u0007\u0010\u0081\u0001\u001a\u00020=H\u0017J\u001c\u0010\u0089\u0001\u001a\u00020f2\u0007\u0010\u0081\u0001\u001a\u00020=2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0017J\u001c\u0010\u008a\u0001\u001a\u00020f2\u0007\u0010\u008b\u0001\u001a\u00020}2\b\u0010~\u001a\u0004\u0018\u00010=H\u0003J\u0013\u0010\u008c\u0001\u001a\u00020f2\b\u0010\u008d\u0001\u001a\u00030\u008e\u0001H\u0016J\u001c\u0010\u008f\u0001\u001a\u00020f2\u0007\u0010\u0090\u0001\u001a\u00020\r2\b\u0010\u0091\u0001\u001a\u00030\u0092\u0001H\u0016J\u001e\u0010\u0093\u0001\u001a\u00020f2\u0007\u0010\u0094\u0001\u001a\u00020\r2\n\u0010\u0095\u0001\u001a\u0005\u0018\u00010\u0096\u0001H\u0016J\t\u0010\u0097\u0001\u001a\u00020fH\u0003J\u0012\u0010\u0098\u0001\u001a\u00020f2\u0007\u0010\u0099\u0001\u001a\u00020\u0014H\u0016J\u0012\u0010\u009a\u0001\u001a\u00020f2\u0007\u0010\u009b\u0001\u001a\u00020\rH\u0016J\u0012\u0010\u009c\u0001\u001a\u00020f2\u0007\u0010\u009d\u0001\u001a\u00020&H\u0016J\t\u0010\u009e\u0001\u001a\u00020fH\u0003J\t\u0010\u009f\u0001\u001a\u00020fH\u0003J\t\u0010\u00a0\u0001\u001a\u00020fH\u0003J\t\u0010\u00a1\u0001\u001a\u00020fH\u0003R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u00020\u00188\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001f\u0010\u001a\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010'\u001a\u00020(8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b)\u0010\u001a\u001a\u0004\b*\u0010+R \u0010,\u001a\u00060-R\u00020\u00008\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b.\u0010\u001a\u001a\u0004\b/\u00100R\u001c\u00101\u001a\u0002028\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b3\u0010\u001a\u001a\u0004\b4\u00105R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00106\u001a\u0002078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b8\u0010\u001a\u001a\u0004\b9\u0010:R\u0014\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010>\u001a\u00060-R\u00020\u00008\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b?\u0010\u001a\u001a\u0004\b@\u00100R\u000e\u0010A\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010B\u001a\u00020C8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bD\u0010\u001a\u001a\u0004\bE\u0010FR\u001c\u0010G\u001a\u00020C8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bH\u0010\u001a\u001a\u0004\bI\u0010FR\u000e\u0010J\u001a\u00020KX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020KX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010M\u001a\u00020\r8CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010OR\u0014\u0010P\u001a\u00020\r8CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010OR\u0014\u0010R\u001a\u00020S8CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u0010UR$\u0010V\u001a\u00020W2\u0006\u0010V\u001a\u00020W8W@WX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bX\u0010Y\"\u0004\bZ\u0010[R\u000e\u0010\\\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010]\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010^\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010_\u001a\u0004\u0018\u00010`X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010b\"\u0004\bc\u0010dR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a4\u0001"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestSuiteView;", "Lcom/intellij/execution/ui/ConsoleView;", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResultListener;", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestResultsTableListener;", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestSuiteDetailsView$AndroidTestSuiteDetailsViewListener;", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestSuiteViewController;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "myProject", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "toolWindowId", "", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "myClock", "Ljava/time/Clock;", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Ljava/lang/String;Lcom/intellij/execution/configurations/RunConfiguration;Ljava/time/Clock;)V", "failedTestCases", "", "myComponentsSplitter", "Lcom/intellij/ui/OnePixelSplitter;", "myDetailsView", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestSuiteDetailsView;", "getMyDetailsView$annotations", "()V", "getMyDetailsView", "()Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestSuiteDetailsView;", "myDeviceAndApiLevelFilterComboBoxAction", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/DeviceAndApiLevelFilterComboBoxAction;", "getMyDeviceAndApiLevelFilterComboBoxAction$annotations", "getMyDeviceAndApiLevelFilterComboBoxAction", "()Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/DeviceAndApiLevelFilterComboBoxAction;", "myExportTestResultsAction", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/actions/ExportAndroidTestResultsAction;", "myFinishedDevices", "myIsImportedResult", "", "myLogger", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/logging/AndroidTestSuiteLogger;", "getMyLogger$annotations", "getMyLogger", "()Lcom/android/tools/idea/testartifacts/instrumented/testsuite/logging/AndroidTestSuiteLogger;", "myPassedToggleButton", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestSuiteView$MyToggleAction;", "getMyPassedToggleButton$annotations", "getMyPassedToggleButton", "()Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestSuiteView$MyToggleAction;", "myProgressBar", "Ljavax/swing/JProgressBar;", "getMyProgressBar$annotations", "getMyProgressBar", "()Ljavax/swing/JProgressBar;", "myResultsTableView", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestResultsTableView;", "getMyResultsTableView$annotations", "getMyResultsTableView", "()Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestResultsTableView;", "myScheduledDevices", "", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;", "mySkippedToggleButton", "getMySkippedToggleButton$annotations", "getMySkippedToggleButton", "myStartedDevices", "myStatusBreakdownText", "Lcom/intellij/ui/components/JBLabel;", "getMyStatusBreakdownText$annotations", "getMyStatusBreakdownText", "()Lcom/intellij/ui/components/JBLabel;", "myStatusText", "getMyStatusText$annotations", "getMyStatusText", "myTestFinishedTimeMillis", "", "myTestStartTimeMillis", "notificationContent", "getNotificationContent", "()Ljava/lang/String;", "notificationTitle", "getNotificationTitle", "notificationType", "Lcom/intellij/notification/NotificationType;", "getNotificationType", "()Lcom/intellij/notification/NotificationType;", "orientation", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestSuiteViewController$Orientation;", "getOrientation", "()Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestSuiteViewController$Orientation;", "setOrientation", "(Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestSuiteViewController$Orientation;)V", "passedTestCases", "scheduledTestCases", "skippedTestCases", "testExecutionDurationOverride", "Ljava/time/Duration;", "getTestExecutionDurationOverride", "()Ljava/time/Duration;", "setTestExecutionDurationOverride", "(Ljava/time/Duration;)V", "addMessageFilter", "", "filter", "Lcom/intellij/execution/filters/Filter;", "allowHeavyFilters", "attachToProcess", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "canPause", "clear", "closeAndroidTestSuiteDetailsView", "createConsoleActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "()[Lcom/intellij/openapi/actionSystem/AnAction;", "dispose", "getComponent", "Ljavax/swing/JComponent;", "getContentSize", "getPreferredFocusableComponent", "hasDeferredOutput", "isOutputPaused", "onAndroidTestResultsRowSelected", "selectedResults", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResults;", "selectedDevice", "onAndroidTestSuiteDetailsViewCloseButtonClicked", "onTestCaseFinished", "device", "testSuite", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestSuite;", "testCase", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestCase;", "onTestCaseStarted", "onTestSuiteFinished", "onTestSuiteScheduled", "onTestSuiteStarted", "openAndroidTestSuiteDetailsView", "results", "performWhenNoDeferredOutput", "runnable", "Ljava/lang/Runnable;", "print", "text", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "printHyperlink", "hyperlinkText", "info", "Lcom/intellij/execution/filters/HyperlinkInfo;", "saveHistory", "scrollTo", "offset", "setHelpId", "helpId", "setOutputPaused", "value", "showNotificationBalloonIfToolWindowIsNotActive", "showSystemNotification", "updateProgress", "updateStatusText", "MyItemSeparator", "MyToggleAction", "intellij.android.core"})
public final class AndroidTestSuiteView
implements ConsoleView,
AndroidTestResultListener,
AndroidTestResultsTableListener,
AndroidTestSuiteDetailsView.AndroidTestSuiteDetailsViewListener,
AndroidTestSuiteViewController {
    @NotNull
    private final JProgressBar myProgressBar;
    @NotNull
    private final JBLabel myStatusText;
    @NotNull
    private final JBLabel myStatusBreakdownText;
    @NotNull
    private final DeviceAndApiLevelFilterComboBoxAction myDeviceAndApiLevelFilterComboBoxAction;
    @NotNull
    private final MyToggleAction myPassedToggleButton;
    @NotNull
    private final MyToggleAction mySkippedToggleButton;
    private final ExportAndroidTestResultsAction myExportTestResultsAction;
    private final OnePixelSplitter myComponentsSplitter;
    @NotNull
    private final AndroidTestResultsTableView myResultsTableView;
    @NotNull
    private final AndroidTestSuiteDetailsView myDetailsView;
    @NotNull
    private final AndroidTestSuiteLogger myLogger;
    private final Set<AndroidDevice> myScheduledDevices;
    private int myStartedDevices;
    private int myFinishedDevices;
    private int scheduledTestCases;
    private int passedTestCases;
    private int failedTestCases;
    private int skippedTestCases;
    private long myTestStartTimeMillis;
    private long myTestFinishedTimeMillis;
    private final boolean myIsImportedResult;
    @Nullable
    private Duration testExecutionDurationOverride;
    private final Project myProject;
    private final String toolWindowId;
    private final RunConfiguration runConfiguration;
    private final Clock myClock;

    @VisibleForTesting
    public static /* synthetic */ void getMyProgressBar$annotations() {
    }

    @NotNull
    public final JProgressBar getMyProgressBar() {
        return this.myProgressBar;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMyStatusText$annotations() {
    }

    @NotNull
    public final JBLabel getMyStatusText() {
        return this.myStatusText;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMyStatusBreakdownText$annotations() {
    }

    @NotNull
    public final JBLabel getMyStatusBreakdownText() {
        return this.myStatusBreakdownText;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMyDeviceAndApiLevelFilterComboBoxAction$annotations() {
    }

    @NotNull
    public final DeviceAndApiLevelFilterComboBoxAction getMyDeviceAndApiLevelFilterComboBoxAction() {
        return this.myDeviceAndApiLevelFilterComboBoxAction;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMyPassedToggleButton$annotations() {
    }

    @NotNull
    public final MyToggleAction getMyPassedToggleButton() {
        return this.myPassedToggleButton;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMySkippedToggleButton$annotations() {
    }

    @NotNull
    public final MyToggleAction getMySkippedToggleButton() {
        return this.mySkippedToggleButton;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMyResultsTableView$annotations() {
    }

    @NotNull
    public final AndroidTestResultsTableView getMyResultsTableView() {
        return this.myResultsTableView;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMyDetailsView$annotations() {
    }

    @NotNull
    public final AndroidTestSuiteDetailsView getMyDetailsView() {
        return this.myDetailsView;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMyLogger$annotations() {
    }

    @NotNull
    public final AndroidTestSuiteLogger getMyLogger() {
        return this.myLogger;
    }

    @Nullable
    public final Duration getTestExecutionDurationOverride() {
        return this.testExecutionDurationOverride;
    }

    public final void setTestExecutionDurationOverride(@Nullable Duration duration2) {
        this.testExecutionDurationOverride = duration2;
    }

    @UiThread
    private final void updateProgress() {
        int completedTestCases = this.passedTestCases + this.failedTestCases + this.skippedTestCases;
        if (this.scheduledTestCases == 0) {
            this.myProgressBar.setValue(0);
            this.myProgressBar.setIndeterminate(false);
            this.myProgressBar.setForeground(ColorProgressBar.BLUE);
        } else {
            this.myProgressBar.setMaximum(this.scheduledTestCases * this.myScheduledDevices.size());
            this.myProgressBar.setValue(completedTestCases * this.myStartedDevices);
            this.myProgressBar.setIndeterminate(false);
            if (this.failedTestCases > 0) {
                this.myProgressBar.setForeground(ColorProgressBar.RED);
            } else if (completedTestCases == this.scheduledTestCases) {
                this.myProgressBar.setForeground(ColorProgressBar.GREEN);
            }
        }
        this.updateStatusText();
    }

    @UiThread
    private final void updateStatusText() {
        boolean bl;
        CharSequence charSequence;
        StringBuilder statusText = new StringBuilder();
        if (this.failedTestCases > 0) {
            statusText.append("<b><font color='#" + ColorUtil.toHex((Color)ColorProgressBar.RED) + "'>" + this.failedTestCases + " failed</font></b>");
        }
        if (this.passedTestCases > 0) {
            charSequence = statusText;
            bl = false;
            if (charSequence.length() > 0) {
                statusText.append(", ");
            }
            statusText.append(this.passedTestCases + " passed");
        }
        if (this.skippedTestCases > 0) {
            charSequence = statusText;
            bl = false;
            if (charSequence.length() > 0) {
                statusText.append(", ");
            }
            statusText.append(this.skippedTestCases + " skipped");
        }
        charSequence = statusText;
        bl = false;
        if (charSequence.length() == 0) {
            statusText.append("0 passed");
        }
        this.myStatusText.setText("<html><nobr>" + statusText + "</nobr></html>");
        this.myStatusText.setMaximumSize(this.myStatusText.getPreferredSize());
        StringBuilder statusBreakdownText = new StringBuilder(this.scheduledTestCases + " tests");
        if (this.myScheduledDevices.size() > 1) {
            statusBreakdownText.append(", " + this.myScheduledDevices.size() + " devices");
        }
        if (this.myTestFinishedTimeMillis != 0L) {
            Duration duration2 = this.testExecutionDurationOverride;
            if (duration2 == null) {
                duration2 = Duration.ofMillis(this.myTestFinishedTimeMillis - this.myTestStartTimeMillis);
            }
            Duration testDuration = duration2;
            Duration roundedTestDuration = testDuration.compareTo(Duration.ofHours(1L)) < 0 ? testDuration : Duration.ofSeconds(testDuration.getSeconds());
            statusBreakdownText.append(", " + StringUtil.formatDuration((long)roundedTestDuration.toMillis(), (String)"\u2009"));
        }
        this.myStatusBreakdownText.setText(statusBreakdownText.toString());
    }

    @Override
    @AnyThread
    public void onTestSuiteScheduled(@NotNull AndroidDevice device) {
        AppUIUtil.invokeOnEdt((Runnable)new Runnable(this, device){
            final /* synthetic */ AndroidTestSuiteView this$0;
            final /* synthetic */ AndroidDevice $device;

            public final void run() {
                if (AndroidTestSuiteView.access$getMyTestStartTimeMillis$p(this.this$0) == 0L) {
                    AndroidTestSuiteView.access$setMyTestStartTimeMillis$p(this.this$0, AndroidTestSuiteView.access$getMyClock$p(this.this$0).millis());
                }
                if (AndroidTestSuiteView.access$getMyScheduledDevices$p(this.this$0).add(this.$device)) {
                    this.this$0.getMyDeviceAndApiLevelFilterComboBoxAction().addDevice(this.$device);
                    if (AndroidTestSuiteView.access$getMyScheduledDevices$p(this.this$0).size() == 1) {
                        this.this$0.getMyResultsTableView().setShowTestStatusColumn(false);
                    } else {
                        this.this$0.getMyDetailsView().setDeviceSelectorListVisible(true);
                        this.this$0.getMyResultsTableView().setShowTestStatusColumn(true);
                    }
                    this.this$0.getMyResultsTableView().addDevice(this.$device);
                    this.this$0.getMyDetailsView().addDevice(this.$device);
                    AndroidTestSuiteView.access$updateProgress(this.this$0);
                    if (AndroidTestSuiteView.access$getMyComponentsSplitter$p(this.this$0).getWidth() > 0) {
                        float f = 0.6f;
                        float f2 = (float)this.this$0.getMyResultsTableView().getPreferredTableWidth() / (float)AndroidTestSuiteView.access$getMyComponentsSplitter$p(this.this$0).getWidth();
                        boolean bl = false;
                        AndroidTestSuiteView.access$getMyComponentsSplitter$p(this.this$0).setProportion(Math.min(f, f2));
                    }
                }
            }
            {
                this.this$0 = androidTestSuiteView;
                this.$device = androidDevice;
            }
        });
    }

    @Override
    @AnyThread
    public void onTestSuiteStarted(@NotNull AndroidDevice device, @NotNull AndroidTestSuite testSuite) {
        AppUIUtil.invokeOnEdt((Runnable)new Runnable(this, testSuite){
            final /* synthetic */ AndroidTestSuiteView this$0;
            final /* synthetic */ AndroidTestSuite $testSuite;

            public final void run() {
                AndroidTestSuiteView androidTestSuiteView = this.this$0;
                AndroidTestSuiteView.access$setScheduledTestCases$p(androidTestSuiteView, AndroidTestSuiteView.access$getScheduledTestCases$p(androidTestSuiteView) + this.$testSuite.getTestCaseCount());
                AndroidTestSuiteView androidTestSuiteView2 = this.this$0;
                int n = AndroidTestSuiteView.access$getMyStartedDevices$p(androidTestSuiteView2);
                AndroidTestSuiteView.access$setMyStartedDevices$p(androidTestSuiteView2, n + 1);
                AndroidTestSuiteView.access$updateProgress(this.this$0);
            }
            {
                this.this$0 = androidTestSuiteView;
                this.$testSuite = androidTestSuite;
            }
        });
    }

    @Override
    @AnyThread
    public void onTestCaseStarted(@NotNull AndroidDevice device, @NotNull AndroidTestSuite testSuite, @NotNull AndroidTestCase testCase) {
        AppUIUtil.invokeOnEdt((Runnable)new Runnable(this, device, testCase){
            final /* synthetic */ AndroidTestSuiteView this$0;
            final /* synthetic */ AndroidDevice $device;
            final /* synthetic */ AndroidTestCase $testCase;

            public final void run() {
                this.this$0.getMyResultsTableView().addTestCase(this.$device, this.$testCase);
                this.this$0.getMyDetailsView().reloadAndroidTestResults();
            }
            {
                this.this$0 = androidTestSuiteView;
                this.$device = androidDevice;
                this.$testCase = androidTestCase;
            }
        });
    }

    @Override
    @AnyThread
    public void onTestCaseFinished(@NotNull AndroidDevice device, @NotNull AndroidTestSuite testSuite, @NotNull AndroidTestCase testCase) {
        AppUIUtil.invokeOnEdt((Runnable)new Runnable(this, testCase){
            final /* synthetic */ AndroidTestSuiteView this$0;
            final /* synthetic */ AndroidTestCase $testCase;

            public final void run() {
                String benchmarkOutput = this.$testCase.getBenchmark();
                if (!StringsKt.isBlank((CharSequence)benchmarkOutput)) {
                    for (String line2 : StringsKt.lines((CharSequence)benchmarkOutput)) {
                        this.this$0.print("benchmark: " + line2 + '\n', ConsoleViewContentType.NORMAL_OUTPUT);
                    }
                }
                AndroidTestCaseResult androidTestCaseResult = (AndroidTestCaseResult)((Object)Preconditions.checkNotNull((Object)((Object)this.$testCase.getResult())));
                if (androidTestCaseResult != null) {
                    switch (AndroidTestSuiteView$WhenMappings.$EnumSwitchMapping$1[androidTestCaseResult.ordinal()]) {
                        case 1: {
                            AndroidTestSuiteView androidTestSuiteView = this.this$0;
                            int n = AndroidTestSuiteView.access$getPassedTestCases$p(androidTestSuiteView);
                            AndroidTestSuiteView.access$setPassedTestCases$p(androidTestSuiteView, n + 1);
                            break;
                        }
                        case 2: {
                            AndroidTestSuiteView androidTestSuiteView = this.this$0;
                            int n = AndroidTestSuiteView.access$getFailedTestCases$p(androidTestSuiteView);
                            AndroidTestSuiteView.access$setFailedTestCases$p(androidTestSuiteView, n + 1);
                            break;
                        }
                        case 3: {
                            AndroidTestSuiteView androidTestSuiteView = this.this$0;
                            int n = AndroidTestSuiteView.access$getSkippedTestCases$p(androidTestSuiteView);
                            AndroidTestSuiteView.access$setSkippedTestCases$p(androidTestSuiteView, n + 1);
                            break;
                        }
                    }
                }
                AndroidTestSuiteView.access$updateProgress(this.this$0);
                this.this$0.getMyResultsTableView().refreshTable();
                this.this$0.getMyDetailsView().reloadAndroidTestResults();
            }
            {
                this.this$0 = androidTestSuiteView;
                this.$testCase = androidTestCase;
            }
        });
    }

    @Override
    @AnyThread
    public void onTestSuiteFinished(@NotNull AndroidDevice device, @NotNull AndroidTestSuite testSuite) {
        AppUIUtil.invokeOnEdt((Runnable)new Runnable(this){
            final /* synthetic */ AndroidTestSuiteView this$0;

            public final void run() {
                AndroidTestSuiteView androidTestSuiteView = this.this$0;
                int n = AndroidTestSuiteView.access$getMyFinishedDevices$p(androidTestSuiteView);
                AndroidTestSuiteView.access$setMyFinishedDevices$p(androidTestSuiteView, n + 1);
                if (AndroidTestSuiteView.access$getMyFinishedDevices$p(this.this$0) == AndroidTestSuiteView.access$getMyScheduledDevices$p(this.this$0).size()) {
                    AndroidTestSuiteView.access$setMyTestFinishedTimeMillis$p(this.this$0, AndroidTestSuiteView.access$getMyClock$p(this.this$0).millis());
                    AndroidTestSuiteView.access$showSystemNotification(this.this$0);
                    AndroidTestSuiteView.access$showNotificationBalloonIfToolWindowIsNotActive(this.this$0);
                    if (!AndroidTestSuiteView.access$getMyIsImportedResult$p(this.this$0)) {
                        ExportAndroidTestResultsAction exportAndroidTestResultsAction = AndroidTestSuiteView.access$getMyExportTestResultsAction$p(this.this$0);
                        boolean bl = false;
                        boolean bl2 = false;
                        ExportAndroidTestResultsAction $this$apply = exportAndroidTestResultsAction;
                        boolean bl3 = false;
                        $this$apply.setDevices(CollectionsKt.toList((Iterable)AndroidTestSuiteView.access$getMyScheduledDevices$p(this.this$0)));
                        $this$apply.setRootResultsNode(this.this$0.getMyResultsTableView().getRootResultsNode());
                        $this$apply.setExecutionDuration(Duration.ofMillis(AndroidTestSuiteView.access$getMyTestFinishedTimeMillis$p(this.this$0) - AndroidTestSuiteView.access$getMyTestStartTimeMillis$p(this.this$0)));
                        AndroidTestSuiteView.access$saveHistory(this.this$0);
                    }
                }
                AndroidTestSuiteView.access$updateProgress(this.this$0);
                this.this$0.getMyResultsTableView().refreshTable();
                this.this$0.getMyDetailsView().reloadAndroidTestResults();
            }
            {
                this.this$0 = androidTestSuiteView;
            }
        });
    }

    @UiThread
    private final void showSystemNotification() {
        SystemNotifications.getInstance().notify("TestRunner", this.getNotificationTitle(), this.getNotificationContent());
    }

    @UiThread
    private final void showNotificationBalloonIfToolWindowIsNotActive() {
        CharSequence charSequence = this.toolWindowId;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(this.myProject);
        if (Intrinsics.areEqual((Object)this.toolWindowId, (Object)toolWindowManager.getActiveToolWindowId())) {
            return;
        }
        String displayId = "Test Results: " + this.toolWindowId;
        NotificationGroup notificationGroup = NotificationGroup.Companion.findRegisteredGroup(displayId);
        if (notificationGroup == null) {
            notificationGroup = NotificationGroup.Companion.toolWindowGroup$default((NotificationGroup.Companion)NotificationGroup.Companion, (String)displayId, (String)this.toolWindowId, (boolean)false, (int)4, null);
        }
        NotificationGroup group2 = notificationGroup;
        NotificationGroup.createNotification$default((NotificationGroup)group2, (String)this.getNotificationTitle(), (String)this.getNotificationContent(), (NotificationType)this.getNotificationType(), null, (int)8, null).notify(this.myProject);
    }

    @UiThread
    private final String getNotificationTitle() {
        AndroidTestResultStats stats = this.myResultsTableView.getRootResultsNode().getResults().getResultStats();
        return stats.getFailed() > 0 ? "Tests Failed" : (stats.getCancelled() > 0 ? "Tests Cancelled" : "Tests Passed");
    }

    @UiThread
    private final String getNotificationContent() {
        boolean bl;
        CharSequence charSequence;
        StringBuilder content2 = new StringBuilder();
        if (this.failedTestCases > 0) {
            content2.append(this.failedTestCases + " failed");
        }
        if (this.passedTestCases > 0) {
            charSequence = content2;
            bl = false;
            if (charSequence.length() > 0) {
                content2.append(", ");
            }
            content2.append(this.passedTestCases + " passed");
        }
        if (this.skippedTestCases > 0) {
            charSequence = content2;
            bl = false;
            if (charSequence.length() > 0) {
                content2.append(", ");
            }
            content2.append(this.skippedTestCases + " skipped");
        }
        charSequence = content2;
        bl = false;
        if (charSequence.length() == 0) {
            content2.append("0 passed");
        }
        return content2.toString();
    }

    @UiThread
    private final NotificationType getNotificationType() {
        AndroidTestResultStats stats = this.myResultsTableView.getRootResultsNode().getResults().getResultStats();
        return stats.getFailed() > 0 ? NotificationType.ERROR : NotificationType.INFORMATION;
    }

    @UiThread
    private final void saveHistory() {
        RunConfiguration runConfiguration = this.runConfiguration;
        if (runConfiguration == null) {
            return;
        }
        RunConfiguration runConfiguration2 = runConfiguration;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, runConfiguration2, this.myProject, SmRunnerBundle.message((String)"sm.test.runner.results.form.save.test.results.title", (Object[])new Object[0]), false, PerformInBackgroundOption.ALWAYS_BACKGROUND){
            private File myResultFile;
            final /* synthetic */ AndroidTestSuiteView this$0;
            final /* synthetic */ RunConfiguration $runConfiguration;

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                String historyFileName = PathUtil.suggestFileName((String)this.$runConfiguration.getName()) + " - " + new SimpleDateFormat("yyyy.MM.dd 'at' HH'h' mm'm' ss's'", Locale.US).format(new Date()) + ".xml";
                File outputFile = new File(TestStateStorage.getTestHistoryRoot((Project)this.myProject), historyFileName);
                FileUtilRt.createParentDirs((File)outputFile);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                if (transformerFactory == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.xml.transform.sax.SAXTransformerFactory");
                }
                SAXTransformerFactory transformerFactory2 = (SAXTransformerFactory)transformerFactory;
                TransformerHandler transformerHandler = transformerFactory2.newTransformerHandler();
                boolean bl = false;
                boolean bl2 = false;
                TransformerHandler $this$apply = transformerHandler;
                boolean bl3 = false;
                Transformer transformer = $this$apply.getTransformer();
                boolean bl4 = false;
                boolean bl5 = false;
                Transformer $this$apply2 = transformer;
                boolean bl6 = false;
                $this$apply2.setOutputProperty("indent", "yes");
                $this$apply2.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                $this$apply.setResult(new StreamResult(new FileWriter(outputFile)));
                TransformerHandler transformerHandler2 = transformerHandler;
                new AndroidTestResultsXmlFormatter(Duration.ofMillis(AndroidTestSuiteView.access$getMyTestFinishedTimeMillis$p(this.this$0) - AndroidTestSuiteView.access$getMyTestStartTimeMillis$p(this.this$0)), this.this$0.getMyResultsTableView().getRootResultsNode(), CollectionsKt.toList((Iterable)AndroidTestSuiteView.access$getMyScheduledDevices$p(this.this$0)), this.$runConfiguration, transformerHandler2, null, 32, null).execute();
                this.myResultFile = outputFile;
            }

            public void onSuccess() {
                if (this.myResultFile != null) {
                    File file2 = this.myResultFile;
                    if (file2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"myResultFile");
                    }
                    if (file2.exists()) {
                        AbstractImportTestsAction.adjustHistory((Project)this.myProject);
                        TestHistoryConfiguration testHistoryConfiguration = TestHistoryConfiguration.getInstance((Project)this.myProject);
                        File file3 = this.myResultFile;
                        if (file3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"myResultFile");
                        }
                        testHistoryConfiguration.registerHistoryItem(file3.getName(), this.$runConfiguration.getName(), this.$runConfiguration.getType().getId());
                    }
                }
            }
            {
                this.this$0 = this$0;
                this.$runConfiguration = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5);
            }

            public static final /* synthetic */ File access$getMyResultFile$p(saveHistory.1 $this) {
                File file2 = $this.myResultFile;
                if (file2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myResultFile");
                }
                return file2;
            }

            public static final /* synthetic */ void access$setMyResultFile$p(saveHistory.1 $this, File file2) {
                $this.myResultFile = file2;
            }
        });
    }

    @Override
    @UiThread
    public void onAndroidTestResultsRowSelected(@NotNull AndroidTestResults selectedResults, @Nullable AndroidDevice selectedDevice) {
        this.openAndroidTestSuiteDetailsView(selectedResults, selectedDevice);
    }

    @Override
    @UiThread
    public void onAndroidTestSuiteDetailsViewCloseButtonClicked() {
        this.closeAndroidTestSuiteDetailsView();
    }

    @UiThread
    private final void openAndroidTestSuiteDetailsView(AndroidTestResults results, AndroidDevice selectedDevice) {
        this.myLogger.addImpression(this.getOrientation() == AndroidTestSuiteViewController.Orientation.HORIZONTAL ? ParallelAndroidTestReportUiEvent.UiElement.TEST_SUITE_DETAILS_HORIZONTAL_VIEW : ParallelAndroidTestReportUiEvent.UiElement.TEST_SUITE_DETAILS_VERTICAL_VIEW);
        this.myDetailsView.setAndroidTestResults(results);
        if (selectedDevice != null) {
            this.myDetailsView.selectDevice(selectedDevice);
        } else if (AndroidTestResultsKt.isRootAggregationResult(results)) {
            this.myDetailsView.selectRawOutput();
        }
        if (!this.myDetailsView.getRootPanel().isVisible()) {
            this.myDetailsView.getRootPanel().setVisible(true);
        }
    }

    @UiThread
    private final void closeAndroidTestSuiteDetailsView() {
        this.myDetailsView.getRootPanel().setVisible(false);
        this.myResultsTableView.clearSelection();
    }

    @Override
    @UiThread
    @NotNull
    public AndroidTestSuiteViewController.Orientation getOrientation() {
        boolean isVertical = this.myComponentsSplitter.getOrientation();
        return isVertical ? AndroidTestSuiteViewController.Orientation.VERTICAL : AndroidTestSuiteViewController.Orientation.HORIZONTAL;
    }

    @Override
    @UiThread
    public void setOrientation(@NotNull AndroidTestSuiteViewController.Orientation orientation) {
        this.myComponentsSplitter.setOrientation(orientation == AndroidTestSuiteViewController.Orientation.VERTICAL);
    }

    public void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        this.myDetailsView.getRawTestLogConsoleView().print(text2, contentType);
    }

    public void clear() {
        this.myDetailsView.getRawTestLogConsoleView().clear();
    }

    public void scrollTo(int offset2) {
        this.myDetailsView.getRawTestLogConsoleView().scrollTo(offset2);
    }

    public void attachToProcess(@NotNull ProcessHandler processHandler) {
        processHandler.putCopyableUserData(AndroidTestSuiteConstantsKt.ANDROID_TEST_RESULT_LISTENER_KEY, (Object)this);
        this.myDetailsView.getRawTestLogConsoleView().attachToProcess(processHandler);
    }

    public void setOutputPaused(boolean value2) {
        this.myDetailsView.getRawTestLogConsoleView().setOutputPaused(value2);
    }

    public boolean isOutputPaused() {
        return this.myDetailsView.getRawTestLogConsoleView().isOutputPaused();
    }

    public boolean hasDeferredOutput() {
        return this.myDetailsView.getRawTestLogConsoleView().hasDeferredOutput();
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
        this.myDetailsView.getRawTestLogConsoleView().performWhenNoDeferredOutput(runnable2);
    }

    public void setHelpId(@NotNull String helpId) {
        this.myDetailsView.getRawTestLogConsoleView().setHelpId(helpId);
    }

    public void addMessageFilter(@NotNull Filter filter2) {
        this.myDetailsView.getRawTestLogConsoleView().addMessageFilter(filter2);
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info2) {
        this.myDetailsView.getRawTestLogConsoleView().printHyperlink(hyperlinkText, info2);
    }

    public int getContentSize() {
        return this.myDetailsView.getRawTestLogConsoleView().getContentSize();
    }

    public boolean canPause() {
        return this.myDetailsView.getRawTestLogConsoleView().canPause();
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        return AnAction.EMPTY_ARRAY;
    }

    public void allowHeavyFilters() {
        this.myDetailsView.getRawTestLogConsoleView().allowHeavyFilters();
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)this.myComponentsSplitter;
    }

    @NotNull
    public JComponent getPreferredFocusableComponent() {
        return this.myResultsTableView.getPreferredFocusableComponent();
    }

    public void dispose() {
        this.myLogger.reportImpressions();
    }

    /*
     * WARNING - void declaration
     */
    @UiThread
    @JvmOverloads
    public AndroidTestSuiteView(@NotNull Disposable parentDisposable, @NotNull Project myProject, @Nullable Module module2, @Nullable String toolWindowId, @Nullable RunConfiguration runConfiguration, @NotNull Clock myClock) {
        JPanel $this$apply;
        void $this$apply2;
        TestArtifactSearchScopes testArtifactSearchScopes;
        Object $this$apply3;
        this.myProject = myProject;
        this.toolWindowId = toolWindowId;
        this.runConfiguration = runConfiguration;
        this.myClock = myClock;
        Object object = new JProgressBar();
        boolean bl = false;
        boolean bl2 = false;
        JProgressBar jProgressBar = object;
        AndroidTestSuiteView androidTestSuiteView = this;
        boolean bl3 = false;
        ((JComponent)$this$apply3).setPreferredSize(new Dimension(170, ((JComponent)$this$apply3).getPreferredSize().height));
        ((JComponent)$this$apply3).setMaximumSize(((JComponent)$this$apply3).getPreferredSize());
        Unit unit = Unit.INSTANCE;
        androidTestSuiteView.myProgressBar = object;
        this.myStatusText = new JBLabel();
        this.myStatusBreakdownText = new JBLabel();
        this.myDeviceAndApiLevelFilterComboBoxAction = new DeviceAndApiLevelFilterComboBoxAction();
        this.myPassedToggleButton = new MyToggleAction("Show passed tests", AndroidTestResultsTableViewKt.getIconFor(AndroidTestCaseResult.PASSED, false), "AndroidTestSuiteView.myPassedToggleButton", true);
        this.mySkippedToggleButton = new MyToggleAction("Show skipped tests", AndroidTestResultsTableViewKt.getIconFor(AndroidTestCaseResult.SKIPPED, false), "AndroidTestSuiteView.mySkippedToggleButton", true);
        object = new ExportAndroidTestResultsAction();
        bl = false;
        bl2 = false;
        $this$apply3 = object;
        androidTestSuiteView = this;
        boolean bl4 = false;
        ((ExportAndroidTestResultsAction)((Object)$this$apply3)).setToolWindowId(this.toolWindowId);
        ((ExportAndroidTestResultsAction)((Object)$this$apply3)).setRunConfiguration(this.runConfiguration);
        unit = Unit.INSTANCE;
        androidTestSuiteView.myExportTestResultsAction = object;
        this.myComponentsSplitter = new OnePixelSplitter(){

            public void doLayout() {
                float f = 0.1f;
                float f2 = this.getProportion();
                float f3 = 0.9f;
                boolean bl = false;
                f2 = Math.min(f2, f3);
                boolean bl2 = false;
                this.setProportion(Math.max(f, f2));
                super.doLayout();
            }
            {
                this.setHonorComponentsMinimumSize(false);
                this.setFocusTraversalPolicyProvider(true);
                this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
            }
        };
        this.myLogger = new AndroidTestSuiteLogger(null, 0L, 3, null);
        boolean bl5 = false;
        this.myScheduledDevices = SetsKt.sortedSetOf((Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                AndroidDevice it = (AndroidDevice)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getId());
                it = (AndroidDevice)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = (Comparable)((Object)it.getId());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        }, (Object[])new AndroidDevice[0]);
        this.myIsImportedResult = this.runConfiguration == null;
        Module module3 = module2;
        if (module3 != null) {
            Module module4 = module3;
            bl2 = false;
            boolean $this$apply4 = false;
            Module it = module4;
            boolean bl6 = false;
            testArtifactSearchScopes = TestArtifactSearchScopes.Companion.getInstance(module2);
        } else {
            testArtifactSearchScopes = null;
        }
        TestArtifactSearchScopes testArtifactSearchScopes2 = testArtifactSearchScopes;
        this.myResultsTableView = new AndroidTestResultsTableView(this, JavaPsiFacade.getInstance((Project)this.myProject), testArtifactSearchScopes2, this.myLogger);
        this.myResultsTableView.setRowFilter((Function1<? super AndroidTestResults, Boolean>)((Function1)new Function1<AndroidTestResults, Boolean>(){

            public final boolean invoke(@NotNull AndroidTestResults testResults) {
                boolean bl;
                if (AndroidTestResultsKt.isRootAggregationResult(testResults)) {
                    return true;
                }
                switch (AndroidTestSuiteView$WhenMappings.$EnumSwitchMapping$0[testResults.getTestResultSummary().ordinal()]) {
                    case 1: {
                        bl = this.getMyPassedToggleButton().isSelected();
                        break;
                    }
                    case 2: {
                        bl = this.getMySkippedToggleButton().isSelected();
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                return bl;
            }
        }));
        this.myResultsTableView.setColumnFilter(this.myDeviceAndApiLevelFilterComboBoxAction.getFilter());
        this.myDeviceAndApiLevelFilterComboBoxAction.setListener(new DeviceAndApiLevelFilterComboBoxActionListener(){

            @Override
            public void onFilterUpdated() {
                this.getMyResultsTableView().refreshTable();
            }
        });
        DefaultActionGroup testFilterActionGroup = new DefaultActionGroup();
        testFilterActionGroup.addAll(new AnAction[]{(AnAction)this.myPassedToggleButton, (AnAction)this.mySkippedToggleButton, (AnAction)Separator.getInstance(), (AnAction)this.myDeviceAndApiLevelFilterComboBoxAction, (AnAction)Separator.getInstance(), this.myResultsTableView.createExpandAllAction(), this.myResultsTableView.createCollapseAllAction(), (AnAction)Separator.getInstance(), this.myResultsTableView.createNavigateToPreviousFailedTestAction(), this.myResultsTableView.createNavigateToNextFailedTestAction(), (AnAction)Separator.getInstance(), (AnAction)new ImportTestGroup(), new ImportTestsFromFileAction(), (AnAction)this.myExportTestResultsAction});
        ActionToolbar myFocusableActionToolbar2 = (ActionToolbar)new ActionToolbarImpl(testFilterActionGroup, "AndroidTestSuiteTable", (ActionGroup)testFilterActionGroup, true){
            final /* synthetic */ DefaultActionGroup $testFilterActionGroup;

            @NotNull
            protected ActionButton createToolbarButton(@NotNull AnAction action2, @Nullable ActionButtonLook look, @NotNull String place, @NotNull Presentation presentation, @NotNull Dimension minimumSize) {
                ActionButton actionButton = super.createToolbarButton(action2, look, place, presentation, minimumSize);
                boolean bl = false;
                boolean bl2 = false;
                ActionButton $this$apply = actionButton;
                boolean bl3 = false;
                $this$apply.setFocusable(true);
                return actionButton;
            }
            {
                this.$testFilterActionGroup = $captured_local_variable$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
        Object object2 = new JPanel(new BorderLayout());
        boolean bl7 = false;
        boolean bl8 = false;
        Object $this$apply5 = object2;
        boolean bl9 = false;
        JPanel jPanel = new JPanel();
        boolean bl10 = false;
        boolean bl11 = false;
        JPanel jPanel2 = jPanel;
        JPanel jPanel3 = $this$apply5;
        boolean bl12 = false;
        $this$apply2.setLayout(new BoxLayout((Container)$this$apply2, 3));
        JPanel jPanel4 = new JPanel();
        boolean bl13 = false;
        boolean bl14 = false;
        JPanel jPanel5 = jPanel4;
        void var26_37 = $this$apply2;
        boolean bl15 = false;
        $this$apply.setLayout(new BoxLayout($this$apply, 2));
        GuiUtils.setStandardLineBorderToPanel((JComponent)$this$apply, (int)0, (int)0, (int)1, (int)0);
        $this$apply.add(Box.createRigidArea(new Dimension(10, 0)));
        $this$apply.add((Component)new JBLabel("Status"));
        $this$apply.add(Box.createRigidArea(new Dimension(10, 0)));
        $this$apply.add(this.myProgressBar);
        $this$apply.add(new MyItemSeparator());
        $this$apply.add((Component)this.myStatusText);
        $this$apply.add(new MyItemSeparator());
        $this$apply.add((Component)this.myStatusBreakdownText);
        $this$apply.add(Box.createHorizontalGlue());
        Unit unit2 = Unit.INSTANCE;
        var26_37.add(jPanel4);
        jPanel4 = new JPanel();
        bl13 = false;
        bl14 = false;
        $this$apply = jPanel4;
        var26_37 = $this$apply2;
        boolean bl16 = false;
        $this$apply.setLayout(new BoxLayout($this$apply, 2));
        GuiUtils.setStandardLineBorderToPanel((JComponent)$this$apply, (int)0, (int)0, (int)1, (int)0);
        $this$apply.add(Box.createRigidArea(new Dimension(10, 0)));
        $this$apply.add((Component)new JBLabel("Filter tests:"));
        $this$apply.add(myFocusableActionToolbar2.getComponent());
        unit2 = Unit.INSTANCE;
        var26_37.add(jPanel4);
        Unit unit3 = Unit.INSTANCE;
        jPanel3.add((Component)jPanel, "North");
        ((Container)$this$apply5).add((Component)this.myResultsTableView.getComponent(), "Center");
        ((JComponent)$this$apply5).setMinimumSize(new Dimension());
        JPanel contentPanel2 = object2;
        this.myComponentsSplitter.setFirstComponent((JComponent)contentPanel2);
        object2 = new AndroidTestSuiteDetailsView(parentDisposable, this, this, this.myProject, this.myLogger);
        bl7 = false;
        bl8 = false;
        $this$apply5 = object2;
        androidTestSuiteView = this;
        boolean bl17 = false;
        ((AndroidTestSuiteDetailsView)$this$apply5).setDeviceSelectorListVisible(false);
        ((AndroidTestSuiteDetailsView)$this$apply5).getRootPanel().setVisible(false);
        ((AndroidTestSuiteDetailsView)$this$apply5).getRootPanel().setMinimumSize(new Dimension());
        unit = Unit.INSTANCE;
        androidTestSuiteView.myDetailsView = object2;
        this.myComponentsSplitter.setSecondComponent((JComponent)this.myDetailsView.getRootPanel());
        this.myResultsTableView.selectRootItem();
        this.updateProgress();
        this.myLogger.addImpressions(ParallelAndroidTestReportUiEvent.UiElement.TEST_SUITE_VIEW, ParallelAndroidTestReportUiEvent.UiElement.TEST_SUITE_VIEW_TABLE_ROW);
        Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)this));
    }

    public /* synthetic */ AndroidTestSuiteView(Disposable disposable2, Project project, Module module2, String string, RunConfiguration runConfiguration, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            runConfiguration = null;
        }
        if ((n & 0x20) != 0) {
            clock = Clock.systemDefaultZone();
        }
        this(disposable2, project, module2, string, runConfiguration, clock);
    }

    @UiThread
    @JvmOverloads
    public AndroidTestSuiteView(@NotNull Disposable parentDisposable, @NotNull Project myProject, @Nullable Module module2, @Nullable String toolWindowId, @Nullable RunConfiguration runConfiguration) {
        this(parentDisposable, myProject, module2, toolWindowId, runConfiguration, null, 32, null);
    }

    @UiThread
    @JvmOverloads
    public AndroidTestSuiteView(@NotNull Disposable parentDisposable, @NotNull Project myProject, @Nullable Module module2, @Nullable String toolWindowId) {
        this(parentDisposable, myProject, module2, toolWindowId, null, null, 48, null);
    }

    @UiThread
    @JvmOverloads
    public AndroidTestSuiteView(@NotNull Disposable parentDisposable, @NotNull Project myProject, @Nullable Module module2) {
        this(parentDisposable, myProject, module2, null, null, null, 56, null);
    }

    public static final /* synthetic */ long access$getMyTestStartTimeMillis$p(AndroidTestSuiteView $this) {
        return $this.myTestStartTimeMillis;
    }

    public static final /* synthetic */ void access$setMyTestStartTimeMillis$p(AndroidTestSuiteView $this, long l) {
        $this.myTestStartTimeMillis = l;
    }

    public static final /* synthetic */ Clock access$getMyClock$p(AndroidTestSuiteView $this) {
        return $this.myClock;
    }

    public static final /* synthetic */ Set access$getMyScheduledDevices$p(AndroidTestSuiteView $this) {
        return $this.myScheduledDevices;
    }

    public static final /* synthetic */ void access$updateProgress(AndroidTestSuiteView $this) {
        $this.updateProgress();
    }

    public static final /* synthetic */ OnePixelSplitter access$getMyComponentsSplitter$p(AndroidTestSuiteView $this) {
        return $this.myComponentsSplitter;
    }

    public static final /* synthetic */ int access$getScheduledTestCases$p(AndroidTestSuiteView $this) {
        return $this.scheduledTestCases;
    }

    public static final /* synthetic */ void access$setScheduledTestCases$p(AndroidTestSuiteView $this, int n) {
        $this.scheduledTestCases = n;
    }

    public static final /* synthetic */ int access$getMyStartedDevices$p(AndroidTestSuiteView $this) {
        return $this.myStartedDevices;
    }

    public static final /* synthetic */ void access$setMyStartedDevices$p(AndroidTestSuiteView $this, int n) {
        $this.myStartedDevices = n;
    }

    public static final /* synthetic */ int access$getPassedTestCases$p(AndroidTestSuiteView $this) {
        return $this.passedTestCases;
    }

    public static final /* synthetic */ void access$setPassedTestCases$p(AndroidTestSuiteView $this, int n) {
        $this.passedTestCases = n;
    }

    public static final /* synthetic */ int access$getFailedTestCases$p(AndroidTestSuiteView $this) {
        return $this.failedTestCases;
    }

    public static final /* synthetic */ void access$setFailedTestCases$p(AndroidTestSuiteView $this, int n) {
        $this.failedTestCases = n;
    }

    public static final /* synthetic */ int access$getSkippedTestCases$p(AndroidTestSuiteView $this) {
        return $this.skippedTestCases;
    }

    public static final /* synthetic */ void access$setSkippedTestCases$p(AndroidTestSuiteView $this, int n) {
        $this.skippedTestCases = n;
    }

    public static final /* synthetic */ int access$getMyFinishedDevices$p(AndroidTestSuiteView $this) {
        return $this.myFinishedDevices;
    }

    public static final /* synthetic */ void access$setMyFinishedDevices$p(AndroidTestSuiteView $this, int n) {
        $this.myFinishedDevices = n;
    }

    public static final /* synthetic */ long access$getMyTestFinishedTimeMillis$p(AndroidTestSuiteView $this) {
        return $this.myTestFinishedTimeMillis;
    }

    public static final /* synthetic */ void access$setMyTestFinishedTimeMillis$p(AndroidTestSuiteView $this, long l) {
        $this.myTestFinishedTimeMillis = l;
    }

    public static final /* synthetic */ void access$showSystemNotification(AndroidTestSuiteView $this) {
        $this.showSystemNotification();
    }

    public static final /* synthetic */ void access$showNotificationBalloonIfToolWindowIsNotActive(AndroidTestSuiteView $this) {
        $this.showNotificationBalloonIfToolWindowIsNotActive();
    }

    public static final /* synthetic */ boolean access$getMyIsImportedResult$p(AndroidTestSuiteView $this) {
        return $this.myIsImportedResult;
    }

    public static final /* synthetic */ ExportAndroidTestResultsAction access$getMyExportTestResultsAction$p(AndroidTestSuiteView $this) {
        return $this.myExportTestResultsAction;
    }

    public static final /* synthetic */ void access$saveHistory(AndroidTestSuiteView $this) {
        $this.saveHistory();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestSuiteView$MyItemSeparator;", "Ljavax/swing/JComponent;", "()V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "intellij.android.core"})
    private static final class MyItemSeparator
    extends JComponent {
        @Override
        protected void paintComponent(@NotNull Graphics g) {
            if (this.getParent() == null) {
                return;
            }
            double center = (double)this.getWidth() / (double)2;
            int gap = JBUIScale.scale((int)2);
            int y2 = this.getParent().getHeight() - gap * 2;
            g.setColor(JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground());
            Graphics graphics = g;
            if (graphics == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
            }
            LinePainter2D.paint((Graphics2D)((Graphics2D)graphics), (double)center, (double)gap, (double)center, (double)y2);
        }

        public MyItemSeparator() {
            JBDimension mySize = new JBDimension(JBUIScale.scale((int)20), JBUIScale.scale((int)24), true);
            this.setMinimumSize((Dimension)mySize);
            this.setMaximumSize((Dimension)mySize);
            this.setPreferredSize((Dimension)mySize);
            this.setSize((Dimension)mySize);
        }
    }

    @VisibleForTesting
    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0087\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\r\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestSuiteView$MyToggleAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "actionText", "", "actionIcon", "Ljavax/swing/Icon;", "propertiesComponentKey", "defaultState", "", "(Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestSuiteView;Ljava/lang/String;Ljavax/swing/Icon;Ljava/lang/String;Z)V", "value", "isSelected", "()Z", "setSelected", "(Z)V", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "", "state", "intellij.android.core"})
    public final class MyToggleAction
    extends ToggleAction {
        private boolean isSelected;
        private final String propertiesComponentKey;
        private final boolean defaultState;

        public final boolean isSelected() {
            return this.isSelected;
        }

        public final void setSelected(boolean value2) {
            this.isSelected = value2;
            PropertiesComponent.getInstance((Project)AndroidTestSuiteView.this.myProject).setValue(this.propertiesComponentKey, this.isSelected, this.defaultState);
            AndroidTestSuiteView.this.getMyResultsTableView().refreshTable();
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            return this.isSelected;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            this.setSelected(state);
            PropertiesComponent.getInstance((Project)AndroidTestSuiteView.this.myProject).setValue(this.propertiesComponentKey, this.isSelected, this.defaultState);
            AndroidTestSuiteView.this.getMyResultsTableView().refreshTable();
        }

        public MyToggleAction(final @Nullable String actionText, @NotNull Icon actionIcon, String propertiesComponentKey, boolean defaultState) {
            super((Supplier)new Supplier<String>(){

                @Override
                public final String get() {
                    return actionText;
                }
            }, actionIcon);
            this.propertiesComponentKey = propertiesComponentKey;
            this.defaultState = defaultState;
            this.isSelected = PropertiesComponent.getInstance((Project)AndroidTestSuiteView.this.myProject).getBoolean(this.propertiesComponentKey, this.defaultState);
        }
    }
}

