/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.signing.KeystoreHelper;
import com.android.ide.common.signing.KeytoolException;
import com.android.prefs.AndroidLocation;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.SigningConfigModel;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetProperties;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\nH\u0007J\u001a\u0010\u0013\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0015\u001a\u00020\fJ(\u0010\u0016\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\fH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/templates/KeystoreUtils;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "getCertificate", "Ljava/security/cert/Certificate;", "keyStoreFile", "Ljava/io/File;", "certificateAlias", "", "keyStorePassword", "getDebugKeystore", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "getGradleDebugKeystore", "getOrCreateDefaultDebugKeystore", "getSha1DebugKeystoreSilently", "androidFacet", "valueIfNotFound", "sha1", "keyAlias", "intellij.android.core"})
public final class KeystoreUtils {
    public static final KeystoreUtils INSTANCE;

    private final Logger getLog() {
        boolean $i$f$logger = false;
        return Logger.getInstance(KeystoreUtils.class);
    }

    @JvmStatic
    @NotNull
    public static final File getOrCreateDefaultDebugKeystore() throws KeytoolException, AndroidLocation.AndroidLocationException {
        File debugLocation = new File(KeystoreHelper.defaultDebugKeystoreLocation());
        if (!debugLocation.exists()) {
            File keystoreDirectory = new File(AndroidLocation.getFolder());
            if (!keystoreDirectory.canWrite()) {
                throw (Throwable)new AndroidLocation.AndroidLocationException("Could not create debug keystore because \"" + keystoreDirectory + "\" is not writable");
            }
            StdLogger logger2 = new StdLogger(StdLogger.Level.ERROR);
            KeystoreHelper.createDebugStore(null, (File)debugLocation, (String)"android", (String)"android", (String)"AndroidDebugKey", (ILogger)((ILogger)logger2));
        }
        if (!debugLocation.exists()) {
            throw (Throwable)new AndroidLocation.AndroidLocationException("Could not create debug keystore");
        }
        return debugLocation;
    }

    @NotNull
    public final String getSha1DebugKeystoreSilently(@Nullable AndroidFacet androidFacet, @NotNull String valueIfNotFound) {
        try {
            Object object;
            block5: {
                block4: {
                    object = androidFacet;
                    if (object == null) break block4;
                    AndroidFacet androidFacet2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    AndroidFacet it = androidFacet2;
                    boolean bl3 = false;
                    object = KeystoreUtils.getDebugKeystore(it);
                    if (object != null) break block5;
                }
                object = KeystoreUtils.getOrCreateDefaultDebugKeystore();
            }
            Object sha1File = object;
            return KeystoreUtils.sha1$default((File)sha1File, null, null, 6, null);
        }
        catch (Exception ex) {
            this.getLog().warn((Throwable)ex);
            return valueIfNotFound;
        }
    }

    public static /* synthetic */ String getSha1DebugKeystoreSilently$default(KeystoreUtils keystoreUtils, AndroidFacet androidFacet, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "YOUR_SHA1_KEY_STORE";
        }
        return keystoreUtils.getSha1DebugKeystoreSilently(androidFacet, string);
    }

    @JvmStatic
    @NotNull
    public static final File getDebugKeystore(@NotNull AndroidFacet facet2) {
        File gradleDebugKeystore = INSTANCE.getGradleDebugKeystore(facet2);
        if (gradleDebugKeystore != null) {
            return gradleDebugKeystore;
        }
        AndroidFacetProperties state = ((AndroidFacetConfiguration)facet2.getConfiguration()).getState();
        return !Strings.isNullOrEmpty((String)state.CUSTOM_DEBUG_KEYSTORE_PATH) ? new File(state.CUSTOM_DEBUG_KEYSTORE_PATH) : KeystoreUtils.getOrCreateDefaultDebugKeystore();
    }

    private final File getGradleDebugKeystore(AndroidFacet facet2) {
        Object v1;
        block6: {
            ProjectBuildModel projectBuildModel2 = ProjectBuildModel.get(facet2.getModule().getProject());
            GradleBuildModel gradleBuildModel = projectBuildModel2.getModuleBuildModel(facet2.getModule());
            if (gradleBuildModel == null) {
                return null;
            }
            GradleBuildModel gradleBuildModel2 = gradleBuildModel;
            Iterable $this$firstOrNull$iv = gradleBuildModel2.android().signingConfigs();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SigningConfigModel it = (SigningConfigModel)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)"debug", (Object)it.name())) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        SigningConfigModel signingConfigModel = v1;
        if (signingConfigModel == null) {
            return null;
        }
        SigningConfigModel signingConfig2 = signingConfigModel;
        String string = signingConfig2.storeFile().valueAsString();
        if (string == null) {
            return null;
        }
        String debugStorePath = string;
        File debugStoreFile = new File(debugStorePath);
        if (debugStoreFile.isAbsolute()) {
            return debugStoreFile;
        }
        File file2 = AndroidRootUtil.findModuleRootFolderPath(facet2.getModule());
        if (file2 == null) {
            return debugStoreFile;
        }
        File moduleRoot = file2;
        return new File(moduleRoot, debugStorePath);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String sha1(@NotNull File keyStoreFile, @Nullable String keyAlias2, @Nullable String keyStorePassword) throws Exception {
        Certificate signingCert = INSTANCE.getCertificate(keyStoreFile, keyAlias2, keyStorePassword);
        try {
            byte[] certBytes = MessageDigest.getInstance("SHA1").digest(signingCert.getEncoded());
            return BaseEncoding.base16().withSeparator(":", 2).encode(certBytes);
        }
        catch (Exception e) {
            throw (Throwable)new Exception("Could not compute SHA1 hash from certificate", e);
        }
    }

    public static /* synthetic */ String sha1$default(File file2, String string, String string2, int n, Object object) throws Exception {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        return KeystoreUtils.sha1(file2, string, string2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String sha1(@NotNull File keyStoreFile, @Nullable String keyAlias2) throws Exception {
        return KeystoreUtils.sha1$default(keyStoreFile, keyAlias2, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String sha1(@NotNull File keyStoreFile) throws Exception {
        return KeystoreUtils.sha1$default(keyStoreFile, null, null, 6, null);
    }

    private final Certificate getCertificate(File keyStoreFile, String certificateAlias, String keyStorePassword) throws Exception {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            InputStream inputStream = new FileInputStream(keyStoreFile);
            String string = keyStorePassword;
            if (string == null) {
                string = "android";
            }
            String string2 = string;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = string3.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            keyStore.load(inputStream, cArray);
            String string4 = certificateAlias;
            if (string4 == null) {
                string4 = keyStore.aliases().nextElement();
            }
            return keyStore.getCertificate(string4);
        }
        catch (GeneralSecurityException exception) {
            throw (Throwable)new Exception("Could not extract certificate from file.", exception);
        }
        catch (IOException exception) {
            throw (Throwable)new Exception("Could not extract certificate from file.", exception);
        }
    }

    private KeystoreUtils() {
    }

    static {
        KeystoreUtils keystoreUtils;
        INSTANCE = keystoreUtils = new KeystoreUtils();
    }
}

