/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.AndroidStartupActivity;
import com.android.tools.idea.templates.TemplateManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

class DynamicTemplateMenuAndroidStartupActivity
implements AndroidStartupActivity {
    private static boolean ourDynamicTemplateMenuCreated;

    DynamicTemplateMenuAndroidStartupActivity() {
    }

    @Override
    @UiThread
    public void runActivity(@NotNull Project project, @NotNull Disposable disposable2) {
        DynamicTemplateMenuAndroidStartupActivity.createDynamicTemplateMenu();
    }

    private static void createDynamicTemplateMenu() {
        if (ourDynamicTemplateMenuCreated) {
            return;
        }
        ourDynamicTemplateMenuCreated = true;
        new Task.Backgroundable(null, "Loading Dynamic Templates", false, PerformInBackgroundOption.ALWAYS_BACKGROUND){
            ActionGroup menu;

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                this.menu = TemplateManager.getInstance().getTemplateCreationMenu();
            }

            public void onFinished() {
                DefaultActionGroup newGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("NewGroup");
                newGroup.addSeparator();
                if (this.menu != null) {
                    newGroup.add((AnAction)this.menu, new Constraints(Anchor.AFTER, "NewFromTemplate"));
                }
            }
        }.queue();
    }
}

