/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.controllers;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.sqlite.DatabaseInspectorAnalyticsTracker;
import com.android.tools.idea.sqlite.controllers.DatabaseInspectorController;
import com.android.tools.idea.sqlite.controllers.SqliteEvaluatorController;
import com.android.tools.idea.sqlite.controllers.SqliteEvaluatorControllerKt;
import com.android.tools.idea.sqlite.controllers.TableController;
import com.android.tools.idea.sqlite.localization.DatabaseInspectorBundle;
import com.android.tools.idea.sqlite.model.DatabaseInspectorModel;
import com.android.tools.idea.sqlite.model.SqliteDatabaseId;
import com.android.tools.idea.sqlite.model.SqliteSchema;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.android.tools.idea.sqlite.model.UtilsKt;
import com.android.tools.idea.sqlite.repository.DatabaseRepository;
import com.android.tools.idea.sqlite.ui.sqliteEvaluator.SqliteEvaluatorView;
import com.android.tools.idea.sqlite.ui.tableView.TableView;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.wireless.android.sdk.stats.AppInspectionEvent;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0081\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012*\u0001\u001f\b\u0007\u0018\u0000 <2\u00020\u0001:\u0004<=>?BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u001dJ\b\u0010)\u001a\u00020\rH\u0016J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0+2\u0006\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020\rH\u0016J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\r0+H\u0016J\u000e\u00101\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u001dJ\u0006\u00102\u001a\u00020\rJ\b\u00103\u001a\u00020\rH\u0002J\u001e\u00104\u001a\b\u0012\u0004\u0012\u00020\r0+2\u0006\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020.H\u0002J\u001e\u00105\u001a\b\u0012\u0004\u0012\u00020\r0+2\u0006\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020.H\u0002J\u0006\u00106\u001a\u00020\u0017J\u0012\u00107\u001a\u00020\r2\n\b\u0002\u00108\u001a\u0004\u0018\u00010\u0017J\u001c\u00109\u001a\b\u0012\u0004\u0012\u00020\r0+2\u0006\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020.J\b\u0010:\u001a\u00020\rH\u0002J\b\u0010;\u001a\u00020\rH\u0002R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController;", "Lcom/android/tools/idea/sqlite/controllers/DatabaseInspectorController$TabController;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/android/tools/idea/sqlite/model/DatabaseInspectorModel;", "databaseRepository", "Lcom/android/tools/idea/sqlite/repository/DatabaseRepository;", "view", "Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorView;", "showSuccessfulExecutionNotification", "Lkotlin/Function1;", "", "", "closeTabInvoked", "Lkotlin/Function0;", "edtExecutor", "Ljava/util/concurrent/Executor;", "taskExecutor", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/sqlite/model/DatabaseInspectorModel;Lcom/android/tools/idea/sqlite/repository/DatabaseRepository;Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorView;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;)V", "getCloseTabInvoked", "()Lkotlin/jvm/functions/Function0;", "currentEvaluationParams", "Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController$EvaluationParams;", "currentTableController", "Lcom/android/tools/idea/sqlite/controllers/TableController;", "lastUsedEvaluationParams", "listeners", "", "Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController$Listener;", "modelListener", "com/android/tools/idea/sqlite/controllers/SqliteEvaluatorController$modelListener$1", "Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController$modelListener$1;", "openDatabases", "Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "queryHistory", "Ljava/util/LinkedList;", "sqliteEvaluatorViewListener", "Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorView$Listener;", "addListener", "listener", "dispose", "executeSqlStatement", "Lcom/google/common/util/concurrent/ListenableFuture;", "databaseId", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "notifyDataMightBeStale", "refreshData", "removeListener", "removeListeners", "resetTable", "runQuery", "runUpdate", "saveEvaluationParams", "setUp", "evaluationParams", "showAndExecuteSqlStatement", "updateDefaultMessage", "updateRunSqliteStatementButtonState", "Companion", "EvaluationParams", "Listener", "SqliteEvaluatorViewListenerImpl", "intellij.android.debuggers"})
public final class SqliteEvaluatorController
implements DatabaseInspectorController.TabController {
    private TableController currentTableController;
    private final SqliteEvaluatorView.Listener sqliteEvaluatorViewListener;
    private final List<Listener> listeners;
    private final List<SqliteDatabaseId> openDatabases;
    private EvaluationParams currentEvaluationParams;
    private EvaluationParams lastUsedEvaluationParams;
    private final LinkedList<String> queryHistory;
    private final modelListener.1 modelListener;
    private final Project project;
    private final DatabaseInspectorModel model;
    private final DatabaseRepository databaseRepository;
    private final SqliteEvaluatorView view;
    private final Function1<String, Unit> showSuccessfulExecutionNotification;
    @NotNull
    private final Function0<Unit> closeTabInvoked;
    private final Executor edtExecutor;
    private final Executor taskExecutor;
    private static final String QUERY_HISTORY_KEY = "com.android.tools.idea.sqlite.queryhistory";
    private static final int MAX_QUERY_HISTORY_SIZE = 5;
    public static final Companion Companion = new Companion(null);

    public final void setUp(@Nullable EvaluationParams evaluationParams) {
        this.model.addListener(this.modelListener);
        this.view.addListener(this.sqliteEvaluatorViewListener);
        this.updateDefaultMessage();
        String[] stringArray = PropertiesComponent.getInstance((Project)this.project).getValues(QUERY_HISTORY_KEY);
        if (stringArray != null) {
            String[] $this$forEach$iv = stringArray;
            boolean $i$f$forEach = false;
            String[] stringArray2 = $this$forEach$iv;
            int n = stringArray2.length;
            for (int j = 0; j < n; ++j) {
                String element$iv;
                String it = element$iv = stringArray2[j];
                boolean bl = false;
                String string = it;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                this.queryHistory.add(string);
            }
        }
        this.view.setQueryHistory(CollectionsKt.toList((Iterable)this.queryHistory));
        if (evaluationParams != null) {
            SqliteStatement statement = UtilsKt.createSqliteStatement$default(this.project, evaluationParams.getStatementText(), null, 4, null);
            if (CollectionsKt.contains((Iterable)this.openDatabases, (Object)evaluationParams.getDatabaseId()) && SqliteEvaluatorControllerKt.access$isQueryStatement$p(statement)) {
                SqliteDatabaseId sqliteDatabaseId = evaluationParams.getDatabaseId();
                if (sqliteDatabaseId == null) {
                    Intrinsics.throwNpe();
                }
                this.showAndExecuteSqlStatement(sqliteDatabaseId, statement);
            } else {
                this.currentEvaluationParams = EvaluationParams.copy$default(this.currentEvaluationParams, null, evaluationParams.getStatementText(), 1, null);
                this.view.showSqliteStatement(this.currentEvaluationParams.getStatementText());
            }
        }
    }

    public static /* synthetic */ void setUp$default(SqliteEvaluatorController sqliteEvaluatorController2, EvaluationParams evaluationParams, int n, Object object) {
        if ((n & 1) != 0) {
            evaluationParams = null;
        }
        sqliteEvaluatorController2.setUp(evaluationParams);
    }

    @Override
    @NotNull
    public ListenableFuture<Unit> refreshData() {
        ListenableFuture listenableFuture = this.currentTableController;
        if (listenableFuture == null || (listenableFuture = listenableFuture.refreshData()) == null) {
            listenableFuture = Futures.immediateFuture((Object)Unit.INSTANCE);
        }
        return listenableFuture;
    }

    @Override
    public void notifyDataMightBeStale() {
        block0: {
            TableController tableController2 = this.currentTableController;
            if (tableController2 == null) break block0;
            tableController2.notifyDataMightBeStale();
        }
    }

    public void dispose() {
        this.view.removeListener(this.sqliteEvaluatorViewListener);
        this.listeners.clear();
        this.model.removeListener(this.modelListener);
    }

    public final void addListener(@NotNull Listener listener2) {
        this.listeners.add(listener2);
    }

    public final void removeListener(@NotNull Listener listener2) {
        this.listeners.remove(listener2);
    }

    public final void removeListeners() {
        this.listeners.clear();
    }

    @NotNull
    public final ListenableFuture<Unit> showAndExecuteSqlStatement(@NotNull SqliteDatabaseId databaseId, @NotNull SqliteStatement sqliteStatement) {
        if (!this.openDatabases.contains(databaseId)) {
            return Futures.immediateFailedFuture((Throwable)new IllegalStateException("Can't evaluate SQLite statement, unknown database: '" + databaseId.getPath() + '\''));
        }
        this.currentEvaluationParams = new EvaluationParams(databaseId, sqliteStatement.getSqliteStatementWithInlineParameters());
        this.view.showSqliteStatement(sqliteStatement.getSqliteStatementWithInlineParameters());
        this.view.setDatabases(new ArrayList(this.openDatabases), this.currentEvaluationParams.getDatabaseId());
        return this.executeSqlStatement(databaseId, sqliteStatement);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final EvaluationParams saveEvaluationParams() {
        v0 = this.lastUsedEvaluationParams;
        if (v0 == null) ** GOTO lbl-1000
        var2_1 = v0;
        var3_2 = false;
        var4_3 = false;
        it = var2_1;
        $i$a$-takeIf-SqliteEvaluatorController$saveEvaluationParams$databaseId$1 = false;
        v0 = Intrinsics.areEqual((Object)this.currentEvaluationParams.getStatementText(), (Object)it.getStatementText()) != false ? var2_1 : null;
        if (v0 != null) {
            v1 = v0.getDatabaseId();
        } else lbl-1000:
        // 2 sources

        {
            v1 = null;
        }
        databaseId = v1;
        return new EvaluationParams(databaseId, this.currentEvaluationParams.getStatementText());
    }

    private final ListenableFuture<Unit> executeSqlStatement(SqliteDatabaseId databaseId, SqliteStatement sqliteStatement) {
        ListenableFuture listenableFuture;
        this.resetTable();
        String newEntry = sqliteStatement.getSqliteStatementWithInlineParameters();
        if (this.queryHistory.contains(newEntry)) {
            this.queryHistory.remove(newEntry);
        } else if (this.queryHistory.size() >= 5) {
            this.queryHistory.removeLast();
        }
        this.queryHistory.addFirst(newEntry);
        this.view.setQueryHistory(CollectionsKt.toList((Iterable)this.queryHistory));
        Collection $this$toTypedArray$iv = this.queryHistory;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        PropertiesComponent.getInstance((Project)this.project).setValues(QUERY_HISTORY_KEY, stringArray);
        this.lastUsedEvaluationParams = new EvaluationParams(databaseId, sqliteStatement.getSqliteStatementWithInlineParameters());
        if (SqliteEvaluatorControllerKt.access$isQueryStatement$p(sqliteStatement)) {
            this.view.showTableView();
            listenableFuture = this.runQuery(databaseId, sqliteStatement);
        } else if (!(databaseId instanceof SqliteDatabaseId.FileSqliteDatabaseId)) {
            listenableFuture = this.runUpdate(databaseId, sqliteStatement);
        } else {
            this.view.showMessagePanel("Modifier statements are disabled on offline databases.");
            listenableFuture = Futures.immediateFuture((Object)Unit.INSTANCE);
        }
        return listenableFuture;
    }

    private final void resetTable() {
        if (this.lastUsedEvaluationParams != null) {
            this.lastUsedEvaluationParams = null;
            this.view.getTableView().resetView();
        }
        if (this.currentTableController != null) {
            TableController tableController2 = this.currentTableController;
            if (tableController2 == null) {
                Intrinsics.throwNpe();
            }
            Disposer.dispose((Disposable)tableController2);
            this.currentTableController = null;
        }
    }

    private final void updateRunSqliteStatementButtonState() {
        this.view.setRunSqliteStatementEnabled(this.currentEvaluationParams.getDatabaseId() != null && !com.android.tools.idea.sqlite.sqlLanguage.UtilsKt.hasParsingError(this.project, this.currentEvaluationParams.getStatementText()));
    }

    private final ListenableFuture<Unit> runQuery(SqliteDatabaseId databaseId, SqliteStatement sqliteStatement) {
        Executor executor = this.taskExecutor;
        Executor executor2 = this.edtExecutor;
        SqliteStatement sqliteStatement2 = sqliteStatement;
        DatabaseRepository databaseRepository = this.databaseRepository;
        SqliteDatabaseId sqliteDatabaseId = databaseId;
        Function0 function0 = runQuery.1.INSTANCE;
        TableView tableView = this.view.getTableView();
        Project project = this.project;
        int n = 0;
        Function0<Unit> function02 = this.getCloseTabInvoked();
        this.currentTableController = new TableController(project, n, tableView, sqliteDatabaseId, function0, databaseRepository, sqliteStatement2, function02, executor2, executor, 2, null);
        Disposable disposable2 = this;
        TableController tableController2 = this.currentTableController;
        if (tableController2 == null) {
            Intrinsics.throwNpe();
        }
        Disposer.register((Disposable)disposable2, (Disposable)tableController2);
        TableController tableController3 = this.currentTableController;
        if (tableController3 == null) {
            Intrinsics.throwNpe();
        }
        return FutureUtils.catching((ListenableFuture)FutureUtils.transform(tableController3.setUp(), (Executor)this.edtExecutor, (Function1)((Function1)new Function1<Unit, Unit>(this){
            final /* synthetic */ SqliteEvaluatorController this$0;

            public final void invoke(@NotNull Unit it) {
                SqliteEvaluatorController.access$getShowSuccessfulExecutionNotification$p(this.this$0).invoke((Object)DatabaseInspectorBundle.INSTANCE.message("statement.run.successfully", new String[0]));
            }
            {
                this.this$0 = sqliteEvaluatorController2;
                super(1);
            }
        })), (Executor)this.edtExecutor, Throwable.class, (Function1)((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ SqliteEvaluatorController this$0;

            public final void invoke(@NotNull Throwable it) {
                SqliteEvaluatorController.access$getView$p(this.this$0).showMessagePanel(DatabaseInspectorBundle.INSTANCE.message("error.running.statement", new String[0]));
            }
            {
                this.this$0 = sqliteEvaluatorController2;
                super(1);
            }
        }));
    }

    private final ListenableFuture<Unit> runUpdate(SqliteDatabaseId databaseId, SqliteStatement sqliteStatement) {
        return FutureUtils.cancelOnDispose((ListenableFuture)FutureUtils.catching((ListenableFuture)FutureUtils.transform(this.databaseRepository.executeStatement(databaseId, sqliteStatement), (Executor)this.edtExecutor, (Function1)((Function1)new Function1<Unit, Unit>(this, databaseId){
            final /* synthetic */ SqliteEvaluatorController this$0;
            final /* synthetic */ SqliteDatabaseId $databaseId;

            public final void invoke(@NotNull Unit it) {
                SqliteEvaluatorController.access$getView$p(this.this$0).showMessagePanel(DatabaseInspectorBundle.INSTANCE.message("statement.run.successfully", new String[0]));
                SqliteEvaluatorController.access$getShowSuccessfulExecutionNotification$p(this.this$0).invoke((Object)DatabaseInspectorBundle.INSTANCE.message("statement.run.successfully", new String[0]));
                Iterable $this$forEach$iv = SqliteEvaluatorController.access$getListeners$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Listener it2 = (Listener)element$iv;
                    boolean bl = false;
                    it2.onSqliteStatementExecuted(this.$databaseId);
                }
            }
            {
                this.this$0 = sqliteEvaluatorController2;
                this.$databaseId = sqliteDatabaseId;
                super(1);
            }
        })), (Executor)this.edtExecutor, Throwable.class, (Function1)((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ SqliteEvaluatorController this$0;

            public final void invoke(@NotNull Throwable throwable) {
                SqliteEvaluatorController.access$getView$p(this.this$0).showMessagePanel(DatabaseInspectorBundle.INSTANCE.message("error.running.statement", new String[0]));
                SqliteEvaluatorController.access$getView$p(this.this$0).reportError(DatabaseInspectorBundle.INSTANCE.message("error.running.statement", new String[0]), throwable);
            }
            {
                this.this$0 = sqliteEvaluatorController2;
                super(1);
            }
        })), (Disposable)this);
    }

    private final void updateDefaultMessage() {
        block1: {
            SqliteDatabaseId sqliteDatabaseId;
            block2: {
                block0: {
                    sqliteDatabaseId = this.currentEvaluationParams.getDatabaseId();
                    if (!(sqliteDatabaseId instanceof SqliteDatabaseId.LiveSqliteDatabaseId)) break block0;
                    this.view.showMessagePanel("Write a query and run it to see results from the selected database.");
                    break block1;
                }
                if (!(sqliteDatabaseId instanceof SqliteDatabaseId.FileSqliteDatabaseId)) break block2;
                this.view.showMessagePanel("The inspector is not connected to an app process.\nYou can inspect and query data, but data is read-only.");
                break block1;
            }
            if (sqliteDatabaseId != null) break block1;
            this.view.showMessagePanel("Select a database from the drop down.");
        }
    }

    @Override
    @NotNull
    public Function0<Unit> getCloseTabInvoked() {
        return this.closeTabInvoked;
    }

    public SqliteEvaluatorController(@NotNull Project project, @NotNull DatabaseInspectorModel model2, @NotNull DatabaseRepository databaseRepository, @NotNull SqliteEvaluatorView view, @NotNull Function1<? super String, Unit> showSuccessfulExecutionNotification, @NotNull Function0<Unit> closeTabInvoked, @NotNull Executor edtExecutor2, @NotNull Executor taskExecutor2) {
        this.project = project;
        this.model = model2;
        this.databaseRepository = databaseRepository;
        this.view = view;
        this.showSuccessfulExecutionNotification = showSuccessfulExecutionNotification;
        this.closeTabInvoked = closeTabInvoked;
        this.edtExecutor = edtExecutor2;
        this.taskExecutor = taskExecutor2;
        this.sqliteEvaluatorViewListener = new SqliteEvaluatorViewListenerImpl();
        boolean bl = false;
        this.listeners = new ArrayList();
        bl = false;
        this.openDatabases = new ArrayList();
        this.currentEvaluationParams = new EvaluationParams(null, "");
        this.queryHistory = new LinkedList();
        this.modelListener = new DatabaseInspectorModel.Listener(this){
            final /* synthetic */ SqliteEvaluatorController this$0;

            public void onDatabasesChanged(@NotNull List<? extends SqliteDatabaseId> openDatabaseIds, @NotNull List<? extends SqliteDatabaseId> closeDatabaseIds) {
                SqliteEvaluatorController.access$getOpenDatabases$p(this.this$0).clear();
                Iterable $this$sortedBy$iv = openDatabaseIds;
                boolean $i$f$sortedBy = false;
                boolean bl = false;
                SqliteEvaluatorController.access$getOpenDatabases$p(this.this$0).addAll(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        SqliteDatabaseId it = (SqliteDatabaseId)a;
                        boolean bl2 = false;
                        Comparable comparable = (Comparable)((Object)it.getName());
                        it = (SqliteDatabaseId)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        String string = it.getName();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                    }
                }));
                if (!CollectionsKt.contains((Iterable)openDatabaseIds, (Object)SqliteEvaluatorController.access$getCurrentEvaluationParams$p(this.this$0).getDatabaseId())) {
                    SqliteEvaluatorController.access$setCurrentEvaluationParams$p(this.this$0, EvaluationParams.copy$default(SqliteEvaluatorController.access$getCurrentEvaluationParams$p(this.this$0), (SqliteDatabaseId)CollectionsKt.firstOrNull((List)SqliteEvaluatorController.access$getOpenDatabases$p(this.this$0)), null, 2, null));
                }
                EvaluationParams evaluationParams = SqliteEvaluatorController.access$getLastUsedEvaluationParams$p(this.this$0);
                if (!CollectionsKt.contains((Iterable)openDatabaseIds, (Object)(evaluationParams != null ? evaluationParams.getDatabaseId() : null))) {
                    SqliteEvaluatorController.access$resetTable(this.this$0);
                }
                SqliteEvaluatorController.access$getView$p(this.this$0).setDatabases((List<? extends SqliteDatabaseId>)new ArrayList<E>(SqliteEvaluatorController.access$getOpenDatabases$p(this.this$0)), SqliteEvaluatorController.access$getCurrentEvaluationParams$p(this.this$0).getDatabaseId());
                SqliteEvaluatorController.access$updateRunSqliteStatementButtonState(this.this$0);
            }

            public void onSchemaChanged(@NotNull SqliteDatabaseId databaseId, @NotNull SqliteSchema oldSchema, @NotNull SqliteSchema newSchema) {
                SqliteEvaluatorController.access$getView$p(this.this$0).schemaChanged(databaseId);
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    public static final /* synthetic */ void access$setLastUsedEvaluationParams$p(SqliteEvaluatorController $this, EvaluationParams evaluationParams) {
        $this.lastUsedEvaluationParams = evaluationParams;
    }

    public static final /* synthetic */ Function1 access$getShowSuccessfulExecutionNotification$p(SqliteEvaluatorController $this) {
        return $this.showSuccessfulExecutionNotification;
    }

    public static final /* synthetic */ SqliteEvaluatorView access$getView$p(SqliteEvaluatorController $this) {
        return $this.view;
    }

    public static final /* synthetic */ List access$getListeners$p(SqliteEvaluatorController $this) {
        return $this.listeners;
    }

    public static final /* synthetic */ List access$getOpenDatabases$p(SqliteEvaluatorController $this) {
        return $this.openDatabases;
    }

    public static final /* synthetic */ void access$resetTable(SqliteEvaluatorController $this) {
        $this.resetTable();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController$SqliteEvaluatorViewListenerImpl;", "Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorView$Listener;", "(Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController;)V", "evaluateCurrentStatement", "", "onDatabaseSelected", "databaseId", "Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "sqliteStatementTextChangedInvoked", "newSqliteStatement", "", "intellij.android.debuggers"})
    private final class SqliteEvaluatorViewListenerImpl
    implements SqliteEvaluatorView.Listener {
        @Override
        public void evaluateCurrentStatement() {
            AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState connectivityState;
            SqliteDatabaseId databaseId;
            SqliteDatabaseId sqliteDatabaseId;
            SqliteDatabaseId sqliteDatabaseId2 = SqliteEvaluatorController.this.currentEvaluationParams.getDatabaseId();
            if (sqliteDatabaseId2 == null) {
                Intrinsics.throwNpe();
            }
            if ((sqliteDatabaseId = (databaseId = sqliteDatabaseId2)) instanceof SqliteDatabaseId.FileSqliteDatabaseId) {
                connectivityState = AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState.CONNECTIVITY_OFFLINE;
            } else if (sqliteDatabaseId instanceof SqliteDatabaseId.LiveSqliteDatabaseId) {
                connectivityState = AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState.CONNECTIVITY_ONLINE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            AppInspectionEvent.DatabaseInspectorEvent.ConnectivityState connectivityState2 = connectivityState;
            DatabaseInspectorAnalyticsTracker.Companion.getInstance(SqliteEvaluatorController.this.project).trackStatementExecuted(connectivityState2, AppInspectionEvent.DatabaseInspectorEvent.StatementContext.USER_DEFINED_STATEMENT_CONTEXT);
            SqliteEvaluatorController.this.executeSqlStatement(databaseId, UtilsKt.createSqliteStatement$default(SqliteEvaluatorController.this.project, SqliteEvaluatorController.this.currentEvaluationParams.getStatementText(), null, 4, null));
        }

        @Override
        public void sqliteStatementTextChangedInvoked(@NotNull String newSqliteStatement) {
            SqliteEvaluatorController.this.currentEvaluationParams = EvaluationParams.copy$default(SqliteEvaluatorController.this.currentEvaluationParams, null, newSqliteStatement, 1, null);
            SqliteEvaluatorController.this.updateRunSqliteStatementButtonState();
        }

        @Override
        public void onDatabaseSelected(@NotNull SqliteDatabaseId databaseId) {
            SqliteEvaluatorController.this.currentEvaluationParams = EvaluationParams.copy$default(SqliteEvaluatorController.this.currentEvaluationParams, databaseId, null, 2, null);
            if (SqliteEvaluatorController.this.lastUsedEvaluationParams == null) {
                SqliteEvaluatorController.this.updateDefaultMessage();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController$Listener;", "", "onSqliteStatementExecuted", "", "databaseId", "Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "intellij.android.debuggers"})
    public static interface Listener {
        public void onSqliteStatementExecuted(@NotNull SqliteDatabaseId var1);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController$EvaluationParams;", "", "databaseId", "Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "statementText", "", "(Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;Ljava/lang/String;)V", "getDatabaseId", "()Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "getStatementText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.debuggers"})
    public static final class EvaluationParams {
        @Nullable
        private final SqliteDatabaseId databaseId;
        @NotNull
        private final String statementText;

        @Nullable
        public final SqliteDatabaseId getDatabaseId() {
            return this.databaseId;
        }

        @NotNull
        public final String getStatementText() {
            return this.statementText;
        }

        public EvaluationParams(@Nullable SqliteDatabaseId databaseId, @NotNull String statementText) {
            this.databaseId = databaseId;
            this.statementText = statementText;
        }

        @Nullable
        public final SqliteDatabaseId component1() {
            return this.databaseId;
        }

        @NotNull
        public final String component2() {
            return this.statementText;
        }

        @NotNull
        public final EvaluationParams copy(@Nullable SqliteDatabaseId databaseId, @NotNull String statementText) {
            return new EvaluationParams(databaseId, statementText);
        }

        public static /* synthetic */ EvaluationParams copy$default(EvaluationParams evaluationParams, SqliteDatabaseId sqliteDatabaseId, String string, int n, Object object) {
            if ((n & 1) != 0) {
                sqliteDatabaseId = evaluationParams.databaseId;
            }
            if ((n & 2) != 0) {
                string = evaluationParams.statementText;
            }
            return evaluationParams.copy(sqliteDatabaseId, string);
        }

        @NotNull
        public String toString() {
            return "EvaluationParams(databaseId=" + this.databaseId + ", statementText=" + this.statementText + ")";
        }

        public int hashCode() {
            SqliteDatabaseId sqliteDatabaseId = this.databaseId;
            String string = this.statementText;
            return (sqliteDatabaseId != null ? sqliteDatabaseId.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EvaluationParams)) break block3;
                    EvaluationParams evaluationParams = (EvaluationParams)object;
                    if (!Intrinsics.areEqual((Object)this.databaseId, (Object)evaluationParams.databaseId) || !Intrinsics.areEqual((Object)this.statementText, (Object)evaluationParams.statementText)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController$Companion;", "", "()V", "MAX_QUERY_HISTORY_SIZE", "", "QUERY_HISTORY_KEY", "", "intellij.android.debuggers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

