/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.wizard.legacy.LicenseAgreementStep;
import com.android.tools.idea.welcome.install.ComponentInstaller;
import com.android.tools.idea.welcome.install.Gvm;
import com.android.tools.idea.welcome.install.Haxm;
import com.android.tools.idea.welcome.install.InstallComponentsOperation;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.install.InstallationIntention;
import com.android.tools.idea.welcome.install.Vm;
import com.android.tools.idea.welcome.install.VmType;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.deprecated.ProgressStep;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.android.tools.idea.wizard.dynamic.DynamicWizardPath;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.Lists;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PlatformUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class VmWizard
extends DynamicWizard {
    @NotNull
    VmType myType;
    @NotNull
    VmPath myVmPath;
    boolean myInvokedToUninstall;

    public VmWizard(boolean invokedToUninstall, @NotNull VmType type) {
        super(null, null, type.toString());
        this.myType = type;
        this.myInvokedToUninstall = invokedToUninstall;
        this.myVmPath = new VmPath(type);
        this.addPath(this.myVmPath);
    }

    @Override
    public void performFinishingActions() {
    }

    @Override
    public void doCancelAction() {
        if (this.myVmPath.canPerformFinishingActions()) {
            this.doFinishAction();
            return;
        }
        if (!this.myInvokedToUninstall) {
            try {
                AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
                ComponentInstaller componentInstaller = new ComponentInstaller(sdkHandler);
                StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
                sdkHandler.getSdkManager((ProgressIndicator)progress).reloadLocalIfNeeded((ProgressIndicator)progress);
                componentInstaller.ensureSdkPackagesUninstalled(this.myVmPath.myVm.getRequiredSdkPackages(), (ProgressIndicator)progress);
            }
            catch (Exception e) {
                Messages.showErrorDialog((String)VmWizard.sdkPackageCleanupFailedMessage(this.myType), (String)"Cleanup Error");
                LOG.warn("Failed to make sure " + (Object)((Object)this.myType) + " SDK package is uninstalled after " + (Object)((Object)this.myType) + " wizard was cancelled", (Throwable)e);
            }
        }
        super.doCancelAction();
    }

    @Override
    public void doFinishAction() {
        if (!this.myVmPath.canPerformFinishingActions()) {
            this.doCancelAction();
            return;
        }
        super.doFinishAction();
    }

    @Override
    @NotNull
    protected String getProgressTitle() {
        return "Finishing install...";
    }

    @Override
    protected String getWizardActionDescription() {
        return (Object)((Object)this.myType) + " Installation";
    }

    private static String sdkPackageCleanupFailedMessage(@NotNull VmType type) {
        return (Object)((Object)type) + " installer cleanup failed. The status of the package in the SDK manager may be reflected incorrectly. Reinstalling the package may solve the issue" + (SystemInfo.isWindows ? " (is the SDK folder opened in another program?)" : ".");
    }

    private class VmPath
    extends DynamicWizardPath {
        @NotNull
        SetupProgressStep mySetupProgressStep;
        @NotNull
        VmType myType;
        @NotNull
        Vm myVm;

        private VmPath(VmType type) {
            this.myType = type;
        }

        @Override
        protected void init() {
            String key = "Show" + (Object)((Object)this.myType) + "Steps";
            ScopedStateStore.Key<Boolean> canShow = ScopedStateStore.createKey(key, ScopedStateStore.Scope.PATH, Boolean.class);
            this.myState.put(canShow, true);
            InstallationIntention vmInstallationIntention = VmWizard.this.myInvokedToUninstall ? InstallationIntention.UNINSTALL : InstallationIntention.INSTALL_WITH_UPDATES;
            this.myVm = this.myType == VmType.HAXM ? new Haxm(vmInstallationIntention, canShow) : new Gvm(vmInstallationIntention, canShow);
            for (DynamicWizardStep step2 : this.myVm.createSteps()) {
                this.addStep(step2);
            }
            if (!VmWizard.this.myInvokedToUninstall) {
                this.addStep(new LicenseAgreementStep(this.getWizard().getDisposable()));
            }
            this.mySetupProgressStep = new SetupProgressStep(this.getWizard().getDisposable(), this.myVm, VmWizard.this.myHost, this.myType);
            this.addStep(this.mySetupProgressStep);
            this.myVm.init(this.mySetupProgressStep);
        }

        @Override
        @NotNull
        public String getPathName() {
            return (Object)((Object)this.myType) + " Path";
        }

        @Override
        public boolean canPerformFinishingActions() {
            return this.mySetupProgressStep.isSuccessfullyCompleted();
        }

        @Override
        public boolean performFinishingActions() {
            return true;
        }
    }

    private static class SetupProgressStep
    extends ProgressStep {
        @NotNull
        VmType myType;
        @NotNull
        private Vm myVm;
        @NotNull
        private final AtomicBoolean myIsSuccessfullyCompleted = new AtomicBoolean(false);
        @NotNull
        private DynamicWizardHost myHost;
        @NotNull
        private StudioLoggerProgressIndicator myProgressIndicator;

        SetupProgressStep(@NotNull Disposable parentDisposable, @NotNull Vm vm, @NotNull DynamicWizardHost host, @NotNull VmType type) {
            super(parentDisposable, "Invoking installer");
            this.myType = type;
            this.myVm = vm;
            this.myHost = host;
            this.myProgressIndicator = new StudioLoggerProgressIndicator(this.getClass());
        }

        @Override
        public boolean canGoNext() {
            return false;
        }

        public boolean isSuccessfullyCompleted() {
            return this.myIsSuccessfullyCompleted.get();
        }

        @Override
        protected void execute() {
            this.myHost.runSensitiveOperation(this.getProgressIndicator(), true, () -> {
                try {
                    this.setupVm();
                    this.myIsSuccessfullyCompleted.set(this.myVm.isInstallerSuccessfullyCompleted());
                }
                catch (Exception e) {
                    DynamicWizard.LOG.warn("Exception caught while trying to configure " + (Object)((Object)this.myType), (Throwable)e);
                    this.showConsole();
                    this.print(e.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                }
            });
        }

        @Override
        public boolean canGoPrevious() {
            return false;
        }

        private void setupVm() throws IOException {
            InstallOperation opChain;
            File tmpDir = FileUtil.createTempDirectory((String)PlatformUtils.getPlatformPrefix(), (String)this.myType.toString(), (boolean)true);
            InstallContext installContext = new InstallContext(tmpDir, this);
            AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
            this.myVm.updateState(sdkHandler);
            ComponentInstaller componentInstaller = new ComponentInstaller(sdkHandler);
            ArrayList selectedComponents = Lists.newArrayList((Object[])new Vm[]{this.myVm});
            double configureVmProgressRatio = 1.0;
            if (this.myVm.installationIntention == InstallationIntention.INSTALL_WITH_UPDATES) {
                configureVmProgressRatio = 0.5;
            }
            InstallOperation configureVmOperation = InstallOperation.wrap(installContext, input -> {
                this.myVm.configure(installContext, sdkHandler);
                return input;
            }, configureVmProgressRatio);
            if (this.myVm.installationIntention == InstallationIntention.INSTALL_WITH_UPDATES) {
                InstallComponentsOperation install = new InstallComponentsOperation(installContext, selectedComponents, componentInstaller, 0.5);
                opChain = install.then(configureVmOperation);
            } else {
                opChain = configureVmOperation;
            }
            try {
                opChain.execute(sdkHandler.getLocation());
            }
            catch (InstallationCancelledException e) {
                installContext.print("Android Studio setup was canceled", ConsoleViewContentType.ERROR_OUTPUT);
            }
            catch (WizardException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (!this.myVm.isInstallerSuccessfullyCompleted() && this.myVm.installationIntention != InstallationIntention.UNINSTALL) {
                    sdkHandler.getSdkManager((ProgressIndicator)this.myProgressIndicator).reloadLocalIfNeeded((ProgressIndicator)this.myProgressIndicator);
                    componentInstaller.ensureSdkPackagesUninstalled(this.myVm.getRequiredSdkPackages(), (ProgressIndicator)this.myProgressIndicator);
                }
            }
            installContext.print("Done", ConsoleViewContentType.NORMAL_OUTPUT);
        }
    }
}

