/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkPaths {
    private SdkPaths() {
    }

    @NotNull
    public static ValidationResult validateAndroidSdk(@Nullable File sdkPath, boolean includePathInMessage) {
        return SdkPaths.validatedSdkPath(sdkPath, "SDK", false, includePathInMessage);
    }

    @NotNull
    public static ValidationResult validateAndroidNdk(@Nullable File ndkPath, boolean includePathInMessage) {
        File toolchainsDirPath;
        Validator.Result result2;
        Validator.Severity severity;
        if (ndkPath != null && (severity = (result2 = PathValidator.forAndroidNdkLocation().validate(ndkPath)).getSeverity()) == Validator.Severity.ERROR) {
            return ValidationResult.error(result2.getMessage());
        }
        ValidationResult validationResult = SdkPaths.validatedSdkPath(ndkPath, "NDK", false, includePathInMessage);
        if (validationResult.success && ndkPath != null && !(toolchainsDirPath = new File(ndkPath, "toolchains")).isDirectory()) {
            String message2 = includePathInMessage ? String.format("The NDK at\n'%1$s'\ndoes not contain any toolchains.", ndkPath.getPath()) : "NDK does not contain any toolchains.";
            return ValidationResult.error(message2);
        }
        return validationResult;
    }

    @NotNull
    private static ValidationResult validatedSdkPath(@Nullable File sdkPath, @NotNull String sdkName, boolean checkForWritable, boolean includePathInMessage) {
        if (sdkPath == null) {
            return ValidationResult.error("");
        }
        String cause = null;
        if (!sdkPath.isDirectory()) {
            cause = "does not belong to a directory.";
        } else if (!sdkPath.canRead()) {
            cause = "is not readable.";
        } else if (checkForWritable && !sdkPath.canWrite()) {
            cause = "is not writable.";
        }
        if (StringUtil.isNotEmpty((String)cause)) {
            String message2 = includePathInMessage ? String.format("The %1$s path\n'%2$s'\n%3$s", sdkName, sdkPath.getPath(), cause) : String.format("The %1$s path %2$s", sdkName, cause);
            return ValidationResult.error(message2);
        }
        File platformsDirPath = new File(sdkPath, "platforms");
        if (!platformsDirPath.isDirectory()) {
            String message3 = includePathInMessage ? String.format("The %1$s at\n'%2$s'\ndoes not contain any platforms.", sdkName, sdkPath.getPath()) : String.format("%1$s does not contain any platforms.", sdkName);
            return ValidationResult.error(message3);
        }
        return ValidationResult.SUCCESS;
    }

    public static class ValidationResult {
        @NotNull
        public static final ValidationResult SUCCESS = new ValidationResult(true, null);
        public final boolean success;
        @Nullable
        public final String message;

        @NotNull
        static ValidationResult error(@NotNull String message2) {
            return new ValidationResult(false, message2);
        }

        private ValidationResult(boolean success2, @Nullable String message2) {
            this.success = success2;
            this.message = message2;
        }
    }
}

