/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.util;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.model.AndroidManifestIndex;
import com.android.tools.idea.model.AndroidManifestIndexQueryUtils;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.android.utils.XmlUtils;
import com.intellij.execution.Executor;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LaunchUtils {
    private static final Pattern idKeyPattern = Pattern.compile("--user\\s+([0-9]+)");

    public static boolean canDebugAppOnDevice(@NotNull AndroidFacet facet2, @NotNull IDevice device) {
        return LaunchUtils.canDebugApp(facet2) || LaunchUtils.isDebuggableDevice(device);
    }

    public static boolean canDebugApp(@NotNull AndroidFacet facet2) {
        Boolean isDebuggable = AndroidModuleInfo.getInstance(facet2).isDebuggable();
        return isDebuggable == null || isDebuggable != false;
    }

    public static boolean isDebuggableDevice(@NotNull IDevice device) {
        String buildType = device.getProperty("ro.build.type");
        return "userdebug".equals(buildType) || "eng".equals(buildType);
    }

    public static boolean isWatchFaceApp(@NotNull AndroidFacet facet2) {
        if (AndroidFacet.getInstance((Module)facet2.getModule()) == null) {
            Logger.getInstance(LaunchUtils.class).warn("calling isWatchFaceApp when facet is not ready yet");
            return false;
        }
        MergedManifestSnapshot info2 = MergedManifestManager.getSnapshot(facet2);
        List<DefaultActivityLocator.ActivityWrapper> activities = DefaultActivityLocator.ActivityWrapper.get(info2.getActivities(), info2.getActivityAliases());
        boolean foundExportedActivity = activities.stream().anyMatch(activity -> activity.isLogicallyExported());
        if (foundExportedActivity) {
            return false;
        }
        List<Element> services = info2.getServices();
        if (services.size() != 1) {
            return false;
        }
        Element service = services.get(0);
        Element subTag = XmlUtils.getFirstSubTag((Node)service);
        while (subTag != null) {
            if (ActivityLocatorUtils.containsAction(subTag, "android.service.wallpaper.WallpaperService") && ActivityLocatorUtils.containsCategory(subTag, "com.google.android.wearable.watchface.category.WATCH_FACE")) {
                return true;
            }
            subTag = XmlUtils.getNextTag((Node)subTag);
        }
        return false;
    }

    public static boolean isWatchFeatureRequired(@NotNull AndroidFacet facet2) {
        if (!AndroidManifestIndex.indexEnabled().booleanValue()) {
            return LaunchUtils.isWatchFeatureRequiredFromSnapshot(facet2);
        }
        Project project = facet2.getModule().getProject();
        Collection usedFeatures = (Collection)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> AndroidManifestIndexQueryUtils.queryUsedFeaturesFromManifestIndex(facet2));
        return usedFeatures.stream().anyMatch(feature -> "android.hardware.type.watch".equals(feature.getName()) && (feature.getRequired() == null || "true".equals(feature.getRequired())));
    }

    private static boolean isWatchFeatureRequiredFromSnapshot(@NotNull AndroidFacet facet2) {
        MergedManifestSnapshot mergedManifest = MergedManifestManager.getSnapshot(facet2);
        Element feature = mergedManifest.findUsedFeature("android.hardware.type.watch");
        if (feature == null) {
            return false;
        }
        Attr requiredNode = feature.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "required");
        if (requiredNode == null) {
            return true;
        }
        return "true".equals(requiredNode.getValue());
    }

    public static void showNotification(final @NotNull Project project, final @NotNull Executor executor, final @NotNull String sessionName, final @NotNull String message2, final @NotNull NotificationType type, final @Nullable NotificationListener errorNotificationListener) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                String toolWindowId = executor.getToolWindowId();
                final ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(toolWindowId);
                if (toolWindow.isVisible() && errorNotificationListener == null) {
                    return;
                }
                final String link = "toolWindow_" + sessionName;
                String notificationMessage = String.format("Session <a href='%s'>'%s'</a>: %s", link, sessionName, message2);
                NotificationGroup group2 = this.getNotificationGroup(toolWindowId);
                group2.createNotification("", notificationMessage, type, new NotificationListener(){

                    public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                        boolean handled = false;
                        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && link.equals(event.getDescription())) {
                            for (RunContentDescriptor d : ExecutionManagerImpl.getAllDescriptors((Project)project)) {
                                if (!sessionName.equals(d.getDisplayName())) continue;
                                Content content2 = d.getAttachedContent();
                                if (content2 != null) {
                                    content2.getManager().setSelectedContent(content2);
                                }
                                toolWindow.activate(null, true, true);
                                handled = true;
                                break;
                            }
                        }
                        if (!handled && errorNotificationListener != null) {
                            errorNotificationListener.hyperlinkUpdate(notification, event);
                        }
                    }
                }).notify(project);
            }

            @NotNull
            private NotificationGroup getNotificationGroup(@NotNull String toolWindowId) {
                String displayId = "Launch Notifications for " + toolWindowId;
                NotificationGroup group2 = NotificationGroup.findRegisteredGroup((String)displayId);
                if (group2 == null) {
                    group2 = NotificationGroup.toolWindowGroup((String)displayId, (String)toolWindowId, (boolean)true, (PluginId)PluginId.getId((String)"org.jetbrains.android"));
                }
                return group2;
            }
        });
    }

    public static void initiateDismissKeyguard(final @NotNull IDevice device) {
        AndroidVersion canDismissKeyguard = new AndroidVersion(23, null);
        if (canDismissKeyguard.compareTo(device.getVersion()) <= 0) {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        device.executeShellCommand("wm dismiss-keyguard", (IShellOutputReceiver)new NullOutputReceiver(), 10L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        Logger.getInstance(LaunchUtils.class).warn("Unable to dismiss keyguard before launching activity");
                    }
                }
            });
        }
    }

    @Nullable
    public static Integer getUserIdFromFlags(@Nullable String flags) {
        if (flags == null) {
            return null;
        }
        Matcher m = idKeyPattern.matcher(flags);
        return m.find() ? Integer.valueOf(Integer.parseInt(m.group(1))) : null;
    }
}

