/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.ui;

import com.android.ddmlib.Client;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.deployable.Deployable;
import com.android.tools.idea.run.deployable.DeployableProvider;
import com.android.tools.idea.run.deployable.SwappableProcessHandler;
import com.android.tools.idea.run.util.SwapInfo;
import com.android.tools.idea.util.CommonAndroidUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.RemoteDebugProcessHandler;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.xdebugger.XDebugSession;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(BaseAction.class);
    public static final Key<Boolean> SHOW_APPLY_CHANGES_UI = Key.create((String)"android.deploy.ApplyChanges.ShowUI");
    @NotNull
    protected final String myName;
    @NotNull
    protected final Icon myIcon;
    @NotNull
    private final SwapInfo.SwapType mySwapType;
    @NotNull
    private final String myDescription;

    public BaseAction(@NotNull String id, @NotNull String name, @NotNull String acceleratorName, @NotNull SwapInfo.SwapType swapType, @NotNull Icon icon2, @NotNull Shortcut shortcut, @NotNull String description2) {
        super(acceleratorName, description2, icon2);
        this.myName = name;
        this.mySwapType = swapType;
        this.myIcon = icon2;
        this.myDescription = description2;
        KeymapManager manager = KeymapManager.getInstance();
        if (manager != null) {
            Shortcut[] uraShortcuts;
            Keymap keymap = manager.getActiveKeymap();
            List<Shortcut> shortcuts = Arrays.asList(keymap.getShortcuts(id));
            if (shortcuts.isEmpty()) {
                keymap.addShortcut(id, shortcut);
                shortcuts = Collections.singletonList(shortcut);
            }
            String updateRunningApplicationId = "UpdateRunningApplication";
            for (Shortcut uraShortcut : uraShortcuts = keymap.getShortcuts("UpdateRunningApplication")) {
                if (!shortcuts.contains(uraShortcut)) continue;
                keymap.removeShortcut("UpdateRunningApplication", uraShortcut);
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project == null || !CommonAndroidUtil.getInstance().isAndroidProject(project)) {
            presentation.setVisible(false);
            return;
        }
        DisableMessage disableMessage = BaseAction.getDisableMessage(project);
        if (disableMessage == null) {
            presentation.setVisible(true);
            presentation.setEnabled(true);
            presentation.setText(this.myName);
            presentation.setDescription(this.myDescription);
        } else {
            this.disableAction(presentation, disableMessage);
        }
    }

    @Nullable
    public static DisableMessage getDisableMessage(@NotNull Project project) {
        RunnerAndConfigurationSettings configSettings = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (configSettings == null) {
            return new DisableMessage(DisableMessage.DisableMode.DISABLED, "no configuration selected", "there is no configuration selected");
        }
        RunConfiguration selectedRunConfig = configSettings.getConfiguration();
        if (!BaseAction.isApplyChangesRelevant(selectedRunConfig)) {
            return new DisableMessage(DisableMessage.DisableMode.INVISIBLE, "unsupported configuration", "the selected configuration is not supported");
        }
        if (BaseAction.isExecutorStarting(project, selectedRunConfig)) {
            return new DisableMessage(DisableMessage.DisableMode.DISABLED, "building and/or launching", "the selected configuration is currently building and/or launching");
        }
        DeployableProvider deployableProvider = DeployableProvider.getInstance(project);
        if (deployableProvider == null) {
            return new DisableMessage(DisableMessage.DisableMode.DISABLED, "no deployment provider", "there is no deployment provider specified");
        }
        try {
            Deployable deployable = deployableProvider.getDeployable(selectedRunConfig);
            if (deployable == null) {
                return new DisableMessage(DisableMessage.DisableMode.DISABLED, "selected device is invalid", "the selected device is not valid");
            }
            if (!deployable.isOnline()) {
                if (deployable.isUnauthorized()) {
                    return new DisableMessage(DisableMessage.DisableMode.DISABLED, "device not authorized", "the selected device is not authorized");
                }
                return new DisableMessage(DisableMessage.DisableMode.DISABLED, "device not connected", "the selected device is not connected");
            }
            Future<AndroidVersion> versionFuture = deployable.getVersion();
            if (!versionFuture.isDone()) {
                return new DisableMessage(DisableMessage.DisableMode.DISABLED, "unknown device API level", "its API level is currently unknown");
            }
            if (versionFuture.get().getApiLevel() < 26) {
                return new DisableMessage(DisableMessage.DisableMode.DISABLED, "incompatible device API level", "its API level is lower than 26");
            }
            if (deployable.searchClientsForPackage().isEmpty()) {
                return new DisableMessage(DisableMessage.DisableMode.DISABLED, "app not detected", "the app is not yet running or not debuggable");
            }
        }
        catch (InterruptedException ex) {
            LOG.warn((Throwable)ex);
            return new DisableMessage(DisableMessage.DisableMode.DISABLED, "update interrupted", "its status update was interrupted");
        }
        catch (ExecutionException ex) {
            LOG.warn((Throwable)ex);
            return new DisableMessage(DisableMessage.DisableMode.DISABLED, "unknown device API level", "its API level could not be determined");
        }
        catch (Exception ex) {
            LOG.warn((Throwable)ex);
            return new DisableMessage(DisableMessage.DisableMode.DISABLED, "unexpected exception", "an unexpected exception was thrown: " + ex.toString());
        }
        return null;
    }

    private static boolean isApplyChangesRelevant(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration instanceof RunConfigurationBase) {
            RunConfigurationBase configBase = (RunConfigurationBase)runConfiguration;
            return (Boolean)configBase.putUserDataIfAbsent(SHOW_APPLY_CHANGES_UI, (Object)false);
        }
        return false;
    }

    private static boolean isExecutorStarting(@NotNull Project project, @NotNull RunConfiguration runConfiguration) {
        for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
            ProgramRunner programRunner = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)runConfiguration);
            if (programRunner == null || !ExecutionManager.getInstance((Project)project).isStarting(executor.getId(), programRunner.getRunnerId())) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Executor executor;
        Project project = e.getProject();
        if (project == null) {
            LOG.warn(this.myName + " action performed with no project");
            return;
        }
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (settings == null) {
            LOG.warn(this.myName + " action could not locate current run config settings");
            return;
        }
        ProcessHandler handler2 = BaseAction.findRunningProcessHandler(project, settings.getConfiguration());
        Executor executor2 = executor = handler2 == null ? DefaultRunExecutor.getRunExecutorInstance() : BaseAction.getExecutor(handler2, DefaultRunExecutor.getRunExecutorInstance());
        if (executor == null) {
            LOG.warn(this.myName + " action could not identify executor of existing running application");
            return;
        }
        ExecutionEnvironmentBuilder builder2 = ExecutionEnvironmentBuilder.create((Executor)executor, (RunConfiguration)settings.getConfiguration());
        ExecutionEnvironment env = builder2.activeTarget().dataContext(e.getDataContext()).build();
        env.putUserData(SwapInfo.SWAP_INFO_KEY, (Object)new SwapInfo(this.mySwapType, handler2));
        ProgramRunnerUtil.executeConfiguration((ExecutionEnvironment)env, (boolean)false, (boolean)true);
    }

    @Nullable
    protected static ProcessHandler findRunningProcessHandler(@NotNull Project project, @NotNull RunConfiguration runConfiguration) {
        Deployable deployable;
        for (ProcessHandler handler2 : ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            SwappableProcessHandler extension = (SwappableProcessHandler)handler2.getCopyableUserData(SwappableProcessHandler.EXTENSION_KEY);
            if (extension == null || !extension.isRunningWith(runConfiguration, ExecutionTargetManager.getActiveTarget((Project)project)) || !handler2.isStartNotified() || handler2.isProcessTerminating() || handler2.isProcessTerminated()) continue;
            return handler2;
        }
        DeployableProvider deployableProvider = DeployableProvider.getInstance(project);
        if (deployableProvider == null) {
            return null;
        }
        try {
            deployable = deployableProvider.getDeployable(runConfiguration);
            if (deployable == null) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        for (DebuggerSession session : DebuggerManagerEx.getInstanceEx((Project)project).getSessions()) {
            XDebugSession debugSession;
            String debuggerPort = session.getProcess().getConnection().getDebuggerAddress().trim();
            Client remoteDebuggedClient = deployable.searchClientsForPackage().stream().filter(client -> Integer.toString(client.getDebuggerListenPort()).equals(debuggerPort)).findAny().orElse(null);
            if (remoteDebuggedClient == null || (debugSession = session.getXDebugSession()) == null || debugSession.isStopped()) continue;
            return debugSession.getRunContentDescriptor().getProcessHandler();
        }
        return null;
    }

    @Nullable
    protected static Executor getExecutor(@NotNull ProcessHandler processHandler, @Nullable Executor defaultExecutor) {
        if (processHandler instanceof RemoteDebugProcessHandler) {
            return DefaultDebugExecutor.getDebugExecutorInstance();
        }
        SwappableProcessHandler extension = (SwappableProcessHandler)processHandler.getCopyableUserData(SwappableProcessHandler.EXTENSION_KEY);
        return processHandler.isProcessTerminated() || processHandler.isProcessTerminating() || extension == null ? defaultExecutor : extension.getExecutor();
    }

    protected void disableAction(@NotNull Presentation presentation, @NotNull DisableMessage disableMessage) {
        if (!presentation.isVisible()) {
            return;
        }
        presentation.setVisible(disableMessage.myDisableMode != DisableMessage.DisableMode.INVISIBLE);
        presentation.setEnabled(false);
        presentation.setText(String.format("%s (disabled: %s)", this.myName, disableMessage.myTooltip));
        presentation.setDescription(String.format("%s is disabled for this device because %s.", this.myName, disableMessage.myDescription));
    }

    public static final class DisableMessage {
        @NotNull
        private final DisableMode myDisableMode;
        @NotNull
        private final String myTooltip;
        @NotNull
        private final String myDescription;

        public DisableMessage(@NotNull DisableMode disableMode, @NotNull String tooltip, @NotNull String description2) {
            this.myDisableMode = disableMode;
            this.myTooltip = tooltip;
            this.myDescription = description2;
        }

        @NotNull
        public String getDescription() {
            return this.myDescription;
        }

        public static enum DisableMode {
            INVISIBLE,
            DISABLED;

        }
    }
}

