/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.activity.AndroidActivityLauncher;
import com.android.tools.idea.run.activity.StartActivityFlagsProvider;
import com.android.tools.idea.run.tasks.AppLaunchTask;
import com.android.tools.idea.run.tasks.LaunchContext;
import com.android.tools.idea.run.tasks.LaunchResult;
import com.android.tools.idea.run.tasks.ShellCommandLauncher;
import com.android.tools.idea.run.util.LaunchStatus;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActivityLaunchTask
extends AppLaunchTask {
    @VisibleForTesting
    static final String ACTIVITY_DOES_NOT_EXIST = "ACTIVITY_DOES_NOT_EXIST";
    @VisibleForTesting
    static final String UNABLE_TO_DETERMINE_LAUNCH_ACTIVITY = "UNABLE_TO_DETERMINE_LAUNCH_ACTIVITY";
    @VisibleForTesting
    static final String UNKNOWN_ACTIVITY_LAUNCH_TASK_ERROR = "UNKNOWN_ACTIVITY_LAUNCH_TASK_ERROR";
    @NotNull
    private final String myApplicationId;
    @NotNull
    private final StartActivityFlagsProvider myStartActivityFlagsProvider;

    public ActivityLaunchTask(@NotNull String applicationId2, @NotNull StartActivityFlagsProvider startActivityFlagsProvider) {
        this.myApplicationId = applicationId2;
        this.myStartActivityFlagsProvider = startActivityFlagsProvider;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Launching activity";
    }

    @Override
    public int getDuration() {
        return 2;
    }

    @Override
    public LaunchResult run(@NotNull LaunchContext launchContext) {
        LaunchStatus launchStatus = launchContext.getLaunchStatus();
        ConsolePrinter printer = launchContext.getConsolePrinter();
        IDevice device = launchContext.getDevice();
        String command = this.getStartActivityCommand(device, launchStatus, printer);
        if (command == null) {
            return LaunchResult.error(UNABLE_TO_DETERMINE_LAUNCH_ACTIVITY, this.getDescription());
        }
        ErrorAwarePrinterWrapper printerWrapper = new ErrorAwarePrinterWrapper(printer);
        boolean successful = this.executeShellCommand(command, device, launchStatus, printerWrapper, 15L, TimeUnit.SECONDS);
        if (printerWrapper.sawActivityDoesNotExistError()) {
            return LaunchResult.error(ACTIVITY_DOES_NOT_EXIST, this.getDescription());
        }
        return successful ? LaunchResult.success() : LaunchResult.error(UNKNOWN_ACTIVITY_LAUNCH_TASK_ERROR, this.getDescription());
    }

    protected boolean executeShellCommand(@NotNull String command, @NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer, long timeout, @NotNull TimeUnit timeoutUnit) {
        return ShellCommandLauncher.execute(command, device, launchStatus, printer, timeout, timeoutUnit);
    }

    @VisibleForTesting
    @Nullable
    public String getStartActivityCommand(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        String activityName = this.getQualifiedActivityName(device, printer);
        if (activityName == null) {
            return null;
        }
        String activityPath = AndroidActivityLauncher.getLauncherActivityPath(this.myApplicationId, activityName);
        return AndroidActivityLauncher.getStartActivityCommand(activityPath, this.myStartActivityFlagsProvider.getFlags(device));
    }

    @Nullable
    protected abstract String getQualifiedActivityName(@NotNull IDevice var1, @NotNull ConsolePrinter var2);

    private static class ErrorAwarePrinterWrapper
    implements ConsolePrinter {
        private static final String ACTIVITY_DOES_NOT_EXIST_REGEX = "Activity class \\{[^}]*} does not exist";
        private static final Pattern activityDoesNotExistPattern = Pattern.compile("Activity class \\{[^}]*} does not exist");
        private final ConsolePrinter delegate;
        private boolean sawActivityDoesNotExist;

        ErrorAwarePrinterWrapper(ConsolePrinter delegate2) {
            this.delegate = delegate2;
        }

        boolean sawActivityDoesNotExistError() {
            return this.sawActivityDoesNotExist;
        }

        @Override
        public void stdout(@NotNull String message2) {
            this.delegate.stdout(message2);
        }

        @Override
        public void stderr(@NotNull String message2) {
            this.delegate.stderr(message2);
            if (activityDoesNotExistPattern.matcher(message2).find()) {
                this.sawActivityDoesNotExist = true;
            }
        }
    }
}

