/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ProfilerState {
    public static final String ANDROID_PROFILER_STATE_ID = "android.profilers.state";
    public static final String ANDROID_ADVANCED_PROFILING_TRANSFORMS = "android.advanced.profiling.transforms";
    public static final int DEFAULT_NATIVE_MEMORY_SAMPLE_RATE_BYTES = 2048;
    public boolean ADVANCED_PROFILING_ENABLED = false;
    public static final String ENABLE_ADVANCED_PROFILING_NAME = "android.profiler.enabled";
    public boolean STARTUP_PROFILING_ENABLED = false;
    public static final String ENABLE_STARTUP_PROFILING_NAME = "android.profiler.startup.enabled";
    public boolean STARTUP_CPU_PROFILING_ENABLED = false;
    public String STARTUP_CPU_PROFILING_CONFIGURATION_NAME = CpuProfilerConfig.Technology.SAMPLED_JAVA.getName();
    public boolean STARTUP_NATIVE_MEMORY_PROFILING_ENABLED = false;
    public static final String STARTUP_MEMORY_PROFILING_NAME = "android.profiler.startup.native.memory.enabled";
    public int NATIVE_MEMORY_SAMPLE_RATE_BYTES = 2048;
    public static final String NATIVE_MEMORY_SAMPLE_RATE_NAME = "android.profiler.native.memory.rate";
    private boolean PROFILING_OKHTTP_ENABLED = true;
    public static final String ENABLE_ADVANCED_OKHTTP_PROFILING_NAME = "android.profiler.okhttp.enabled";
    public static final String ENABLE_UNIFIED_PIPELINE_NAME = "android.profiler.unifiedpipeline.enabled";
    private boolean myCheckAdvancedProfiling;

    public void readExternal(Element element2) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element2);
    }

    public void writeExternal(Element element2) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element2);
    }

    public boolean isCpuStartupProfilingEnabled() {
        return this.STARTUP_PROFILING_ENABLED && this.STARTUP_CPU_PROFILING_ENABLED;
    }

    public boolean isNativeMemoryStartupProfilingEnabled() {
        return this.STARTUP_PROFILING_ENABLED && this.STARTUP_NATIVE_MEMORY_PROFILING_ENABLED;
    }

    public Properties toProperties() {
        Properties result2 = new Properties();
        result2.setProperty(ENABLE_ADVANCED_PROFILING_NAME, String.valueOf(this.ADVANCED_PROFILING_ENABLED));
        result2.setProperty(ENABLE_STARTUP_PROFILING_NAME, String.valueOf(this.STARTUP_PROFILING_ENABLED));
        result2.setProperty(ENABLE_UNIFIED_PIPELINE_NAME, String.valueOf(StudioFlags.PROFILER_UNIFIED_PIPELINE.get()));
        result2.setProperty(ENABLE_ADVANCED_OKHTTP_PROFILING_NAME, String.valueOf(this.PROFILING_OKHTTP_ENABLED));
        result2.setProperty(STARTUP_MEMORY_PROFILING_NAME, String.valueOf(this.STARTUP_NATIVE_MEMORY_PROFILING_ENABLED));
        result2.setProperty(NATIVE_MEMORY_SAMPLE_RATE_NAME, String.valueOf(this.NATIVE_MEMORY_SAMPLE_RATE_BYTES));
        return result2;
    }

    public void setCheckAdvancedProfiling(boolean checkAdvancedProfiling) {
        this.myCheckAdvancedProfiling = checkAdvancedProfiling;
    }

    @NotNull
    public List<ValidationError> validate() {
        LinkedList<ValidationError> errors2 = new LinkedList<ValidationError>();
        if (this.myCheckAdvancedProfiling) {
            errors2.add(ValidationError.info("Check advanced profiling status", ValidationError.Category.PROFILER, null));
        }
        return errors2;
    }
}

