/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.ddmlib.Client;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidDebuggerImplBase<S extends AndroidDebuggerState>
implements AndroidDebugger<S> {
    @NotNull
    protected static String getClientDebugPort(@NotNull Client client) {
        return Integer.toString(client.getDebuggerListenPort()).trim();
    }

    @Nullable
    protected static DebuggerSession findJdwpDebuggerSession(@NotNull Project project, @NotNull String debugPort) {
        for (DebuggerSession session : DebuggerManagerEx.getInstanceEx((Project)project).getSessions()) {
            if (!debugPort.equals(session.getProcess().getConnection().getDebuggerAddress().trim())) continue;
            return session;
        }
        return null;
    }

    protected static boolean activateDebugSessionWindow(@NotNull Project project, @NotNull RunContentDescriptor descriptor2) {
        ProcessHandler processHandler = descriptor2.getProcessHandler();
        Content content2 = descriptor2.getAttachedContent();
        if (processHandler == null || content2 == null) {
            return false;
        }
        Executor executor = DefaultDebugExecutor.getDebugExecutorInstance();
        if (processHandler.isProcessTerminated()) {
            RunContentManager.getInstance((Project)project).removeRunContent(executor, descriptor2);
            return false;
        }
        content2.getManager().setSelectedContent(content2);
        ToolWindow window2 = ToolWindowManager.getInstance((Project)project).getToolWindow(executor.getToolWindowId());
        window2.activate(null, false, true);
        return true;
    }

    @Override
    public boolean shouldBeDefault() {
        return false;
    }

    @Override
    @NotNull
    public String getAmStartOptions(@NotNull S state, @NotNull Project project, @NotNull AndroidVersion version2) {
        return "";
    }
}

