/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.android.tools.idea.run.deployment.Devices;
import com.android.tools.idea.run.deployment.DevicesSelectedService;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.Snapshot;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import icons.StudioIcons;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Updater {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Presentation myPresentation;
    @NotNull
    private final String myPlace;
    @NotNull
    private final DevicesSelectedService myDevicesSelectedService;
    @NotNull
    private final List<Device> myDevices;
    @Nullable
    private final RunnerAndConfigurationSettings myConfigurationAndSettings;
    private final boolean mySnapshotsEnabled;

    private Updater(@NotNull Builder builder2) {
        assert (builder2.myProject != null);
        this.myProject = builder2.myProject;
        assert (builder2.myPresentation != null);
        this.myPresentation = builder2.myPresentation;
        this.myPlace = builder2.myPlace;
        assert (builder2.myDevicesSelectedService != null);
        this.myDevicesSelectedService = builder2.myDevicesSelectedService;
        this.myDevices = builder2.myDevices;
        this.myConfigurationAndSettings = builder2.myConfigurationAndSettings;
        this.mySnapshotsEnabled = builder2.mySnapshotsEnabled;
    }

    void update() {
        if (!AndroidUtils.hasAndroidFacets(this.myProject)) {
            this.myPresentation.setVisible(false);
            return;
        }
        this.myPresentation.setVisible(true);
        this.updateDependingOnConfiguration();
        switch (this.myPlace) {
            case "MainToolbar": 
            case "NavBarToolbar": {
                if (this.myDevicesSelectedService.isMultipleDevicesSelectedInComboBox()) {
                    this.updateInToolbarForMultipleDevices();
                    break;
                }
                this.updateInToolbarForSingleDevice();
                break;
            }
            default: {
                this.myPresentation.setIcon(null);
                this.myPresentation.setText("Select Device...");
            }
        }
    }

    private void updateDependingOnConfiguration() {
        if (this.myConfigurationAndSettings == null) {
            this.myPresentation.setEnabled(false);
            this.myPresentation.setDescription("Add a run/debug configuration");
            return;
        }
        RunConfiguration configuration = this.myConfigurationAndSettings.getConfiguration();
        if (configuration instanceof AndroidRunConfiguration || configuration instanceof AndroidTestRunConfiguration) {
            this.myPresentation.setEnabled(true);
            this.myPresentation.setDescription((String)null);
            return;
        }
        if (this.configurationDeploysToLocalDevice()) {
            this.myPresentation.setEnabled(true);
            this.myPresentation.setDescription((String)null);
            return;
        }
        this.myPresentation.setEnabled(false);
        this.myPresentation.setDescription("Not applicable for the \"" + configuration.getName() + "\" configuration");
    }

    private boolean configurationDeploysToLocalDevice() {
        assert (this.myConfigurationAndSettings != null);
        RunConfiguration configuration = this.myConfigurationAndSettings.getConfiguration();
        if (!(configuration instanceof UserDataHolder)) {
            return false;
        }
        Boolean deploysToLocalDevice = (Boolean)((UserDataHolder)configuration).getUserData(DeviceAndSnapshotComboBoxAction.DEPLOYS_TO_LOCAL_DEVICE);
        return deploysToLocalDevice != null && deploysToLocalDevice != false;
    }

    private void updateInToolbarForMultipleDevices() {
        Set keys;
        Set<Key> selectedKeys = this.myDevicesSelectedService.getDeviceKeysSelectedWithDialog();
        if (selectedKeys.retainAll(keys = this.myDevices.stream().map(Device::getKey).collect(Collectors.toSet()))) {
            this.myDevicesSelectedService.setDeviceKeysSelectedWithDialog(selectedKeys);
            if (selectedKeys.isEmpty()) {
                this.myDevicesSelectedService.setMultipleDevicesSelectedInComboBox(false);
                this.myDevicesSelectedService.setDeviceSelectedWithComboBox(this.myDevicesSelectedService.getDeviceSelectedWithComboBox(this.myDevices));
                this.updateInToolbarForSingleDevice();
                return;
            }
        }
        this.myPresentation.setIcon(StudioIcons.DeviceExplorer.MULTIPLE_DEVICES);
        this.myPresentation.setText("Multiple Devices (" + selectedKeys.size() + ")");
    }

    private void updateInToolbarForSingleDevice() {
        if (this.myDevices.isEmpty()) {
            this.myPresentation.setIcon(null);
            this.myPresentation.setText("No Devices");
            return;
        }
        Device device = this.myDevicesSelectedService.getDeviceSelectedWithComboBox(this.myDevices);
        assert (device != null);
        this.myPresentation.setIcon(device.getIcon());
        this.myPresentation.setText(this.getText(device), false);
    }

    @NotNull
    private String getText(@NotNull Device device) {
        Key key = Devices.containsAnotherDeviceWithSameName(this.myDevices, device) ? device.getKey() : null;
        Snapshot snapshot = this.mySnapshotsEnabled ? device.getSnapshot() : null;
        return Devices.getText(device, key, snapshot);
    }

    static final class Builder {
        @Nullable
        private Project myProject;
        @Nullable
        private Presentation myPresentation;
        @NotNull
        private String myPlace = "MainToolbar";
        @Nullable
        private DevicesSelectedService myDevicesSelectedService;
        @NotNull
        private List<Device> myDevices = Collections.emptyList();
        @Nullable
        private RunnerAndConfigurationSettings myConfigurationAndSettings;
        private boolean mySnapshotsEnabled;

        Builder() {
        }

        @NotNull
        Builder setProject(@NotNull Project project) {
            this.myProject = project;
            return this;
        }

        @NotNull
        Builder setPresentation(@NotNull Presentation presentation) {
            this.myPresentation = presentation;
            return this;
        }

        @NotNull
        Builder setPlace(@NotNull String place) {
            this.myPlace = place;
            return this;
        }

        @NotNull
        Builder setDevicesSelectedService(@NotNull DevicesSelectedService devicesSelectedService) {
            this.myDevicesSelectedService = devicesSelectedService;
            return this;
        }

        @NotNull
        Builder setDevices(@NotNull List<Device> devices2) {
            this.myDevices = devices2;
            return this;
        }

        @NotNull
        Builder setConfigurationAndSettings(@Nullable RunnerAndConfigurationSettings configurationAndSettings) {
            this.myConfigurationAndSettings = configurationAndSettings;
            return this;
        }

        @NotNull
        Builder setSnapshotsEnabled(boolean snapshotsEnabled) {
            this.mySnapshotsEnabled = snapshotsEnabled;
            return this;
        }

        @NotNull
        Updater build() {
            return new Updater(this);
        }
    }
}

