/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DevicesSelectedService;
import com.android.tools.idea.run.deployment.SelectMultipleDevicesDialogTable;
import com.android.tools.idea.run.deployment.SelectMultipleDevicesDialogTableModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.CommonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SelectMultipleDevicesDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    @NotNull
    private final BooleanSupplier myRunOnMultipleDevicesActionEnabledGet;
    @NotNull
    private final TableModel myTableModel;
    @NotNull
    private final Function<Project, DevicesSelectedService> myDevicesSelectedServiceGetInstance;
    @Nullable
    private SelectMultipleDevicesDialogTable myTable;

    SelectMultipleDevicesDialog(@NotNull Project project, @NotNull List<Device> devices2) {
        this(project, StudioFlags.RUN_ON_MULTIPLE_DEVICES_ACTION_ENABLED::get, new SelectMultipleDevicesDialogTableModel(devices2), DevicesSelectedService::getInstance);
    }

    @VisibleForTesting
    SelectMultipleDevicesDialog(@NotNull Project project, @NotNull BooleanSupplier runOnMultipleDevicesActionEnabledGet, @NotNull TableModel tableModel2, @NotNull Function<Project, DevicesSelectedService> devicesSelectedServiceGetInstance) {
        super(project);
        this.myProject = project;
        this.myRunOnMultipleDevicesActionEnabledGet = runOnMultipleDevicesActionEnabledGet;
        this.myTableModel = tableModel2;
        this.myDevicesSelectedServiceGetInstance = devicesSelectedServiceGetInstance;
        this.initTable();
        this.initOkAction();
        this.init();
        this.setTitle(runOnMultipleDevicesActionEnabledGet.getAsBoolean() ? "Run on Multiple Devices" : "Select Multiple Devices");
    }

    private void initTable() {
        if (this.myRunOnMultipleDevicesActionEnabledGet.getAsBoolean()) {
            this.myTableModel.addTableModelListener(event -> {
                if (event.getColumn() == 0 && event.getType() == 0) {
                    assert (this.myTable != null);
                    this.getOKAction().setEnabled(IntStream.range(0, this.myTable.getRowCount()).anyMatch(this.myTable::isSelected));
                }
            });
        }
        this.myTable = new SelectMultipleDevicesDialogTable();
        this.myTable.setModel(this.myTableModel);
        this.myTable.setSelectedDevices(this.myDevicesSelectedServiceGetInstance.apply(this.myProject).getDeviceKeysSelectedWithDialog());
    }

    private void initOkAction() {
        if (!this.myRunOnMultipleDevicesActionEnabledGet.getAsBoolean()) {
            this.myOKAction.setEnabled(true);
            this.myOKAction.putValue("Name", CommonBundle.getOkButtonText());
        }
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel();
        GroupLayout layout2 = new GroupLayout(panel2);
        JLabel label = new JLabel("Available devices");
        JBScrollPane scrollPane = new JBScrollPane((Component)((Object)this.myTable));
        scrollPane.setPreferredSize((Dimension)JBUI.size((int)556, (int)270));
        GroupLayout.ParallelGroup horizontalGroup = layout2.createParallelGroup().addComponent(label).addComponent((Component)scrollPane);
        GroupLayout.SequentialGroup verticalGroup = layout2.createSequentialGroup().addComponent(label).addComponent((Component)scrollPane);
        layout2.setAutoCreateGaps(true);
        layout2.setHorizontalGroup(horizontalGroup);
        layout2.setVerticalGroup(verticalGroup);
        panel2.setLayout(layout2);
        return panel2;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myOKAction.setEnabled(false);
        this.myOKAction.putValue("Name", "Run");
    }

    protected void doOKAction() {
        super.doOKAction();
        assert (this.myTable != null);
        this.myDevicesSelectedServiceGetInstance.apply(this.myProject).setDevicesSelectedWithDialog(this.myTable.getSelectedDevices());
    }

    @VisibleForTesting
    @NotNull
    protected Action getOKAction() {
        return super.getOKAction();
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "com.android.tools.idea.run.deployment.SelectMultipleDevicesDialog";
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.getTable();
    }

    @VisibleForTesting
    @NotNull
    SelectMultipleDevicesDialogTable getTable() {
        assert (this.myTable != null);
        return this.myTable;
    }
}

