/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.android.tools.idea.run.deployment.Devices;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.Snapshot;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SelectDeviceAction
extends AnAction {
    @NotNull
    private final Device myDevice;
    @NotNull
    private final DeviceAndSnapshotComboBoxAction myComboBoxAction;
    private final boolean mySnapshotActionGroupChild;

    @NotNull
    static AnAction newSelectDeviceAction(@NotNull Device device, @NotNull DeviceAndSnapshotComboBoxAction comboBoxAction) {
        return new SelectDeviceAction(device, comboBoxAction, false);
    }

    @NotNull
    static AnAction newSnapshotActionGroupChild(@NotNull Device device, @NotNull DeviceAndSnapshotComboBoxAction comboBoxAction) {
        return new SelectDeviceAction(device, comboBoxAction, true);
    }

    private SelectDeviceAction(@NotNull Device device, @NotNull DeviceAndSnapshotComboBoxAction comboBoxAction, boolean snapshotActionGroupChild) {
        this.myDevice = device;
        this.mySnapshotActionGroupChild = snapshotActionGroupChild;
        this.myComboBoxAction = comboBoxAction;
    }

    @NotNull
    @VisibleForTesting
    public Device getDevice() {
        return this.myDevice;
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        if (this.mySnapshotActionGroupChild) {
            Snapshot snapshot = this.myDevice.getSnapshot();
            presentation.setText(snapshot == null ? "No Snapshot" : snapshot.toString(), false);
            return;
        }
        presentation.setIcon(this.myDevice.getIcon());
        Collection devices2 = this.myComboBoxAction.getDevices(Objects.requireNonNull(event.getProject())).orElseThrow(AssertionError::new);
        Key key = Devices.containsAnotherDeviceWithSameName(devices2, this.myDevice) ? this.myDevice.getKey() : null;
        Snapshot snapshot = this.myComboBoxAction.areSnapshotsEnabled() ? this.myDevice.getSnapshot() : null;
        presentation.setText(Devices.getText(this.myDevice, key, snapshot), false);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        this.myComboBoxAction.setSelectedDevice(Objects.requireNonNull(event.getProject()), this.myDevice);
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof SelectDeviceAction)) {
            return false;
        }
        SelectDeviceAction action2 = (SelectDeviceAction)((Object)object);
        return this.myDevice.equals(action2.myDevice) && ((Object)((Object)this.myComboBoxAction)).equals((Object)action2.myComboBoxAction) && this.mySnapshotActionGroupChild == action2.mySnapshotActionGroupChild;
    }

    public int hashCode() {
        int hashCode = this.myDevice.hashCode();
        hashCode = 31 * hashCode + ((Object)((Object)this.myComboBoxAction)).hashCode();
        hashCode = 31 * hashCode + Boolean.hashCode(this.mySnapshotActionGroupChild);
        return hashCode;
    }
}

