/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.android.tools.idea.run.deployment.SelectDeviceAction;
import com.android.tools.idea.run.deployment.SnapshotActionGroup;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collector;
import org.jetbrains.annotations.NotNull;

final class PopupActionGroup
extends DefaultActionGroup {
    @NotNull
    private final Collection<Device> myDevices;
    @NotNull
    private final DeviceAndSnapshotComboBoxAction myComboBoxAction;

    PopupActionGroup(@NotNull Collection<Device> devices2, @NotNull DeviceAndSnapshotComboBoxAction comboBoxAction) {
        this(devices2, comboBoxAction, StudioFlags.RUN_ON_MULTIPLE_DEVICES_ACTION_ENABLED::get);
    }

    @VisibleForTesting
    PopupActionGroup(@NotNull Collection<Device> devices2, @NotNull DeviceAndSnapshotComboBoxAction comboBoxAction, @NotNull BooleanSupplier runOnMultipleDevicesActionEnabledGet) {
        this.myDevices = devices2;
        this.myComboBoxAction = comboBoxAction;
        Collection<AnAction> actions2 = comboBoxAction.areSnapshotsEnabled() ? this.newSelectDeviceActionsOrSnapshotActionGroups() : this.newSelectDeviceActions();
        this.addAll(actions2);
        if (!actions2.isEmpty()) {
            this.addSeparator();
        }
        ActionManager manager = ActionManager.getInstance();
        String id = runOnMultipleDevicesActionEnabledGet.getAsBoolean() ? "RunOnMultipleDevices" : "SelectMultipleDevices";
        this.add(manager.getAction(id));
        this.add(manager.getAction("Android.AdbDevicePairing"));
        this.add(manager.getAction("Android.RunAndroidAvdManager"));
        AnAction action2 = manager.getAction("DeveloperServices.ConnectionAssistant");
        if (action2 == null) {
            return;
        }
        this.addSeparator();
        this.add(action2);
    }

    @NotNull
    private Collection<AnAction> newSelectDeviceActionsOrSnapshotActionGroups() {
        Collector collector = Multimaps.toMultimap(device -> device.getKey().getDeviceKey(), device -> device, this::buildListMultimap);
        ListMultimap multimap = (ListMultimap)this.myDevices.stream().collect(collector);
        Set deviceKeys = multimap.keySet();
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>(1 + deviceKeys.size());
        if (!deviceKeys.isEmpty()) {
            actions2.add(ActionManager.getInstance().getAction("AvailableDevices"));
        }
        deviceKeys.stream().map(arg_0 -> ((ListMultimap)multimap).get(arg_0)).map(this::newSelectDeviceActionOrSnapshotActionGroup).forEach(actions2::add);
        return actions2;
    }

    @NotNull
    private ListMultimap<String, Device> buildListMultimap() {
        return MultimapBuilder.hashKeys((int)this.myDevices.size()).arrayListValues().build();
    }

    @NotNull
    private AnAction newSelectDeviceActionOrSnapshotActionGroup(@NotNull List<Device> devices2) {
        return devices2.size() == 1 ? this.newSelectDeviceAction(devices2.get(0)) : new SnapshotActionGroup(devices2);
    }

    @NotNull
    private Collection<AnAction> newSelectDeviceActions() {
        boolean availableDevicesPresent;
        List runningDevices = ContainerUtil.filter(this.myDevices, Device::isConnected);
        List availableDevices = ContainerUtil.filter(this.myDevices, device -> !device.isConnected());
        boolean runningDevicesPresent = !runningDevices.isEmpty();
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>(1 + runningDevices.size() + 2 + availableDevices.size());
        ActionManager manager = ActionManager.getInstance();
        if (runningDevicesPresent) {
            actions2.add(manager.getAction("RunningDevices"));
        }
        runningDevices.stream().map(this::newSelectDeviceAction).forEach(actions2::add);
        boolean bl = availableDevicesPresent = !availableDevices.isEmpty();
        if (runningDevicesPresent && availableDevicesPresent) {
            actions2.add((AnAction)Separator.create());
        }
        if (availableDevicesPresent) {
            actions2.add(manager.getAction("AvailableDevices"));
        }
        availableDevices.stream().map(this::newSelectDeviceAction).forEach(actions2::add);
        return actions2;
    }

    @NotNull
    private AnAction newSelectDeviceAction(@NotNull Device device) {
        return SelectDeviceAction.newSelectDeviceAction(device, this.myComboBoxAction);
    }
}

