/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.CellRenderer;
import com.android.tools.idea.run.deployment.Heading;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.list.ListPopupImpl;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JList;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;

final class Popup
extends PopupFactoryImpl.ActionGroupPopup {
    Popup(@NotNull ActionGroup group2, @NotNull DataContext context, @NotNull Runnable runnable2) {
        super(null, group2, context, false, true, true, false, runnable2, 30, null, null, true);
        this.setMinimumSize(new Dimension(1, 1));
        JList list = this.getList();
        list.setCellRenderer(new CellRenderer((ListPopupImpl)this));
        list.setName("deviceAndSnapshotComboBoxList");
        ActionMap map2 = list.getActionMap();
        map2.put("selectNextRow", new SelectNextRow(list));
        map2.put("selectPreviousRow", new SelectPreviousRow(list));
    }

    private static abstract class SelectRow
    extends AbstractAction {
        @NotNull
        final JList<PopupFactoryImpl.ActionItem> myList;

        private SelectRow(@NotNull JList<PopupFactoryImpl.ActionItem> list) {
            this.myList = list;
        }

        @Override
        public final void actionPerformed(@NotNull ActionEvent event) {
            ListModel<PopupFactoryImpl.ActionItem> model2 = this.myList.getModel();
            OptionalInt optionalIndex = this.indexStream().filter(index2 -> !(((PopupFactoryImpl.ActionItem)model2.getElementAt(index2)).getAction() instanceof Heading)).findFirst();
            optionalIndex.ifPresent(index2 -> this.myList.getSelectionModel().setSelectionInterval(index2, index2));
        }

        @NotNull
        abstract IntStream indexStream();
    }

    private static final class SelectPreviousRow
    extends SelectRow {
        private SelectPreviousRow(@NotNull JList<PopupFactoryImpl.ActionItem> list) {
            super(list);
        }

        @Override
        @NotNull
        IntStream indexStream() {
            int leadSelectionIndex = this.myList.getLeadSelectionIndex();
            if (UISettings.getInstance().getCycleScrolling()) {
                return IntStream.iterate(this.previousIndex(leadSelectionIndex), this::previousIndex);
            }
            return IntStream.range(0, leadSelectionIndex).map(index2 -> leadSelectionIndex - index2 - 1);
        }

        private int previousIndex(int currentIndex) {
            int previousIndex = currentIndex - 1;
            return previousIndex == -1 ? this.myList.getModel().getSize() - 1 : previousIndex;
        }
    }

    private static final class SelectNextRow
    extends SelectRow {
        private SelectNextRow(@NotNull JList<PopupFactoryImpl.ActionItem> list) {
            super(list);
        }

        @Override
        @NotNull
        IntStream indexStream() {
            if (UISettings.getInstance().getCycleScrolling()) {
                return IntStream.iterate(this.nextIndex(this.myList.getLeadSelectionIndex()), this::nextIndex);
            }
            return IntStream.range(this.myList.getLeadSelectionIndex() + 1, this.myList.getModel().getSize());
        }

        private int nextIndex(int currentIndex) {
            int nextIndex = currentIndex + 1;
            return nextIndex == this.myList.getModel().getSize() ? 0 : nextIndex;
        }
    }
}

