/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.ddms.DeviceNamePropertiesFetcher;
import com.android.tools.idea.ddms.DeviceNamePropertiesProvider;
import com.android.tools.idea.run.deployment.ConnectedDevice;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

final class NameGetter
implements Function<ConnectedDevice, String> {
    @NotNull
    private final DeviceNamePropertiesProvider myProvider;

    NameGetter(@NotNull Disposable parent) {
        this.myProvider = new DeviceNamePropertiesFetcher(parent);
    }

    @Override
    @NotNull
    public String apply(@NotNull ConnectedDevice device) {
        assert (device.isPhysicalDevice());
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return "Physical Device";
        }
        return NameGetter.getName(this.myProvider.get(Objects.requireNonNull(device.getDdmlibDevice())));
    }

    @NotNull
    @VisibleForTesting
    static String getName(@NotNull DeviceNameProperties properties2) {
        String manufacturer = properties2.getManufacturer();
        String model2 = properties2.getModel();
        if (manufacturer == null && model2 == null) {
            return "Physical Device";
        }
        if (manufacturer == null) {
            return model2;
        }
        if (model2 == null) {
            return manufacturer + " Device";
        }
        return manufacturer + ' ' + model2;
    }
}

