/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.NonprefixedKey;
import com.android.tools.idea.run.deployment.SerialNumber;
import com.android.tools.idea.run.deployment.VirtualDeviceName;
import com.android.tools.idea.run.deployment.VirtualDevicePath;
import org.jetbrains.annotations.NotNull;

public abstract class Key
implements Comparable<Key> {
    @NotNull
    static Key newKey(@NotNull String string) {
        if (string.startsWith("VirtualDevicePath@")) {
            return new VirtualDevicePath(string.substring("VirtualDevicePath@".length()));
        }
        if (string.startsWith("VirtualDeviceName@")) {
            return new VirtualDeviceName(string.substring("VirtualDeviceName@".length()));
        }
        if (string.startsWith("SerialNumber@")) {
            return new SerialNumber(string.substring("SerialNumber@".length()));
        }
        return new NonprefixedKey(string);
    }

    boolean matches(@NotNull Key key) {
        return key instanceof NonprefixedKey ? this.asNonprefixedKey().equals(key) : this.equals(key);
    }

    @NotNull
    abstract NonprefixedKey asNonprefixedKey();

    @NotNull
    abstract String getDeviceKey();

    @Override
    public final int compareTo(@NotNull Key key) {
        return this.toString().compareTo(key.toString());
    }
}

