/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Key;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.containers.ContainerUtil;
import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DevicesSelectedService {
    @VisibleForTesting
    static final String DEVICE_KEY_SELECTED_WITH_COMBO_BOX = "DeviceAndSnapshotComboBoxAction.selectedDevice";
    @VisibleForTesting
    static final String TIME_DEVICE_KEY_WAS_SELECTED_WITH_COMBO_BOX = "DeviceAndSnapshotComboBoxAction.selectionTime";
    @VisibleForTesting
    static final String MULTIPLE_DEVICES_SELECTED_IN_COMBO_BOX = "DeviceAndSnapshotComboBoxAction.multipleDevicesSelected";
    @VisibleForTesting
    static final String DEVICE_KEYS_SELECTED_WITH_DIALOG = "SelectDeploymentTargetsDialog.selectedDevices";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Function<Project, PropertiesComponent> myPropertiesComponentGetInstance;
    @NotNull
    private final Clock myClock;
    @NotNull
    private final BooleanSupplier myRunOnMultipleDevicesActionEnabledGet;

    private DevicesSelectedService(@NotNull Project project) {
        this(project, PropertiesComponent::getInstance, Clock.systemDefaultZone(), StudioFlags.RUN_ON_MULTIPLE_DEVICES_ACTION_ENABLED::get);
    }

    @NonInjectable
    @VisibleForTesting
    DevicesSelectedService(@NotNull Project project, @NotNull Function<Project, PropertiesComponent> propertiesComponentGetInstance, @NotNull Clock clock, @NotNull BooleanSupplier runOnMultipleDevicesActionEnabledGet) {
        this.myProject = project;
        this.myPropertiesComponentGetInstance = propertiesComponentGetInstance;
        this.myClock = clock;
        this.myRunOnMultipleDevicesActionEnabledGet = runOnMultipleDevicesActionEnabledGet;
    }

    @NotNull
    static DevicesSelectedService getInstance(@NotNull Project project) {
        return (DevicesSelectedService)project.getService(DevicesSelectedService.class);
    }

    @Nullable
    Device getDeviceSelectedWithComboBox(@NotNull List<Device> devices2) {
        if (devices2.isEmpty()) {
            return null;
        }
        String keyAsString = this.myPropertiesComponentGetInstance.apply(this.myProject).getValue(DEVICE_KEY_SELECTED_WITH_COMBO_BOX);
        if (keyAsString == null) {
            return devices2.get(0);
        }
        Key key = Key.newKey(keyAsString);
        Optional<Device> optionalSelectedDevice = devices2.stream().filter(device -> device.matches(key)).findFirst();
        if (!optionalSelectedDevice.isPresent()) {
            return devices2.get(0);
        }
        Device selectedDevice = optionalSelectedDevice.get();
        Optional<Device> optionalConnectedDevice = devices2.stream().filter(Device::isConnected).findFirst();
        if (!optionalConnectedDevice.isPresent()) {
            return selectedDevice;
        }
        Device connectedDevice = optionalConnectedDevice.get();
        Instant connectionTime = connectedDevice.getConnectionTime();
        assert (connectionTime != null) : "connected device \"" + connectedDevice + "\" has a null connection time";
        if (this.getTimeDeviceWasSelectedWithComboBox(selectedDevice).isBefore(connectionTime)) {
            return connectedDevice;
        }
        return selectedDevice;
    }

    @NotNull
    private Instant getTimeDeviceWasSelectedWithComboBox(@NotNull Device device) {
        String time2 = this.myPropertiesComponentGetInstance.apply(this.myProject).getValue(TIME_DEVICE_KEY_WAS_SELECTED_WITH_COMBO_BOX);
        if (time2 == null) {
            Logger.getInstance(DevicesSelectedService.class).warn("selected device \"" + device + "\" has a null selection time string");
            return Instant.MIN;
        }
        return Instant.parse(time2);
    }

    void setDeviceSelectedWithComboBox(@Nullable Device deviceSelectedWithComboBox) {
        PropertiesComponent properties2 = this.myPropertiesComponentGetInstance.apply(this.myProject);
        properties2.unsetValue(MULTIPLE_DEVICES_SELECTED_IN_COMBO_BOX);
        if (deviceSelectedWithComboBox == null) {
            properties2.unsetValue(TIME_DEVICE_KEY_WAS_SELECTED_WITH_COMBO_BOX);
            properties2.unsetValue(DEVICE_KEY_SELECTED_WITH_COMBO_BOX);
        } else {
            properties2.setValue(DEVICE_KEY_SELECTED_WITH_COMBO_BOX, deviceSelectedWithComboBox.getKey().toString());
            properties2.setValue(TIME_DEVICE_KEY_WAS_SELECTED_WITH_COMBO_BOX, this.myClock.instant().toString());
        }
    }

    boolean isMultipleDevicesSelectedInComboBox() {
        return !this.myRunOnMultipleDevicesActionEnabledGet.getAsBoolean() && this.myPropertiesComponentGetInstance.apply(this.myProject).getBoolean(MULTIPLE_DEVICES_SELECTED_IN_COMBO_BOX);
    }

    void setMultipleDevicesSelectedInComboBox(boolean multipleDevicesSelectedInComboBox) {
        PropertiesComponent properties2 = this.myPropertiesComponentGetInstance.apply(this.myProject);
        properties2.unsetValue(TIME_DEVICE_KEY_WAS_SELECTED_WITH_COMBO_BOX);
        properties2.unsetValue(DEVICE_KEY_SELECTED_WITH_COMBO_BOX);
        if (!multipleDevicesSelectedInComboBox) {
            properties2.unsetValue(MULTIPLE_DEVICES_SELECTED_IN_COMBO_BOX);
        } else {
            properties2.setValue(MULTIPLE_DEVICES_SELECTED_IN_COMBO_BOX, true);
        }
    }

    boolean isDialogSelectionEmpty() {
        return !this.myPropertiesComponentGetInstance.apply(this.myProject).isValueSet(DEVICE_KEYS_SELECTED_WITH_DIALOG);
    }

    @NotNull
    List<Device> getDevicesSelectedWithDialog(@NotNull List<Device> devices2) {
        Set<Key> keys = this.getDeviceKeysSelectedWithDialog();
        return ContainerUtil.filter(devices2, device -> device.hasKeyContainedBy(keys));
    }

    void setDevicesSelectedWithDialog(@NotNull List<Device> devicesSelectedWithDialog) {
        this.setDeviceKeysSelectedWithDialog(devicesSelectedWithDialog.stream().map(Device::getKey));
    }

    @NotNull
    Set<Key> getDeviceKeysSelectedWithDialog() {
        Object[] keys = this.myPropertiesComponentGetInstance.apply(this.myProject).getValues(DEVICE_KEYS_SELECTED_WITH_DIALOG);
        if (keys == null) {
            return Collections.emptySet();
        }
        assert (!Arrays.asList(keys).contains("")) : Arrays.toString(keys);
        return Arrays.stream(keys).map(Key::newKey).collect(Collectors.toSet());
    }

    void setDeviceKeysSelectedWithDialog(@NotNull Set<Key> deviceKeysSelectedWithDialog) {
        this.setDeviceKeysSelectedWithDialog(deviceKeysSelectedWithDialog.stream());
    }

    private void setDeviceKeysSelectedWithDialog(@NotNull Stream<Key> stream) {
        String[] array = (String[])stream.map(Object::toString).toArray(String[]::new);
        PropertiesComponent properties2 = this.myPropertiesComponentGetInstance.apply(this.myProject);
        if (array.length == 0) {
            properties2.unsetValue(DEVICE_KEYS_SELECTED_WITH_DIALOG);
        } else {
            properties2.setValues(DEVICE_KEYS_SELECTED_WITH_DIALOG, array);
        }
    }
}

