/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.Snapshot;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Devices {
    private Devices() {
    }

    static boolean containsAnotherDeviceWithSameName(@NotNull Collection<Device> devices2, @NotNull Device device) {
        String key = device.getKey().getDeviceKey();
        String name = device.getName();
        return devices2.stream().filter(d -> !d.getKey().getDeviceKey().equals(key)).map(Device::getName).anyMatch(name::equals);
    }

    @NotNull
    static String getText(@NotNull Device device, @Nullable Key key, @Nullable Snapshot snapshot) {
        String snapshotName = snapshot == null ? null : snapshot.toString();
        return Devices.getText(device.getName(), key == null ? null : key.getDeviceKey(), snapshotName, device.getValidityReason());
    }

    @NotNull
    static String getText(@NotNull String device, @Nullable String reason) {
        return Devices.getText(device, null, null, reason);
    }

    @NotNull
    private static String getText(@NotNull String device, @Nullable String key, @Nullable String snapshot, @Nullable String reason) {
        StringBuilder builder2 = new StringBuilder(device);
        if (key != null) {
            builder2.append(" [").append(key).append(']');
        }
        if (snapshot != null) {
            builder2.append(" - ").append(snapshot);
        }
        if (reason != null) {
            builder2.append(" (").append(reason).append(')');
        }
        return builder2.toString();
    }
}

