/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.deployment.AndroidExecutionTarget;
import com.android.tools.idea.run.deployment.AsyncDevicesGetter;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Key;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.util.containers.ContainerUtil;
import icons.StudioIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

final class DeviceAndSnapshotComboBoxExecutionTarget
extends AndroidExecutionTarget {
    @NotNull
    private final @NotNull Collection<@NotNull Key> myKeys;
    @NotNull
    private final AsyncDevicesGetter myDevicesGetter;

    DeviceAndSnapshotComboBoxExecutionTarget(@NotNull @NotNull Set<@NotNull Key> keys, @NotNull AsyncDevicesGetter devicesGetter) {
        this.myKeys = keys;
        this.myDevicesGetter = devicesGetter;
    }

    @Override
    public boolean isApplicationRunning(@NotNull String appPackage) {
        return this.deviceStream().anyMatch(device -> device.isRunning(appPackage));
    }

    @Override
    public int getAvailableDeviceCount() {
        return (int)this.deviceStream().count();
    }

    @Override
    @NotNull
    public Collection<IDevice> getRunningDevices() {
        return this.deviceStream().map(Device::getDdmlibDevice).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    private @NotNull Stream<@NotNull Device> deviceStream() {
        return this.myDevicesGetter.get().map(this::filteredStream).orElseGet(Stream::empty);
    }

    @NotNull
    private @NotNull Stream<@NotNull Device> filteredStream(@NotNull @NotNull Collection<@NotNull Device> devices2) {
        return devices2.stream().filter(device -> device.hasKeyContainedBy(this.myKeys));
    }

    @NotNull
    public String getId() {
        return this.myKeys.stream().sorted().map(Object::toString).collect(Collectors.joining(", ", "device_and_snapshot_combo_box_target[", "]"));
    }

    @NotNull
    public String getDisplayName() {
        List<Device> devices2 = this.getDeploymentDevices();
        switch (devices2.size()) {
            case 0: {
                return "No Devices";
            }
            case 1: {
                return devices2.get(0).getName();
            }
        }
        return "Multiple Devices";
    }

    @NotNull
    public Icon getIcon() {
        List<Device> devices2 = this.getDeploymentDevices();
        if (devices2.size() == 1) {
            return devices2.get(0).getIcon();
        }
        return StudioIcons.DeviceExplorer.MULTIPLE_DEVICES;
    }

    @NotNull
    private @NotNull List<@NotNull Device> getDeploymentDevices() {
        return this.myDevicesGetter.get().map(this::filteredList).orElseGet(Collections::emptyList);
    }

    @NotNull
    private @NotNull List<@NotNull Device> filteredList(@NotNull @NotNull Collection<@NotNull Device> devices2) {
        return ContainerUtil.filter(devices2, device -> device.hasKeyContainedBy(this.myKeys));
    }

    public boolean canRun(@NotNull RunConfiguration configuration) {
        return true;
    }
}

