/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.deployable.Deployable;
import com.android.tools.idea.run.deployable.DeployableProvider;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.intellij.execution.configurations.RunConfiguration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceAndSnapshotComboBoxDeployableProvider
implements DeployableProvider {
    @Override
    @Nullable
    public Deployable getDeployable(@NotNull RunConfiguration runConfiguration) throws ApkProvisionException {
        if (!(runConfiguration instanceof AndroidRunConfigurationBase)) {
            return null;
        }
        AndroidRunConfigurationBase androidRunConfiguration = (AndroidRunConfigurationBase)runConfiguration;
        List<Device> devices2 = DeviceAndSnapshotComboBoxAction.getInstance().getSelectedDevices(androidRunConfiguration.getProject());
        if (devices2.size() != 1) {
            return null;
        }
        ApplicationIdProvider applicationIdProvider = androidRunConfiguration.getApplicationIdProvider();
        if (applicationIdProvider == null) {
            return null;
        }
        return new DeployableDevice(devices2.get(0), applicationIdProvider.getPackageName());
    }

    private static final class DeployableDevice
    implements Deployable {
        @NotNull
        private final Device myDevice;
        @NotNull
        private final String myPackageName;

        private DeployableDevice(@NotNull Device device, @NotNull String packageName) {
            this.myDevice = device;
            this.myPackageName = packageName;
        }

        @Override
        @NotNull
        public Future<AndroidVersion> getVersion() {
            return this.myDevice.getAndroidVersion();
        }

        @Override
        @NotNull
        public List<Client> searchClientsForPackage() {
            IDevice iDevice = this.myDevice.getDdmlibDevice();
            if (iDevice == null) {
                return Collections.emptyList();
            }
            return Deployable.searchClientsForPackage(iDevice, this.myPackageName);
        }

        @Override
        public boolean isOnline() {
            IDevice iDevice = this.myDevice.getDdmlibDevice();
            if (iDevice == null) {
                return false;
            }
            return iDevice.isOnline();
        }

        @Override
        public boolean isUnauthorized() {
            IDevice iDevice = this.myDevice.getDdmlibDevice();
            if (iDevice == null) {
                return false;
            }
            return iDevice.getState() == IDevice.DeviceState.UNAUTHORIZED;
        }
    }
}

