/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.deployable.Deployable;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.Snapshot;
import com.intellij.openapi.project.Project;
import java.time.Instant;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Device {
    @NotNull
    private final String myName;
    private final boolean myValid;
    @Nullable
    private final String myValidityReason;
    @NotNull
    private final Key myKey;
    @Nullable
    private final Instant myConnectionTime;
    @NotNull
    private final AndroidDevice myAndroidDevice;

    Device(@NotNull Builder builder2) {
        assert (builder2.myName != null);
        this.myName = builder2.myName;
        this.myValid = builder2.myValid;
        this.myValidityReason = builder2.myValidityReason;
        assert (builder2.myKey != null);
        this.myKey = builder2.myKey;
        this.myConnectionTime = builder2.myConnectionTime;
        assert (builder2.myAndroidDevice != null);
        this.myAndroidDevice = builder2.myAndroidDevice;
    }

    @NotNull
    abstract Icon getIcon();

    abstract boolean isConnected();

    @NotNull
    public final String getName() {
        return this.myName;
    }

    final boolean isValid() {
        return this.myValid;
    }

    @Nullable
    final String getValidityReason() {
        return this.myValidityReason;
    }

    @Nullable
    abstract Snapshot getSnapshot();

    @NotNull
    public final Key getKey() {
        return this.myKey;
    }

    abstract boolean matches(@NotNull Key var1);

    abstract boolean hasKeyContainedBy(@NotNull @NotNull Collection<@NotNull Key> var1);

    @Nullable
    final Instant getConnectionTime() {
        return this.myConnectionTime;
    }

    @NotNull
    final AndroidDevice getAndroidDevice() {
        return this.myAndroidDevice;
    }

    @NotNull
    abstract Future<AndroidVersion> getAndroidVersion();

    final boolean isRunning(@NotNull String appPackage) {
        if (!this.isConnected()) {
            return false;
        }
        IDevice device = this.getDdmlibDevice();
        assert (device != null);
        if (!device.isOnline()) {
            return false;
        }
        return !Deployable.searchClientsForPackage(device, appPackage).isEmpty();
    }

    @Nullable
    final IDevice getDdmlibDevice() {
        AndroidDevice device = this.getAndroidDevice();
        if (!device.isRunning()) {
            return null;
        }
        try {
            return (IDevice)device.getLaunchedDevice().get();
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    abstract void addTo(@NotNull DeviceFutures var1, @NotNull Project var2);

    @NotNull
    public final String toString() {
        return this.myName;
    }

    static abstract class Builder {
        @Nullable
        String myName;
        boolean myValid = true;
        @Nullable
        String myValidityReason;
        @Nullable
        Key myKey;
        @Nullable
        Instant myConnectionTime;
        @Nullable
        AndroidDevice myAndroidDevice;

        Builder() {
        }

        @NotNull
        abstract Device build();
    }
}

