/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.LaunchCompatibilityCheckerImpl;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.android.tools.idea.run.deployment.ConnectedDevice;
import com.android.tools.idea.run.deployment.ConnectedDevicesTask;
import com.android.tools.idea.run.deployment.DdmlibAndroidDebugBridge;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.KeyToConnectionTimeMap;
import com.android.tools.idea.run.deployment.NameGetter;
import com.android.tools.idea.run.deployment.PhysicalDevice;
import com.android.tools.idea.run.deployment.VirtualDevice;
import com.android.tools.idea.run.deployment.VirtualDevicesTask;
import com.android.tools.idea.run.deployment.Worker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Streams;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.nio.file.FileSystems;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AsyncDevicesGetter
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final BooleanSupplier mySelectDeviceSnapshotComboBoxSnapshotsEnabled;
    @NotNull
    private final Worker<Collection<VirtualDevice>> myVirtualDevicesWorker;
    @NotNull
    private final Worker<List<ConnectedDevice>> myConnectedDevicesWorker;
    @NotNull
    private final KeyToConnectionTimeMap myMap;
    @NotNull
    private final Function<ConnectedDevice, String> myGetName;
    @Nullable
    private LaunchCompatibilityChecker myChecker;

    private AsyncDevicesGetter(@NotNull Project project) {
        this.myProject = project;
        this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled = StudioFlags.SELECT_DEVICE_SNAPSHOT_COMBO_BOX_SNAPSHOTS_ENABLED::get;
        this.myVirtualDevicesWorker = new Worker();
        this.myConnectedDevicesWorker = new Worker();
        this.myMap = new KeyToConnectionTimeMap();
        this.myGetName = new NameGetter(this);
    }

    @NonInjectable
    @VisibleForTesting
    AsyncDevicesGetter(@NotNull Project project, @NotNull BooleanSupplier selectDeviceSnapshotComboBoxSnapshotsEnabled, @NotNull KeyToConnectionTimeMap map2, @NotNull Function<ConnectedDevice, String> getName) {
        this.myProject = project;
        this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled = selectDeviceSnapshotComboBoxSnapshotsEnabled;
        this.myVirtualDevicesWorker = new Worker();
        this.myConnectedDevicesWorker = new Worker();
        this.myMap = map2;
        this.myGetName = getName;
    }

    public void dispose() {
    }

    @NotNull
    static AsyncDevicesGetter getInstance(@NotNull Project project) {
        return (AsyncDevicesGetter)project.getService(AsyncDevicesGetter.class);
    }

    @NotNull
    Optional<List<Device>> get() {
        this.initChecker(RunManager.getInstance((Project)this.myProject).getSelectedConfiguration(), AndroidFacet::getInstance);
        File adb = AndroidSdkUtils.getAdb(this.myProject);
        if (adb == null) {
            Logger.getInstance(AsyncDevicesGetter.class).info("adb not found");
            return Optional.empty();
        }
        DdmlibAndroidDebugBridge bridge = new DdmlibAndroidDebugBridge(adb);
        if (!bridge.isConnected()) {
            Logger.getInstance(AsyncDevicesGetter.class).info("ADB is not connected");
            return Optional.empty();
        }
        VirtualDevicesTask virtualDevicesTask = new VirtualDevicesTask.Builder().setExecutorService(AppExecutorUtil.getAppExecutorService()).setGetAvds(() -> AvdManagerConnection.getDefaultAvdManagerConnection().getAvds(false)).setSelectDeviceSnapshotComboBoxSnapshotsEnabled(this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled).setFileSystem(FileSystems.getDefault()).setNewLaunchableAndroidDevice(LaunchableAndroidDevice::new).setChecker(this.myChecker).build();
        Optional<Collection<VirtualDevice>> virtualDevices = this.myVirtualDevicesWorker.perform(virtualDevicesTask);
        Optional<List<ConnectedDevice>> connectedDevices = this.myConnectedDevicesWorker.perform(new ConnectedDevicesTask(bridge, this.myChecker));
        if (!virtualDevices.isPresent() || !connectedDevices.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.getImpl(virtualDevices.get(), (Collection<ConnectedDevice>)connectedDevices.get()));
    }

    @NotNull
    @VisibleForTesting
    List<Device> getImpl(@NotNull Collection<VirtualDevice> virtualDevices, @NotNull Collection<ConnectedDevice> connectedDevices) {
        Stream deviceStream = Streams.concat((Stream[])new Stream[]{this.connectedVirtualDeviceStream(connectedDevices, virtualDevices), this.physicalDeviceStream(connectedDevices), AsyncDevicesGetter.disconnectedVirtualDeviceStream(virtualDevices, connectedDevices)});
        List<Device> devices2 = deviceStream.collect(Collectors.toList());
        Collection keys = devices2.stream().filter(Device::isConnected).map(Device::getKey).collect(Collectors.toList());
        this.myMap.retainAll(keys);
        return devices2;
    }

    @NotNull
    private Stream<VirtualDevice> connectedVirtualDeviceStream(@NotNull Collection<ConnectedDevice> connectedDevices, @NotNull Collection<VirtualDevice> virtualDevices) {
        return connectedDevices.stream().filter(ConnectedDevice::isVirtualDevice).map(device -> VirtualDevice.newConnectedDevice(device, this.myMap, AsyncDevicesGetter.findFirst(virtualDevices, device.getKey()).orElse(null)));
    }

    @NotNull
    private static @NotNull Optional<@NotNull VirtualDevice> findFirst(@NotNull @NotNull Collection<@NotNull VirtualDevice> devices2, @NotNull Key key) {
        return devices2.stream().filter(device -> device.matches(key)).findFirst();
    }

    @NotNull
    private Stream<PhysicalDevice> physicalDeviceStream(@NotNull Collection<ConnectedDevice> connectedDevices) {
        return connectedDevices.stream().filter(ConnectedDevice::isPhysicalDevice).map(device -> PhysicalDevice.newDevice(device, this.myGetName, this.myMap));
    }

    @NotNull
    private static Stream<VirtualDevice> disconnectedVirtualDeviceStream(@NotNull Collection<VirtualDevice> virtualDevices, @NotNull Collection<ConnectedDevice> connectedDevices) {
        Collection connectedVirtualDeviceKeys = connectedDevices.stream().filter(ConnectedDevice::isVirtualDevice).map(Device::getKey).collect(Collectors.toSet());
        return virtualDevices.stream().filter(device -> !device.hasKeyContainedBy(connectedVirtualDeviceKeys));
    }

    @VisibleForTesting
    void initChecker(@Nullable RunnerAndConfigurationSettings configurationAndSettings, @NotNull Function<Module, AndroidFacet> facetGetter) {
        if (configurationAndSettings == null) {
            this.myChecker = null;
            return;
        }
        RunConfiguration configuration = configurationAndSettings.getConfiguration();
        if (!(configuration instanceof ModuleBasedConfiguration)) {
            this.myChecker = null;
            return;
        }
        Module module2 = ((ModuleBasedConfiguration)configuration).getConfigurationModule().getModule();
        if (module2 == null) {
            this.myChecker = null;
            return;
        }
        AndroidFacet facet2 = facetGetter.apply(module2);
        if (facet2 == null || Disposer.isDisposed((Disposable)facet2)) {
            this.myChecker = null;
            return;
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            this.myChecker = null;
            return;
        }
        this.myChecker = LaunchCompatibilityCheckerImpl.create(facet2, null, null);
    }

    @VisibleForTesting
    Object getChecker() {
        return this.myChecker;
    }
}

