/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity.manifest;

import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.android.tools.idea.run.activity.manifest.IntentFilter;
import com.android.tools.idea.run.activity.manifest.XmlNode;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeActivity
extends DefaultActivityLocator.ActivityWrapper {
    protected String myName = "";
    protected String myQname = "";
    protected boolean myEnabled = true;
    protected boolean myExported = true;
    protected List<IntentFilter> myIntentFilters = new ArrayList<IntentFilter>();

    public NodeActivity(@NotNull XmlNode node2, @NotNull String packageName) {
        for (String attribute : node2.attributes().keySet()) {
            String value2 = node2.attributes().get(attribute);
            if ("name".equals(attribute)) {
                this.myName = value2;
                if (this.myName.startsWith(".")) {
                    this.myQname = packageName + this.myName;
                    continue;
                }
                this.myQname = this.myName;
                continue;
            }
            if ("enabled".equals(attribute)) {
                this.myEnabled = value2.isEmpty() || "true".equals(value2);
                continue;
            }
            if (!"exported".equals(attribute)) continue;
            this.myExported = value2.isEmpty() || "true".equals(value2);
        }
        for (XmlNode child : node2.childs()) {
            if (!"intent-filter".equals(child.name())) continue;
            IntentFilter intentFilter = NodeActivity.parseIntentFilter(child);
            this.myIntentFilters.add(intentFilter);
        }
    }

    @NotNull
    private static IntentFilter parseIntentFilter(@NotNull XmlNode node2) {
        IntentFilter intentFilter = new IntentFilter();
        for (XmlNode child : node2.childs()) {
            if ("action".equals(child.name())) {
                String action2 = NodeActivity.getNameChildNodeValue(child);
                intentFilter.addAction(action2);
                continue;
            }
            if (!"category".equals(child.name())) continue;
            String category = NodeActivity.getNameChildNodeValue(child);
            intentFilter.addCategory(category);
        }
        return intentFilter;
    }

    @NotNull
    private static String getNameChildNodeValue(@NotNull XmlNode node2) {
        for (String attribute : node2.attributes().keySet()) {
            if (!"name".equals(attribute)) continue;
            return node2.attributes().get(attribute);
        }
        return "";
    }

    @Override
    public boolean hasCategory(@NotNull String name) {
        for (IntentFilter intentFilter : this.myIntentFilters) {
            if (!intentFilter.hasCategory(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAction(@NotNull String name) {
        for (IntentFilter intentFilter : this.myIntentFilters) {
            if (!intentFilter.hasAction(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabled;
    }

    @Override
    @Nullable
    public Boolean getExported() {
        return this.myExported;
    }

    @Override
    public boolean hasIntentFilter() {
        return !this.myIntentFilters.isEmpty();
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        return this.myQname;
    }

    @NotNull
    String getName() {
        return this.myName;
    }

    @NotNull
    public List<IntentFilter> getIntentFilters() {
        return this.myIntentFilters;
    }
}

