/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity.manifest;

import com.android.tools.idea.run.activity.manifest.BinaryXmlParser;
import com.android.tools.idea.run.activity.manifest.NodeActivity;
import com.android.tools.idea.run.activity.manifest.XmlNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ManifestActivityInfo {
    private List<NodeActivity> myActivities = new ArrayList<NodeActivity>();
    private String myPackageName = "";

    private ManifestActivityInfo() {
    }

    @NotNull
    public String packageName() {
        return this.myPackageName;
    }

    @NotNull
    public List<NodeActivity> activities() {
        return this.myActivities;
    }

    @NotNull
    public static ManifestActivityInfo parseBinaryFromStream(@NotNull InputStream inputStream) throws IOException {
        XmlNode node2 = BinaryXmlParser.parse(inputStream);
        ManifestActivityInfo manifest = new ManifestActivityInfo();
        manifest.parseNode(node2);
        return manifest;
    }

    private void parseNode(@NotNull XmlNode node2) {
        for (String attribute : node2.attributes().keySet()) {
            String value2 = node2.attributes().get(attribute);
            if (!"package".equals(attribute)) continue;
            this.myPackageName = value2;
        }
        for (XmlNode child : node2.childs()) {
            if (!"application".equals(child.name())) continue;
            this.parseApplication(child);
        }
    }

    private void parseApplication(@NotNull XmlNode node2) {
        for (XmlNode child : node2.childs()) {
            if (!"activity".equals(child.name()) && !"activity-alias".equals(child.name())) continue;
            NodeActivity activity = new NodeActivity(child, this.myPackageName);
            this.myActivities.add(activity);
        }
    }
}

