/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.activity.ActivityLocator;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class MavenDefaultActivityLocator
extends ActivityLocator {
    private final AndroidFacet myFacet;

    public MavenDefaultActivityLocator(@NotNull AndroidFacet facet2) {
        this.myFacet = facet2;
    }

    @Override
    public void validate() throws ActivityLocator.ActivityLocatorException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String getQualifiedActivityName(@NotNull IDevice device) throws ActivityLocator.ActivityLocatorException {
        File manifestCopy = null;
        try {
            Manifest manifest;
            Pair<File, String> pair;
            try {
                pair = ApkProviderUtil.getCopyOfCompilerManifestFile(this.myFacet);
            }
            catch (IOException e) {
                throw new ActivityLocator.ActivityLocatorException("Error while obtaining compiler manifest file", e);
            }
            manifestCopy = pair != null ? (File)pair.getFirst() : null;
            VirtualFile manifestVFile = manifestCopy != null ? LocalFileSystem.getInstance().findFileByIoFile(manifestCopy) : null;
            Manifest manifest2 = manifest = manifestVFile == null ? null : AndroidUtils.loadDomElement(this.myFacet.getModule(), manifestVFile, Manifest.class);
            if (manifest == null) {
                throw new ActivityLocator.ActivityLocatorException("Cannot find AndroidManifest.xml file");
            }
            String defaultLauncherActivityName = DefaultActivityLocator.getDefaultLauncherActivityName(this.myFacet.getModule().getProject(), manifest);
            if (defaultLauncherActivityName == null) {
                throw new ActivityLocator.ActivityLocatorException("Could not locate default activity to launch.");
            }
            String string = defaultLauncherActivityName;
            return string;
        }
        finally {
            if (manifestCopy != null) {
                FileUtil.delete((File)manifestCopy.getParentFile());
            }
        }
    }
}

